/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.resource.exceptions;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.kie.kogito.internal.process.runtime.WorkItemNotFoundException;
import org.kie.kogito.process.NodeInstanceNotFoundException;
import org.kie.kogito.process.NodeNotFoundException;
import org.kie.kogito.process.ProcessInstanceDuplicatedException;
import org.kie.kogito.process.ProcessInstanceExecutionException;
import org.kie.kogito.process.ProcessInstanceNotFoundException;
import org.kie.kogito.process.VariableViolationException;
import org.kie.kogito.process.workitem.InvalidLifeCyclePhaseException;
import org.kie.kogito.process.workitem.InvalidTransitionException;
import org.kie.kogito.process.workitem.NotAuthorizedException;
import org.kie.kogito.process.workitem.WorkItemExecutionException;

public abstract class BaseExceptionsHandler<T> {
    public static final String MESSAGE = "message";
    public static final String PROCESS_INSTANCE_ID = "processInstanceId";
    private static final String TASK_ID = "taskId";
    public static final String VARIABLE = "variable";
    public static final String NODE_INSTANCE_ID = "nodeInstanceId";
    public static final String NODE_ID = "nodeId";
    public static final String FAILED_NODE_ID = "failedNodeId";
    public static final String ID = "id";
    private final Map<Class<? extends Exception>, FunctionHolder<T, ?>> mapper;
    private final FunctionHolder<T, Exception> defaultHolder = new FunctionHolder(ex -> ex, ex -> this::internalError);

    protected BaseExceptionsHandler() {
        this.mapper = new HashMap();
        this.mapper.put(InvalidLifeCyclePhaseException.class, new FunctionHolder(ex -> Collections.singletonMap(MESSAGE, ex.getMessage()), ex -> this::badRequest));
        this.mapper.put(InvalidTransitionException.class, new FunctionHolder(ex -> Collections.singletonMap(MESSAGE, ex.getMessage()), ex -> this::badRequest));
        this.mapper.put(NodeInstanceNotFoundException.class, new FunctionHolder(ex -> {
            NodeInstanceNotFoundException exception = (NodeInstanceNotFoundException)ex;
            HashMap<String, String> response = new HashMap<String, String>();
            response.put(MESSAGE, exception.getMessage());
            response.put(PROCESS_INSTANCE_ID, exception.getProcessInstanceId());
            response.put(NODE_INSTANCE_ID, exception.getNodeInstanceId());
            return response;
        }, ex -> this::notFound));
        this.mapper.put(NodeNotFoundException.class, new FunctionHolder(ex -> {
            NodeNotFoundException exception = (NodeNotFoundException)ex;
            HashMap<String, String> response = new HashMap<String, String>();
            response.put(MESSAGE, exception.getMessage());
            response.put(PROCESS_INSTANCE_ID, exception.getProcessInstanceId());
            response.put(NODE_ID, exception.getNodeId());
            return response;
        }, ex -> this::notFound));
        this.mapper.put(NotAuthorizedException.class, new FunctionHolder(ex -> Collections.singletonMap(MESSAGE, ex.getMessage()), ex -> this::forbidden));
        this.mapper.put(ProcessInstanceDuplicatedException.class, new FunctionHolder(ex -> {
            ProcessInstanceDuplicatedException exception = (ProcessInstanceDuplicatedException)ex;
            HashMap<String, String> response = new HashMap<String, String>();
            response.put(MESSAGE, exception.getMessage());
            response.put(PROCESS_INSTANCE_ID, exception.getProcessInstanceId());
            return response;
        }, ex -> this::conflict));
        this.mapper.put(ProcessInstanceExecutionException.class, new FunctionHolder(ex -> {
            ProcessInstanceExecutionException exception = (ProcessInstanceExecutionException)ex;
            HashMap<String, String> response = new HashMap<String, String>();
            response.put(ID, exception.getProcessInstanceId());
            response.put(FAILED_NODE_ID, exception.getFailedNodeId());
            response.put(MESSAGE, exception.getErrorMessage());
            return response;
        }, ex -> this::internalError));
        this.mapper.put(ProcessInstanceNotFoundException.class, new FunctionHolder(ex -> {
            ProcessInstanceNotFoundException exception = (ProcessInstanceNotFoundException)ex;
            HashMap<String, String> response = new HashMap<String, String>();
            response.put(MESSAGE, exception.getMessage());
            response.put(PROCESS_INSTANCE_ID, exception.getProcessInstanceId());
            return response;
        }, ex -> this::notFound));
        this.mapper.put(WorkItemNotFoundException.class, new FunctionHolder(ex -> {
            WorkItemNotFoundException exception = (WorkItemNotFoundException)ex;
            return Map.of(MESSAGE, exception.getMessage(), TASK_ID, exception.getWorkItemId());
        }, ex -> this::notFound));
        this.mapper.put(VariableViolationException.class, new FunctionHolder(ex -> {
            VariableViolationException exception = (VariableViolationException)ex;
            HashMap<String, Object> response = new HashMap<String, Object>();
            response.put(MESSAGE, exception.getMessage() + " : " + exception.getErrorMessage());
            response.put(PROCESS_INSTANCE_ID, exception.getProcessInstanceId());
            response.put(VARIABLE, exception.getVariableName());
            return response;
        }, ex -> this::badRequest));
        this.mapper.put(WorkItemExecutionException.class, new FunctionHolder(ex -> Map.of(MESSAGE, ex.getMessage()), ex -> this.fromErrorCode(((WorkItemExecutionException)ex).getErrorCode())));
        this.mapper.put(IllegalArgumentException.class, new FunctionHolder(ex -> Collections.singletonMap(MESSAGE, ex.getMessage()), ex -> this::badRequest));
    }

    private <R> Function<R, T> fromErrorCode(String errorCode) {
        switch (errorCode) {
            case "400": {
                return this::badRequest;
            }
            case "403": {
                return this::forbidden;
            }
            case "404": {
                return this::notFound;
            }
            case "409": {
                return this::conflict;
            }
        }
        return this::internalError;
    }

    protected abstract <R> T badRequest(R var1);

    protected abstract <R> T conflict(R var1);

    protected abstract <R> T internalError(R var1);

    protected abstract <R> T notFound(R var1);

    protected abstract <R> T forbidden(R var1);

    public <R extends Exception, U> T mapException(R exception) {
        FunctionHolder<T, Exception> holder = this.mapper.getOrDefault(exception.getClass(), this.defaultHolder);
        Exception body = holder.getContentGenerator().apply(exception);
        if (exception instanceof ProcessInstanceExecutionException || exception instanceof WorkItemExecutionException) {
            for (Throwable rootCause = exception.getCause(); rootCause != null; rootCause = rootCause.getCause()) {
                if (!this.mapper.containsKey(rootCause.getClass())) continue;
                holder = this.mapper.get(rootCause.getClass());
                break;
            }
        }
        return holder.getResponseGenerator().apply(exception).apply(body);
    }

    private static class FunctionHolder<T, R> {
        private final Function<Exception, R> contentGenerator;
        private final Function<Exception, Function<R, T>> responseGenerator;

        public FunctionHolder(Function<Exception, R> contentGenerator, Function<Exception, Function<R, T>> responseGenerator) {
            this.contentGenerator = contentGenerator;
            this.responseGenerator = responseGenerator;
        }

        public Function<Exception, R> getContentGenerator() {
            return this.contentGenerator;
        }

        public Function<Exception, Function<R, T>> getResponseGenerator() {
            return this.responseGenerator;
        }
    }
}

