/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.quarkus.addons.common.deployment;

import io.quarkus.deployment.Capabilities;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.Produce;
import io.quarkus.deployment.pkg.builditem.ArtifactResultBuildItem;
import java.util.Arrays;
import java.util.List;
import org.kie.kogito.quarkus.addons.common.deployment.KogitoCapability;

public abstract class OneOfCapabilityKogitoAddOnProcessor {
    private final List<KogitoCapability> requiredCapabilities;

    public OneOfCapabilityKogitoAddOnProcessor(KogitoCapability ... capabilities) {
        if (capabilities == null || capabilities.length == 0) {
            throw new IllegalArgumentException("Please set at least one capability");
        }
        this.requiredCapabilities = Arrays.asList(capabilities);
    }

    @BuildStep
    @Produce(value=ArtifactResultBuildItem.class)
    void verifyCapabilities(Capabilities capabilities) {
        boolean anyMatch = this.requiredCapabilities.stream().anyMatch(kc -> capabilities.isPresent(kc.getCapability()));
        if (!anyMatch) {
            throw this.exceptionForRequiredCapabilities(this.requiredCapabilities);
        }
    }

    private IllegalStateException exceptionForRequiredCapabilities(List<KogitoCapability> missingCapabilities) {
        StringBuilder sb = new StringBuilder();
        sb.append("At least one of the following capabilities are missing: \n");
        missingCapabilities.forEach(c -> {
            sb.append("\t - ").append(c.getCapability()).append("\n");
            sb.append("\t\t offered by the artifact ").append("org.kie.kogito").append(":").append(c.getOfferedBy()).append("\n");
        });
        sb.append("Add the above artifacts in your project's pom.xml file");
        return new IllegalStateException(sb.toString());
    }
}

