/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workflow.instance.node;

import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import org.jbpm.process.instance.InternalProcessRuntime;
import org.jbpm.process.instance.context.exception.ExceptionScopeInstance;
import org.jbpm.workflow.core.node.TimerNode;
import org.jbpm.workflow.instance.node.StateBasedNodeInstance;
import org.kie.api.runtime.process.EventListener;
import org.kie.kogito.internal.process.runtime.KogitoNodeInstance;
import org.kie.kogito.internal.process.workitem.WorkItemExecutionException;
import org.kie.kogito.jobs.ExpirationTime;
import org.kie.kogito.jobs.JobDescription;
import org.kie.kogito.jobs.JobsService;
import org.kie.kogito.jobs.descriptors.ProcessInstanceJobDescription;
import org.kie.kogito.process.BaseEventDescription;
import org.kie.kogito.process.EventDescription;
import org.kie.kogito.services.uow.BaseWorkUnit;
import org.kie.kogito.timer.TimerInstance;
import org.kie.kogito.uow.WorkUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimerNodeInstance
extends StateBasedNodeInstance
implements EventListener {
    private static final Logger logger = LoggerFactory.getLogger(TimerNodeInstance.class);
    private static final long serialVersionUID = 510L;
    public static final String TIMER_TRIGGERED_EVENT = "timerTriggered";
    private String timerId;

    public TimerNode getTimerNode() {
        return (TimerNode)this.getNode();
    }

    public String getTimerId() {
        return this.timerId;
    }

    public void internalSetTimerId(String timerId) {
        this.timerId = timerId;
    }

    @Override
    public void internalTrigger(KogitoNodeInstance from, String type) {
        if (!"DROOLS_DEFAULT".equals(type)) {
            throw new IllegalArgumentException("A TimerNode only accepts default incoming connections!");
        }
        this.triggerTime = new Date();
        ExpirationTime expirationTime = this.createTimerInstance(this.getTimerNode().getTimer());
        if (this.getTimerInstances() == null) {
            this.addTimerListener();
        }
        this.internalSetTimerId(UUID.randomUUID().toString());
        InternalProcessRuntime processRuntime = (InternalProcessRuntime)this.getProcessInstance().getKnowledgeRuntime().getProcessRuntime();
        processRuntime.getUnitOfWorkManager().currentUnitOfWork().intercept((WorkUnit)new BaseWorkUnit((Object)this, instance -> {
            ProcessInstanceJobDescription jobDescription = ProcessInstanceJobDescription.newProcessInstanceJobDescriptionBuilder().id(this.getTimerId()).timerId("-1").expirationTime(expirationTime).processInstanceId(this.getProcessInstance().getStringId()).rootProcessInstanceId(this.getProcessInstance().getRootProcessInstanceId()).processId(this.getProcessInstance().getProcessId()).rootProcessId(this.getProcessInstance().getRootProcessId()).nodeInstanceId(this.getId()).build();
            JobsService jobService = processRuntime.getJobsService();
            String jobId = jobService.scheduleJob((JobDescription)jobDescription);
            this.internalSetTimerId(jobId);
        }, i -> {}, Integer.valueOf(1000)));
    }

    @Override
    public void signalEvent(String type, Object event) {
        TimerInstance timer;
        if (TIMER_TRIGGERED_EVENT.equals(type) && Objects.equals((timer = (TimerInstance)event).getId(), this.getTimerId())) {
            this.triggerCompleted(timer.getRepeatLimit() <= 0);
        }
    }

    @Override
    public String[] getEventTypes() {
        return new String[]{TIMER_TRIGGERED_EVENT};
    }

    @Override
    public void triggerCompleted(boolean remove) {
        WorkItemExecutionException e = new WorkItemExecutionException("TimedOut");
        ExceptionScopeInstance esi = (ExceptionScopeInstance)this.resolveContextInstance("ExceptionScope", e);
        if (esi != null) {
            logger.debug("Triggering exception handler for {}", (Object)e.getClass().getName());
            esi.handleException((Throwable)e, this.getProcessContext((Throwable)e));
        } else {
            logger.trace("No exception handler for {}", (Object)e.getClass().getName());
            this.triggerCompleted("DROOLS_DEFAULT", remove);
        }
    }

    @Override
    public void cancel(KogitoNodeInstance.CancelType cancelType) {
        ((InternalProcessRuntime)this.getProcessInstance().getKnowledgeRuntime().getProcessRuntime()).getJobsService().cancelJob(this.timerId);
        super.cancel(cancelType);
    }

    @Override
    public void addEventListeners() {
        super.addEventListeners();
        if (this.getTimerInstances() == null) {
            this.addTimerListener();
        }
    }

    @Override
    public void removeEventListeners() {
        super.removeEventListeners();
        this.getProcessInstance().removeEventListener(TIMER_TRIGGERED_EVENT, this, false);
    }

    public Set<EventDescription<?>> getEventDescriptions() {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("TimerID", this.getTimerId());
        properties.put("Delay", this.getTimerNode().getTimer().getDelay());
        properties.put("Period", this.getTimerNode().getTimer().getPeriod());
        properties.put("Date", this.getTimerNode().getTimer().getDate());
        return Collections.singleton(new BaseEventDescription(TIMER_TRIGGERED_EVENT, this.getNodeDefinitionId(), this.getNodeName(), "timer", this.getStringId(), this.getProcessInstance().getStringId(), null, properties));
    }
}

