/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workflow.instance.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.regex.Matcher;
import org.drools.core.common.InternalKnowledgeRuntime;
import org.jbpm.process.core.Context;
import org.jbpm.process.core.ContextContainer;
import org.jbpm.process.core.context.variable.Variable;
import org.jbpm.process.core.context.variable.VariableScope;
import org.jbpm.process.instance.ContextInstance;
import org.jbpm.process.instance.ContextInstanceContainer;
import org.jbpm.process.instance.InternalProcessRuntime;
import org.jbpm.process.instance.context.exception.ExceptionScopeInstance;
import org.jbpm.process.instance.context.exclusive.ExclusiveGroupInstance;
import org.jbpm.process.instance.context.variable.VariableScopeInstance;
import org.jbpm.process.instance.impl.Action;
import org.jbpm.process.instance.impl.ConstraintEvaluator;
import org.jbpm.util.ContextFactory;
import org.jbpm.util.PatternConstants;
import org.jbpm.workflow.core.Constraint;
import org.jbpm.workflow.core.NodeContainer;
import org.jbpm.workflow.core.impl.NodeImpl;
import org.jbpm.workflow.instance.NodeInstance;
import org.jbpm.workflow.instance.NodeInstanceContainer;
import org.jbpm.workflow.instance.WorkflowProcessInstance;
import org.jbpm.workflow.instance.WorkflowProcessParameters;
import org.jbpm.workflow.instance.WorkflowRuntimeException;
import org.jbpm.workflow.instance.impl.MVELProcessHelper;
import org.jbpm.workflow.instance.impl.NodeInstanceResolverFactory;
import org.jbpm.workflow.instance.impl.WorkflowProcessInstanceImpl;
import org.jbpm.workflow.instance.node.CompositeNodeInstance;
import org.kie.api.definition.process.Connection;
import org.kie.api.definition.process.Node;
import org.kie.api.definition.process.WorkflowElementIdentifier;
import org.kie.api.runtime.KieRuntime;
import org.kie.kogito.internal.process.runtime.KogitoNode;
import org.kie.kogito.internal.process.runtime.KogitoNodeInstance;
import org.kie.kogito.internal.process.runtime.KogitoNodeInstanceContainer;
import org.kie.kogito.internal.process.runtime.KogitoProcessContext;
import org.kie.kogito.process.ProcessInstanceExecutionException;
import org.mvel2.integration.VariableResolverFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class NodeInstanceImpl
implements NodeInstance,
Serializable {
    private static final long serialVersionUID = 510L;
    protected static final Logger logger = LoggerFactory.getLogger(NodeInstanceImpl.class);
    private String id;
    private WorkflowElementIdentifier nodeId;
    private WorkflowProcessInstance processInstance;
    private NodeInstanceContainer nodeInstanceContainer;
    private Map<String, Object> metaData = new HashMap<String, Object>();
    private int level;
    protected int slaCompliance = 0;
    protected Date slaDueDate;
    protected String slaTimerId;
    protected Date triggerTime;
    protected Date leaveTime;
    protected transient KogitoNodeInstance.CancelType cancelType;
    protected transient Map<String, Object> dynamicParameters;

    public void setId(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public String getStringId() {
        return this.id;
    }

    public void setNodeId(WorkflowElementIdentifier nodeId) {
        this.nodeId = nodeId;
    }

    public WorkflowElementIdentifier getNodeId() {
        return this.nodeId;
    }

    public String getNodeName() {
        Node node = this.getNode();
        return node == null ? "" : node.getName();
    }

    public String getNodeDefinitionId() {
        return this.getNode().getUniqueId();
    }

    @Override
    public int getLevel() {
        return this.level;
    }

    public void setLevel(int level) {
        this.level = level;
    }

    public void setProcessInstance(WorkflowProcessInstance processInstance) {
        this.processInstance = processInstance;
    }

    public WorkflowProcessInstance getProcessInstance() {
        return this.processInstance;
    }

    public KogitoNodeInstanceContainer getNodeInstanceContainer() {
        return this.nodeInstanceContainer;
    }

    public void setNodeInstanceContainer(KogitoNodeInstanceContainer nodeInstanceContainer) {
        this.nodeInstanceContainer = (NodeInstanceContainer)nodeInstanceContainer;
        if (nodeInstanceContainer != null) {
            this.nodeInstanceContainer.addNodeInstance(this);
        }
    }

    @Override
    public Node getNode() {
        if (this.nodeId == null) {
            return null;
        }
        try {
            return ((NodeContainer)this.nodeInstanceContainer.getNodeContainer()).internalGetNode(this.nodeId);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Unknown node id: " + this.nodeId + " for node instance " + this.getUniqueId() + " for process instance " + this.processInstance, e);
        }
    }

    public boolean isInversionOfControl() {
        return false;
    }

    public KogitoNodeInstance.CancelType getCancelType() {
        return this.cancelType;
    }

    @Override
    public final void cancel() {
        this.cancel(KogitoNodeInstance.CancelType.ABORTED);
    }

    @Override
    public void cancel(KogitoNodeInstance.CancelType cancelType) {
        InternalKnowledgeRuntime kruntime;
        this.cancelType = cancelType;
        if (this.triggerTime == null) {
            this.triggerTime = new Date();
        }
        this.leaveTime = new Date();
        boolean hidden = false;
        Node node = this.getNode();
        if (node != null && node.getMetaData().get("hidden") != null) {
            hidden = true;
        }
        if (!hidden) {
            kruntime = this.getProcessInstance().getKnowledgeRuntime();
            ((InternalProcessRuntime)kruntime.getProcessRuntime()).getProcessEventSupport().fireBeforeNodeLeft((KogitoNodeInstance)this, (KieRuntime)kruntime);
        }
        this.nodeInstanceContainer.removeNodeInstance(this);
        if (!hidden) {
            kruntime = this.getProcessInstance().getKnowledgeRuntime();
            ((InternalProcessRuntime)kruntime.getProcessRuntime()).getProcessEventSupport().fireAfterNodeLeft((KogitoNodeInstance)this, (KieRuntime)kruntime);
        }
    }

    @Override
    public final void trigger(KogitoNodeInstance from, String type) {
        boolean hidden = false;
        if (this.getNode().getMetaData().get("hidden") != null) {
            hidden = true;
        }
        if (from != null) {
            int level = ((NodeInstance)from).getLevel();
            ((NodeInstanceContainer)this.getNodeInstanceContainer()).setCurrentLevel(level);
            List incoming = this.getNode().getIncomingConnections(type);
            for (Connection conn : incoming) {
                if (!conn.getFrom().getId().equals((Object)from.getNodeId())) continue;
                this.metaData.put("IncomingConnection", conn.getUniqueId());
                break;
            }
        }
        if (this.dynamicParameters != null) {
            for (Map.Entry<String, Object> entry : this.dynamicParameters.entrySet()) {
                this.setVariable(entry.getKey(), entry.getValue());
            }
        }
        this.configureSla();
        InternalKnowledgeRuntime kruntime = this.getProcessInstance().getKnowledgeRuntime();
        if (!hidden) {
            ((InternalProcessRuntime)kruntime.getProcessRuntime()).getProcessEventSupport().fireBeforeNodeTriggered((KogitoNodeInstance)this, (KieRuntime)kruntime);
        }
        try {
            this.internalTrigger(from, type);
        }
        catch (Exception e) {
            if (!WorkflowProcessParameters.WORKFLOW_PARAM_TRANSACTIONS.get(this.getProcessInstance().getProcess()).booleanValue()) {
                logger.error("Node instance causing process instance error in id {} in a non transactional environment", (Object)this.getStringId());
                this.captureError(e);
                return;
            }
            logger.error("Node instance causing process instance error in id {} in a transactional environment (Wrapping)", (Object)this.getStringId());
            throw new ProcessInstanceExecutionException(this.getProcessInstance().getId(), this.getNodeDefinitionId(), e.getMessage(), (Throwable)e);
        }
        if (!hidden) {
            ((InternalProcessRuntime)kruntime.getProcessRuntime()).getProcessEventSupport().fireAfterNodeTriggered((KogitoNodeInstance)this, (KieRuntime)kruntime);
        }
    }

    protected void captureError(Exception e) {
        this.getProcessInstance().setErrorState(this, e);
    }

    public abstract void internalTrigger(KogitoNodeInstance var1, String var2);

    protected void executeAction(Action action, KogitoProcessContext context) {
        try {
            action.execute(context);
        }
        catch (Exception e) {
            ExceptionScopeInstance exceptionScopeInstance = (ExceptionScopeInstance)this.resolveContextInstance("ExceptionScope", e);
            if (exceptionScopeInstance == null) {
                throw new WorkflowRuntimeException(this, this.getProcessInstance(), "Unable to execute Action: " + e.getMessage(), e);
            }
            context.getContextData().put("Exception", e);
            exceptionScopeInstance.handleException(e, context);
            this.cancel(KogitoNodeInstance.CancelType.ERROR);
        }
    }

    protected void executeAction(Action action) {
        this.executeAction(action, ContextFactory.fromNode(this));
    }

    public void triggerCompleted(String type, boolean remove) {
        this.leaveTime = new Date();
        Node node = this.getNode();
        if (node != null) {
            String uniqueId = node.getUniqueId();
            if (uniqueId == null) {
                uniqueId = ((NodeImpl)node).getUniqueId();
            }
            ((WorkflowProcessInstanceImpl)this.processInstance).addCompletedNodeId(uniqueId);
            ((WorkflowProcessInstanceImpl)this.processInstance).getIterationLevels().remove(uniqueId);
        }
        if (this.getNodeInstanceContainer().getNodeInstance(this.getStringId()) == null || ((NodeInstanceContainer)this.getNodeInstanceContainer()).getState() != 1) {
            return;
        }
        if (remove) {
            ((NodeInstanceContainer)this.getNodeInstanceContainer()).removeNodeInstance(this);
        }
        List<Connection> connections = null;
        if (node != null) {
            if (WorkflowProcessParameters.WORKFLOW_PARAM_MULTIPLE_CONNECTIONS.get(this.getProcessInstance().getProcess()).booleanValue() && !((NodeImpl)node).getConstraints().isEmpty()) {
                connections = ((NodeImpl)node).getDefaultOutgoingConnections();
                boolean found = false;
                ArrayList<NodeInstanceTrigger> arrayList = new ArrayList<NodeInstanceTrigger>();
                ArrayList<Connection> outgoingCopy = new ArrayList<Connection>(connections);
                while (!outgoingCopy.isEmpty()) {
                    int priority = Integer.MAX_VALUE;
                    Connection selectedConnection = null;
                    ConstraintEvaluator selectedConstraint = null;
                    for (Connection connection : outgoingCopy) {
                        Collection<Constraint> constraints = ((NodeImpl)node).getConstraints(connection);
                        if (constraints == null) continue;
                        for (Constraint constraint : constraints) {
                            if (!(constraint instanceof ConstraintEvaluator) || constraint.getPriority() >= priority || constraint.isDefault()) continue;
                            priority = constraint.getPriority();
                            selectedConnection = connection;
                            selectedConstraint = (ConstraintEvaluator)constraint;
                        }
                    }
                    if (selectedConstraint == null) break;
                    if (selectedConstraint.evaluate(this, selectedConnection, selectedConstraint)) {
                        arrayList.add(new NodeInstanceTrigger(this.followConnection(selectedConnection), selectedConnection.getToType()));
                        found = true;
                    }
                    outgoingCopy.remove(selectedConnection);
                }
                for (NodeInstanceTrigger nodeInstance : arrayList) {
                    if (((NodeInstanceContainer)this.getNodeInstanceContainer()).getState() != 1) {
                        return;
                    }
                    this.triggerNodeInstance(nodeInstance.getNodeInstance(), nodeInstance.getToType());
                }
                if (!found) {
                    for (Connection connection : connections) {
                        Collection<Constraint> constraints = ((NodeImpl)node).getConstraints(connection);
                        if (constraints != null) {
                            for (Constraint constraint : constraints) {
                                if (!constraint.isDefault()) continue;
                                this.triggerConnection(connection);
                                found = true;
                                break;
                            }
                        }
                        if (!found) continue;
                        break;
                    }
                }
                if (!found) {
                    throw new IllegalArgumentException("Uncontrolled flow node could not find at least one valid outgoing connection " + this.getNode().getName());
                }
                return;
            }
            connections = node.getOutgoingConnections(type);
        }
        if (connections == null || connections.isEmpty()) {
            boolean hidden = false;
            Node currentNode = this.getNode();
            if (currentNode != null && currentNode.getMetaData().get("hidden") != null) {
                hidden = true;
            }
            InternalKnowledgeRuntime internalKnowledgeRuntime = this.getProcessInstance().getKnowledgeRuntime();
            if (!hidden) {
                ((InternalProcessRuntime)internalKnowledgeRuntime.getProcessRuntime()).getProcessEventSupport().fireBeforeNodeLeft((KogitoNodeInstance)this, (KieRuntime)internalKnowledgeRuntime);
            }
            ((NodeInstanceContainer)this.getNodeInstanceContainer()).nodeInstanceCompleted(this, type);
            if (!hidden) {
                ((InternalProcessRuntime)internalKnowledgeRuntime.getProcessRuntime()).getProcessEventSupport().fireAfterNodeLeft((KogitoNodeInstance)this, (KieRuntime)internalKnowledgeRuntime);
            }
        } else {
            HashMap<NodeInstance, String> nodeInstances = new HashMap<NodeInstance, String>();
            for (Connection connection : connections) {
                nodeInstances.put(this.followConnection(connection), connection.getToType());
            }
            for (Map.Entry entry : nodeInstances.entrySet()) {
                if (((NodeInstanceContainer)this.getNodeInstanceContainer()).getState() != 1) {
                    return;
                }
                this.triggerNodeInstance((NodeInstance)entry.getKey(), (String)entry.getValue());
            }
        }
    }

    protected NodeInstance followConnection(Connection connection) {
        List<ContextInstance> contextInstances;
        KogitoNodeInstanceContainer parent = this.getNodeInstanceContainer();
        if (parent instanceof ContextInstanceContainer && (contextInstances = ((ContextInstanceContainer)parent).getContextInstances("ExclusiveGroup")) != null) {
            for (ContextInstance contextInstance : new ArrayList<ContextInstance>(contextInstances)) {
                ExclusiveGroupInstance groupInstance = (ExclusiveGroupInstance)contextInstance;
                if (!groupInstance.containsNodeInstance((org.kie.api.runtime.process.NodeInstance)this)) continue;
                for (KogitoNodeInstance nodeInstance : groupInstance.getNodeInstances()) {
                    if (nodeInstance == this) continue;
                    ((NodeInstance)nodeInstance).cancel(KogitoNodeInstance.CancelType.OBSOLETE);
                }
                ((ContextInstanceContainer)parent).removeContextInstance("ExclusiveGroup", contextInstance);
            }
        }
        return ((NodeInstanceContainer)this.getNodeInstanceContainer()).getNodeInstance(connection.getTo());
    }

    protected void triggerNodeInstance(NodeInstance nodeInstance, String type) {
        this.triggerNodeInstance(nodeInstance, type, true);
    }

    protected void triggerNodeInstance(NodeInstance nodeInstance, String type, boolean fireEvents) {
        this.leaveTime = new Date();
        boolean hidden = false;
        if (this.getNode().getMetaData().get("hidden") != null) {
            hidden = true;
        }
        InternalKnowledgeRuntime kruntime = this.getProcessInstance().getKnowledgeRuntime();
        if (!hidden && fireEvents) {
            ((InternalProcessRuntime)kruntime.getProcessRuntime()).getProcessEventSupport().fireBeforeNodeLeft((KogitoNodeInstance)this, (KieRuntime)kruntime);
        }
        nodeInstance.trigger(this, type);
        List outgoing = this.getNode().getOutgoingConnections(type);
        for (Connection conn : outgoing) {
            if (!conn.getTo().getId().equals((Object)nodeInstance.getNodeId())) continue;
            this.metaData.put("OutgoingConnection", conn.getUniqueId());
            break;
        }
        if (!hidden && fireEvents) {
            ((InternalProcessRuntime)kruntime.getProcessRuntime()).getProcessEventSupport().fireAfterNodeLeft((KogitoNodeInstance)this, (KieRuntime)kruntime);
        }
    }

    protected void triggerConnection(Connection connection) {
        this.triggerNodeInstance(this.followConnection(connection), connection.getToType());
    }

    public void retrigger(boolean remove) {
        if (remove) {
            this.cancel();
        }
        this.triggerNode(this.getNodeId(), !remove);
    }

    public void triggerNode(WorkflowElementIdentifier nodeId) {
        this.triggerNode(nodeId, true);
    }

    public void triggerNode(WorkflowElementIdentifier nodeId, boolean fireEvents) {
        NodeInstance nodeInstance = ((NodeInstanceContainer)this.getNodeInstanceContainer()).getNodeInstance(((KogitoNode)this.getNode()).getParentContainer().getNode(nodeId));
        this.triggerNodeInstance(nodeInstance, "DROOLS_DEFAULT", fireEvents);
    }

    public Context resolveContext(String contextId, Object param) {
        if (this.getNode() == null) {
            return null;
        }
        return ((NodeImpl)this.getNode()).resolveContext(contextId, param);
    }

    @Override
    public ContextInstance resolveContextInstance(String contextId, Object param) {
        Context context = this.resolveContext(contextId, param);
        if (context == null) {
            return null;
        }
        ContextInstanceContainer contextInstanceContainer = this.getContextInstanceContainer(context.getContextContainer());
        if (contextInstanceContainer == null) {
            throw new IllegalArgumentException("Could not find context instance container for context");
        }
        return contextInstanceContainer.getContextInstance(context);
    }

    private ContextInstanceContainer getContextInstanceContainer(ContextContainer contextContainer) {
        ContextInstanceContainer contextInstanceContainer = this instanceof ContextInstanceContainer ? (ContextInstanceContainer)((Object)this) : this.getEnclosingContextInstanceContainer(this);
        while (contextInstanceContainer != null) {
            if (contextInstanceContainer.getContextContainer() == contextContainer) {
                return contextInstanceContainer;
            }
            contextInstanceContainer = this.getEnclosingContextInstanceContainer((KogitoNodeInstance)contextInstanceContainer);
        }
        return null;
    }

    private ContextInstanceContainer getEnclosingContextInstanceContainer(KogitoNodeInstance nodeInstance) {
        org.kie.api.runtime.process.NodeInstanceContainer nodeInstanceContainer = nodeInstance.getNodeInstanceContainer();
        while (true) {
            if (nodeInstanceContainer instanceof ContextInstanceContainer) {
                return (ContextInstanceContainer)nodeInstanceContainer;
            }
            if (!(nodeInstanceContainer instanceof KogitoNodeInstance)) break;
            nodeInstanceContainer = ((KogitoNodeInstance)nodeInstanceContainer).getNodeInstanceContainer();
        }
        return null;
    }

    public Object getVariable(String variableName) {
        VariableScopeInstance variableScope = (VariableScopeInstance)this.resolveContextInstance("VariableScope", variableName);
        if (variableScope == null) {
            variableScope = (VariableScopeInstance)this.getProcessInstance().getContextInstance("VariableScope");
        }
        return variableScope.getVariable(variableName);
    }

    public void setVariable(String variableName, Object value) {
        VariableScopeInstance variableScope = (VariableScopeInstance)this.resolveContextInstance("VariableScope", variableName);
        if (variableScope == null && (variableScope = (VariableScopeInstance)this.getProcessInstance().getContextInstance("VariableScope")).getVariableScope().findVariable(variableName) == null) {
            variableScope = null;
        }
        if (variableScope == null) {
            logger.error("Could not find variable {}", (Object)variableName);
            logger.error("Using process-level scope");
            variableScope = (VariableScopeInstance)this.getProcessInstance().getContextInstance("VariableScope");
        }
        variableScope.setVariable(this, variableName, value);
    }

    public String getUniqueId() {
        StringBuilder result = new StringBuilder(this.getStringId());
        KogitoNodeInstanceContainer parent = this.getNodeInstanceContainer();
        while (parent instanceof CompositeNodeInstance) {
            CompositeNodeInstance nodeInstance = (CompositeNodeInstance)parent;
            result.insert(0, nodeInstance.getStringId() + ":");
            parent = nodeInstance.getNodeInstanceContainer();
        }
        return result.toString();
    }

    public Map<String, Object> getMetaData() {
        return this.metaData;
    }

    public Object getMetaData(String name) {
        return this.metaData.get(name);
    }

    public void setMetaData(String name, Object data) {
        this.metaData.put(name, data);
    }

    @Override
    public void setDynamicParameters(Map<String, Object> dynamicParameters) {
        this.dynamicParameters = dynamicParameters;
    }

    protected void configureSla() {
    }

    @Override
    public int getSlaCompliance() {
        return this.slaCompliance;
    }

    public void internalSetSlaCompliance(int slaCompliance) {
        this.slaCompliance = slaCompliance;
    }

    public Date getSlaDueDate() {
        return this.slaDueDate;
    }

    public void internalSetSlaDueDate(Date slaDueDate) {
        this.slaDueDate = slaDueDate;
    }

    @Override
    public String getSlaTimerId() {
        return this.slaTimerId;
    }

    public void internalSetSlaTimerId(String slaTimerId) {
        this.slaTimerId = slaTimerId;
    }

    public Date getTriggerTime() {
        return this.triggerTime;
    }

    @Override
    public void internalSetTriggerTime(Date triggerTime) {
        this.triggerTime = triggerTime;
    }

    public Date getLeaveTime() {
        return this.leaveTime;
    }

    protected Object resolveValue(Object value) {
        return value instanceof String ? this.resolveExpression((String)value) : value;
    }

    protected boolean isExpression(String expression) {
        return expression != null && PatternConstants.PARAMETER_MATCHER.matcher(expression).find();
    }

    public String resolveExpression(String expression) {
        return this.isExpression(expression) ? (String)this.resolveValue(expression) : expression;
    }

    protected Object resolveValue(String expression) {
        return this.resolveValue(expression, replacements -> {
            String expr = expression;
            for (Map.Entry replacement : replacements.entrySet()) {
                expr = expr.replace("#{" + (String)replacement.getKey() + "}", replacement.getValue() != null ? replacement.getValue().toString() : "");
            }
            return expr;
        });
    }

    protected Object resolveValue(String expression, Function<Map<String, Object>, Object> converter) {
        if (expression == null) {
            return null;
        }
        Object outcome = null;
        HashMap<String, Object> replacements = new HashMap<String, Object>();
        Matcher matcher = PatternConstants.PARAMETER_MATCHER.matcher(expression);
        if (matcher.find()) {
            matcher.reset();
            while (matcher.find()) {
                Object variableValue;
                String paramName = matcher.group(1);
                if (replacements.get(paramName) != null) continue;
                VariableScopeInstance variableScopeInstance = (VariableScopeInstance)this.resolveContextInstance("VariableScope", paramName);
                if (variableScopeInstance != null) {
                    variableValue = variableScopeInstance.getVariable(paramName);
                    replacements.put(paramName, variableValue);
                    continue;
                }
                try {
                    variableValue = MVELProcessHelper.evaluator().eval(paramName, (VariableResolverFactory)new NodeInstanceResolverFactory(this));
                    replacements.put(paramName, variableValue);
                }
                catch (Exception t) {
                    logger.error("MVEL failed to replace variable {} in process {} for node {}. Continuing without setting process id", new Object[]{paramName, this.processInstance.getProcessId(), this.getNodeName(), t});
                }
            }
            outcome = converter.apply(replacements);
        } else {
            outcome = this.getVariable(expression) != null ? this.getVariable(expression) : expression;
        }
        return outcome;
    }

    protected void mapDynamicOutputData(Map<String, Object> results) {
        if (results != null && !results.isEmpty()) {
            VariableScope variableScope = (VariableScope)((ContextContainer)this.getProcessInstance().getProcess()).getDefaultContext("VariableScope");
            VariableScopeInstance variableScopeInstance = (VariableScopeInstance)this.getProcessInstance().getContextInstance("VariableScope");
            for (Map.Entry<String, Object> result : results.entrySet()) {
                String variableName = result.getKey();
                Variable variable = variableScope.findVariable(variableName);
                if (variable == null) continue;
                variableScopeInstance.getVariableScope().validateVariable(this.getProcessInstance().getProcessName(), variableName, result.getValue());
                variableScopeInstance.setVariable(this, variableName, result.getValue());
            }
        }
    }

    protected static class NodeInstanceTrigger {
        private NodeInstance nodeInstance;
        private String toType;

        public NodeInstanceTrigger(NodeInstance nodeInstance, String toType) {
            this.nodeInstance = nodeInstance;
            this.toType = toType;
        }

        public NodeInstance getNodeInstance() {
            return this.nodeInstance;
        }

        public String getToType() {
            return this.toType;
        }
    }
}

