/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workflow.core.node;

import java.util.List;
import org.jbpm.process.core.Context;
import org.jbpm.process.core.ContextContainer;
import org.jbpm.process.core.context.AbstractContext;
import org.jbpm.process.core.impl.ContextContainerImpl;
import org.jbpm.workflow.core.node.StateBasedNode;
import org.jbpm.workflow.core.node.SubProcessFactory;
import org.jbpm.workflow.instance.WorkflowProcessParameters;
import org.kie.api.definition.process.Connection;

public class SubProcessNode
extends StateBasedNode
implements ContextContainer {
    private static final long serialVersionUID = 510L;
    private ContextContainer contextContainer = new ContextContainerImpl();
    private String processId;
    private String processName;
    private boolean waitForCompletion = true;
    private boolean independent = true;
    private SubProcessFactory<?> subProcessFactory;

    public void setProcessId(String processId) {
        this.processId = processId;
    }

    public String getProcessId() {
        return this.processId;
    }

    public boolean isWaitForCompletion() {
        return this.waitForCompletion;
    }

    public void setWaitForCompletion(boolean waitForCompletion) {
        this.waitForCompletion = waitForCompletion;
    }

    public boolean isIndependent() {
        return this.independent;
    }

    public void setIndependent(boolean independent) {
        this.independent = independent;
    }

    @Override
    public void validateAddIncomingConnection(String type, Connection connection) {
        super.validateAddIncomingConnection(type, connection);
        if (!"DROOLS_DEFAULT".equals(type)) {
            throw new IllegalArgumentException("This type of node [" + connection.getTo().getUniqueId() + ", " + connection.getTo().getName() + "] only accepts default incoming connection type!");
        }
        if (this.getFrom() != null && !WorkflowProcessParameters.WORKFLOW_PARAM_MULTIPLE_CONNECTIONS.get(this.getProcess()).booleanValue()) {
            throw new IllegalArgumentException("This type of node [" + connection.getTo().getUniqueId() + ", " + connection.getTo().getName() + "] cannot have more than one incoming connection!");
        }
    }

    @Override
    public void validateAddOutgoingConnection(String type, Connection connection) {
        super.validateAddOutgoingConnection(type, connection);
        if (!"DROOLS_DEFAULT".equals(type)) {
            throw new IllegalArgumentException("This type of node [" + connection.getFrom().getUniqueId() + ", " + connection.getFrom().getName() + "] only accepts default outgoing connection type!");
        }
        if (this.getTo() != null && !WorkflowProcessParameters.WORKFLOW_PARAM_MULTIPLE_CONNECTIONS.get(this.getProcess()).booleanValue()) {
            throw new IllegalArgumentException("This type of node [" + connection.getFrom().getUniqueId() + ", " + connection.getFrom().getName() + "] cannot have more than one outgoing connection!");
        }
    }

    public void setProcessName(String processName) {
        this.processName = processName;
    }

    public String getProcessName() {
        return this.processName;
    }

    @Override
    public List<Context> getContexts(String contextType) {
        return this.contextContainer.getContexts(contextType);
    }

    @Override
    public void addContext(Context context) {
        ((AbstractContext)context).setContextContainer(this);
        this.contextContainer.addContext(context);
    }

    @Override
    public Context getContext(String contextType, long id) {
        return this.contextContainer.getContext(contextType, id);
    }

    @Override
    public void setDefaultContext(Context context) {
        ((AbstractContext)context).setContextContainer(this);
        this.contextContainer.setDefaultContext(context);
    }

    @Override
    public Context getDefaultContext(String contextType) {
        return this.contextContainer.getDefaultContext(contextType);
    }

    @Override
    public Context getContext(String contextId) {
        Context context = this.getDefaultContext(contextId);
        if (context != null) {
            return context;
        }
        return super.getContext(contextId);
    }

    public boolean isAbortParent() {
        String abortParent = (String)this.getMetaData("customAbortParent");
        if (abortParent == null) {
            return true;
        }
        return Boolean.parseBoolean(abortParent);
    }

    public <T> void setSubProcessFactory(SubProcessFactory<T> subProcessFactory) {
        this.subProcessFactory = subProcessFactory;
    }

    public SubProcessFactory<?> getSubProcessFactory() {
        return this.subProcessFactory;
    }
}

