/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.instance.command;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlSchemaType;
import org.jbpm.process.instance.command.KogitoProcessInstanceIdCommand;
import org.kie.api.command.ExecutableCommand;
import org.kie.api.runtime.Context;
import org.kie.api.runtime.KieSession;
import org.kie.internal.command.RegistryContext;
import org.kie.kogito.internal.process.runtime.KogitoProcessInstance;
import org.kie.kogito.internal.process.runtime.KogitoProcessRuntime;
import org.kie.kogito.internal.process.runtime.KogitoWorkflowProcessInstance;

@XmlAccessorType(value=XmlAccessType.NONE)
public class GetProcessInstanceVariableCommand
implements ExecutableCommand<Object>,
KogitoProcessInstanceIdCommand {
    private static final long serialVersionUID = 6L;
    @XmlAttribute(required=true)
    @XmlSchemaType(name="string")
    private String processInstanceId;
    @XmlAttribute(required=true)
    @XmlSchemaType(name="string")
    private String variableId;

    @Override
    public String getProcessInstanceId() {
        return this.processInstanceId;
    }

    @Override
    public void setProcessInstanceId(String processInstanceId) {
        this.processInstanceId = processInstanceId;
    }

    public String getVariableId() {
        return this.variableId;
    }

    public void setVariableId(String variableId) {
        this.variableId = variableId;
    }

    public Object execute(Context context) {
        KogitoProcessRuntime runtime = (KogitoProcessRuntime)((RegistryContext)context).lookup(KieSession.class);
        if (this.processInstanceId == null) {
            return null;
        }
        KogitoProcessInstance processInstance = runtime.getProcessInstance(this.processInstanceId);
        if (processInstance == null) {
            throw new IllegalArgumentException("Could not find process instance for id " + this.processInstanceId);
        }
        if (processInstance instanceof KogitoWorkflowProcessInstance) {
            return ((KogitoWorkflowProcessInstance)processInstance).getVariable(this.variableId);
        }
        throw new IllegalStateException("Could not retrieve variable " + this.variableId + " because process instance " + this.processInstanceId + " was inaccessible!");
    }

    public String toString() {
        return "session.getProcessInstanceVariable(" + this.processInstanceId + ", " + this.variableId + ");";
    }
}

