/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.core.timer;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Objects;
import java.util.Properties;
import org.jbpm.process.core.timer.CalendarBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CalendarBeanFactory {
    private static final Logger logger = LoggerFactory.getLogger(CalendarBeanFactory.class);

    public static CalendarBean createCalendarBean() {
        URL resource = Thread.currentThread().getContextClassLoader().getResource("calendar.properties");
        if (Objects.nonNull(resource)) {
            CalendarBean calendarBean;
            block10: {
                logger.debug("URL resource: {}", (Object)resource);
                Properties calendarConfiguration = new Properties();
                InputStream is = resource.openStream();
                try {
                    calendarConfiguration.load(is);
                    calendarBean = new CalendarBean(calendarConfiguration);
                    if (is == null) break block10;
                }
                catch (Throwable throwable) {
                    try {
                        if (is != null) {
                            try {
                                is.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        String errorMessage = "Error while loading properties for business calendar";
                        logger.error(errorMessage, (Throwable)e);
                        throw new RuntimeException(errorMessage, e);
                    }
                    catch (IllegalArgumentException e) {
                        String errorMessage = "Error while populating properties for business calendar";
                        logger.error(errorMessage, (Throwable)e);
                        throw e;
                    }
                }
                is.close();
            }
            return calendarBean;
        }
        String errorMessage = String.format("Missing %s", "calendar.properties");
        logger.error(errorMessage);
        throw new RuntimeException(errorMessage);
    }
}

