/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workflow.instance.node;

import java.util.Set;
import org.jbpm.process.instance.context.swimlane.SwimlaneContextInstance;
import org.jbpm.workflow.core.node.HumanTaskNode;
import org.jbpm.workflow.core.node.WorkItemNode;
import org.jbpm.workflow.instance.node.WorkItemNodeInstance;
import org.kie.kogito.process.workitems.InternalKogitoWorkItem;

public class HumanTaskNodeInstance
extends WorkItemNodeInstance {
    private static final long serialVersionUID = 510L;
    private String separator = System.getProperty("org.jbpm.ht.user.separator", ",");
    private static final String ACTOR_ID = "ActorId";
    private static final String WORK_ITEM_TRANSITION = "workItemTransition";
    private transient SwimlaneContextInstance swimlaneContextInstance;

    public HumanTaskNode getHumanTaskNode() {
        return (HumanTaskNode)this.getNode();
    }

    @Override
    protected InternalKogitoWorkItem createWorkItem(WorkItemNode workItemNode) {
        InternalKogitoWorkItem workItem = super.createWorkItem(workItemNode);
        String actorId = this.assignWorkItem(workItem);
        if (actorId != null) {
            workItem.setParameter(ACTOR_ID, (Object)actorId);
        }
        return workItem;
    }

    @Override
    protected void addWorkItemListener() {
        super.addWorkItemListener();
        this.getProcessInstance().addEventListener(WORK_ITEM_TRANSITION, this, false);
    }

    @Override
    protected void removeWorkItemListener() {
        super.removeWorkItemListener();
        this.getProcessInstance().removeEventListener(WORK_ITEM_TRANSITION, this, false);
    }

    protected String assignWorkItem(InternalKogitoWorkItem workItem) {
        String actorId = null;
        String swimlaneName = this.getHumanTaskNode().getSwimlane();
        SwimlaneContextInstance swimlaneContextInstance = this.getSwimlaneContextInstance(swimlaneName);
        if (swimlaneContextInstance != null) {
            actorId = swimlaneContextInstance.getActorId(swimlaneName);
            workItem.setParameter("SwimlaneActorId", (Object)actorId);
        }
        if (actorId == null && (actorId = (String)workItem.getParameter(ACTOR_ID)) != null && swimlaneContextInstance != null && actorId.split(this.separator).length == 1) {
            swimlaneContextInstance.setActorId(swimlaneName, actorId);
            workItem.setParameter("SwimlaneActorId", (Object)actorId);
        }
        return (String)workItem.getParameter(ACTOR_ID);
    }

    private SwimlaneContextInstance getSwimlaneContextInstance(String swimlaneName) {
        if (this.swimlaneContextInstance == null) {
            if (swimlaneName == null) {
                return null;
            }
            SwimlaneContextInstance swimlaneContextInstance = (SwimlaneContextInstance)this.resolveContextInstance("SwimlaneScope", swimlaneName);
            if (swimlaneContextInstance == null) {
                throw new IllegalArgumentException("Could not find swimlane context instance");
            }
            this.swimlaneContextInstance = swimlaneContextInstance;
        }
        return this.swimlaneContextInstance;
    }

    @Override
    public void triggerCompleted(InternalKogitoWorkItem workItem) {
        String newActorId;
        String swimlaneName = this.getHumanTaskNode().getSwimlane();
        SwimlaneContextInstance swimlaneContextInstance = this.getSwimlaneContextInstance(swimlaneName);
        if (swimlaneContextInstance != null && (newActorId = (String)workItem.getParameter(ACTOR_ID)) != null) {
            swimlaneContextInstance.setActorId(swimlaneName, newActorId);
        }
        super.triggerCompleted(workItem);
    }

    protected void processAssigment(String type, InternalKogitoWorkItem workItem, Set<String> store) {
        String value = (String)workItem.getParameter(type);
        if (value != null) {
            for (String item : value.split(this.separator)) {
                store.add(item);
            }
        }
    }
}

