/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.instance.impl;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.jbpm.process.instance.context.variable.VariableScopeInstance;
import org.jbpm.process.instance.impl.AbstractReturnValueEvaluator;
import org.jbpm.process.instance.impl.FeelErrorEvaluatorListener;
import org.jbpm.process.instance.impl.FeelReturnValueEvaluatorException;
import org.jbpm.workflow.instance.WorkflowProcessInstance;
import org.kie.api.runtime.Globals;
import org.kie.dmn.api.feel.runtime.events.FEELEvent;
import org.kie.dmn.api.feel.runtime.events.FEELEventListener;
import org.kie.dmn.feel.FEEL;
import org.kie.dmn.feel.lang.impl.FEELBuilder;
import org.kie.dmn.feel.parser.feel11.profiles.KieExtendedFEELProfile;
import org.kie.kogito.internal.process.runtime.KogitoProcessContext;

public class FeelReturnValueEvaluator
extends AbstractReturnValueEvaluator {
    public FeelReturnValueEvaluator() {
        super("FEEL", "true()");
    }

    public FeelReturnValueEvaluator(String expr) {
        super("FEEL", expr);
    }

    @Override
    public Object evaluate(KogitoProcessContext context) {
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("kcontext", context);
        Globals globals = context.getKieRuntime().getGlobals();
        if (globals != null && globals.getGlobalKeys() != null) {
            for (String gKey : globals.getGlobalKeys()) {
                variables.put(gKey, globals.get(gKey));
            }
        }
        if (context.getProcessInstance() != null && context.getProcessInstance().getProcess() != null) {
            VariableScopeInstance variableScope = (VariableScopeInstance)((WorkflowProcessInstance)context.getProcessInstance()).getContextInstance("VariableScope");
            variables.putAll(variableScope.getVariables());
        }
        FEEL feel = FEELBuilder.builder().withProfiles(Collections.singletonList(new KieExtendedFEELProfile())).build();
        FeelErrorEvaluatorListener listener = new FeelErrorEvaluatorListener();
        feel.addListener((FEELEventListener)listener);
        Object value = feel.evaluate(this.expression(), variables);
        this.processErrorEvents(listener.getErrorEvents());
        if (!(value instanceof Boolean)) {
            throw new RuntimeException("Constraints must return boolean values: " + this.expression() + " returns " + value + (String)(value == null ? "" : " (type=" + value.getClass()));
        }
        return (boolean)((Boolean)value);
    }

    private void processErrorEvents(List<FEELEvent> errorEvents) {
        if (errorEvents.isEmpty()) {
            return;
        }
        String exceptionMessage = errorEvents.stream().map(FeelReturnValueEvaluator::eventToMessage).collect(Collectors.joining(", "));
        throw new FeelReturnValueEvaluatorException(exceptionMessage);
    }

    public static String eventToMessage(FEELEvent event) {
        StringBuilder messageBuilder = new StringBuilder(event.getSeverity().toString()).append(" ").append(event.getMessage());
        if (event.getOffendingSymbol() != null) {
            messageBuilder.append(" ( offending symbol: '").append(event.getOffendingSymbol()).append("' )");
        }
        if (event.getSourceException() != null) {
            messageBuilder.append("  ").append(event.getSourceException().getMessage());
        }
        return messageBuilder.toString();
    }
}

