/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workflow.core.node;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jbpm.process.core.timer.Timer;
import org.jbpm.process.instance.impl.actions.CompleteStateBasedNodeInstanceAction;
import org.jbpm.workflow.core.DroolsAction;
import org.jbpm.workflow.core.impl.DroolsConsequenceAction;
import org.jbpm.workflow.core.impl.ExtendedNodeImpl;

public class StateBasedNode
extends ExtendedNodeImpl {
    private static final long serialVersionUID = 510L;
    private Map<Timer, DroolsAction> timers;
    private List<String> boundaryEvents;
    private transient String duration;

    public Map<Timer, DroolsAction> getTimers() {
        return this.timers;
    }

    public void setTimeout(String duration) {
        this.duration = duration;
        Timer timer = new Timer();
        timer.setDelay(duration);
        DroolsConsequenceAction timeoutAction = new DroolsConsequenceAction("java", null);
        timeoutAction.setMetaData("Action", new CompleteStateBasedNodeInstanceAction(this.getNodeUniqueId()));
        this.addTimer(timer, timeoutAction);
    }

    public String getTimeout() {
        return this.duration;
    }

    public void addTimer(Timer timer, DroolsAction action) {
        if (this.timers == null) {
            this.timers = new HashMap<Timer, DroolsAction>();
        }
        if (timer.getId() == 0L) {
            long id = 0L;
            for (Timer t : this.timers.keySet()) {
                if (t.getId() <= id) continue;
                id = t.getId();
            }
            timer.setId(++id);
        }
        this.timers.put(timer, action);
    }

    public void removeAllTimers() {
        if (this.timers != null) {
            this.timers.clear();
        }
    }

    public void addBoundaryEvents(String boundaryEvent) {
        if (this.boundaryEvents == null) {
            this.boundaryEvents = new ArrayList<String>();
        }
        this.boundaryEvents.add(boundaryEvent);
    }

    public void setBoundaryEvents(List<String> boundaryEvents) {
        this.boundaryEvents = boundaryEvents;
    }

    public List<String> getBoundaryEvents() {
        return this.boundaryEvents;
    }
}

