/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workflow.core.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.jbpm.process.core.Context;
import org.jbpm.process.core.ContextResolver;
import org.jbpm.process.core.context.variable.Mappable;
import org.jbpm.ruleflow.core.RuleFlowProcess;
import org.jbpm.workflow.core.Constraint;
import org.jbpm.workflow.core.Node;
import org.jbpm.workflow.core.NodeContainer;
import org.jbpm.workflow.core.WorkflowProcess;
import org.jbpm.workflow.core.impl.ConnectionRef;
import org.jbpm.workflow.core.impl.DataAssociation;
import org.jbpm.workflow.core.impl.DataDefinition;
import org.jbpm.workflow.core.impl.IOSpecification;
import org.jbpm.workflow.core.impl.MultiInstanceSpecification;
import org.jbpm.workflow.core.node.CompositeNode;
import org.kie.api.definition.process.Connection;

public abstract class NodeImpl
implements Node,
ContextResolver,
Mappable {
    private static final long serialVersionUID = 510L;
    private long id = -1L;
    private static final AtomicLong uniqueIdGen = new AtomicLong(0L);
    private String name;
    private Map<String, List<Connection>> incomingConnections;
    private Map<String, List<Connection>> outgoingConnections;
    private org.kie.api.definition.process.NodeContainer parentContainer;
    private Map<String, Context> contexts = new HashMap<String, Context>();
    private Map<String, Object> metaData = new HashMap<String, Object>();
    protected Map<ConnectionRef, Constraint> constraints = new HashMap<ConnectionRef, Constraint>();
    private IOSpecification ioSpecification;
    private MultiInstanceSpecification multiInstanceSpecification;

    public NodeImpl() {
        this.incomingConnections = new HashMap<String, List<Connection>>();
        this.outgoingConnections = new HashMap<String, List<Connection>>();
        this.ioSpecification = new IOSpecification();
        this.multiInstanceSpecification = new MultiInstanceSpecification();
    }

    public void setMultiInstanceSpecification(MultiInstanceSpecification multiInstanceSpecification) {
        this.multiInstanceSpecification = multiInstanceSpecification;
    }

    public MultiInstanceSpecification getMultiInstanceSpecification() {
        return this.multiInstanceSpecification;
    }

    public void setIoSpecification(IOSpecification ioSpecification) {
        this.ioSpecification = ioSpecification;
    }

    public IOSpecification getIoSpecification() {
        return this.ioSpecification;
    }

    @Override
    public Map<String, String> getInMappings() {
        return this.getIoSpecification().getInputMapping();
    }

    @Override
    public Map<String, String> getOutMappings() {
        return this.getIoSpecification().getOutputMappingBySources();
    }

    @Override
    public String getInMapping(String key) {
        return this.getIoSpecification().getInputMapping().get(key);
    }

    @Override
    public String getOutMapping(String key) {
        return this.getIoSpecification().getOutputMappingBySources().get(key);
    }

    @Override
    public void addInMapping(String from, String to) {
        this.getIoSpecification().addInputMapping(from, to);
    }

    @Override
    public void addOutMapping(String from, String to) {
        this.getIoSpecification().addOutputMapping(from, to);
    }

    @Override
    public void addInAssociation(DataAssociation dataAssociation) {
        this.getIoSpecification().getDataInputs().add(dataAssociation.getTarget());
        this.getIoSpecification().getDataInputAssociation().add(dataAssociation);
    }

    @Override
    public List<DataAssociation> getInAssociations() {
        return this.getIoSpecification().getDataInputAssociation();
    }

    @Override
    public void addOutAssociation(DataAssociation dataAssociation) {
        dataAssociation.getSources().forEach(s -> this.getIoSpecification().getDataOutputs().add((DataDefinition)s));
        this.getIoSpecification().getDataOutputAssociation().add(dataAssociation);
    }

    public WorkflowProcess getProcess() {
        org.kie.api.definition.process.NodeContainer container = this.parentContainer;
        while (!(container instanceof RuleFlowProcess)) {
            container = ((NodeImpl)container).parentContainer;
        }
        return (WorkflowProcess)container;
    }

    @Override
    public List<DataAssociation> getOutAssociations() {
        return this.getIoSpecification().getDataOutputAssociation();
    }

    public long getId() {
        return this.id;
    }

    @Override
    public String getUniqueId() {
        StringBuilder result = new StringBuilder("" + this.id);
        org.kie.api.definition.process.NodeContainer nodeContainer = this.getParentContainer();
        while (nodeContainer instanceof CompositeNode) {
            CompositeNode composite = (CompositeNode)nodeContainer;
            result.insert(0, composite.getId() + ":");
            nodeContainer = composite.getParentContainer();
        }
        return result.toString();
    }

    @Override
    public void setId(long id) {
        this.id = id;
        String uniqueId = (String)this.getMetaData("UniqueId");
        if (uniqueId == null) {
            this.setMetaData("UniqueId", "_jbpm-unique-" + uniqueIdGen.getAndIncrement());
        }
    }

    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    public Map<String, List<Connection>> getIncomingConnections() {
        return Collections.unmodifiableMap(this.incomingConnections);
    }

    public Map<String, List<Connection>> getOutgoingConnections() {
        return Collections.unmodifiableMap(this.outgoingConnections);
    }

    @Override
    public void addIncomingConnection(String type, Connection connection) {
        this.validateAddIncomingConnection(type, connection);
        List<Connection> connections = this.incomingConnections.get(type);
        if (connections == null) {
            connections = new ArrayList<Connection>();
            this.incomingConnections.put(type, connections);
        }
        connections.add(connection);
    }

    public void validateAddIncomingConnection(String type, Connection connection) {
        if (type == null) {
            throw new IllegalArgumentException("Connection type cannot be null");
        }
        if (connection == null) {
            throw new IllegalArgumentException("Connection cannot be null");
        }
    }

    public List<Connection> getIncomingConnections(String type) {
        List<Connection> result = this.incomingConnections.get(type);
        if (result == null) {
            return new ArrayList<Connection>();
        }
        return result;
    }

    @Override
    public void addOutgoingConnection(String type, Connection connection) {
        this.validateAddOutgoingConnection(type, connection);
        List<Connection> connections = this.outgoingConnections.get(type);
        if (connections == null) {
            connections = new ArrayList<Connection>();
            this.outgoingConnections.put(type, connections);
        }
        connections.add(connection);
    }

    public void validateAddOutgoingConnection(String type, Connection connection) {
        if (type == null) {
            throw new IllegalArgumentException("Connection type cannot be null");
        }
        if (connection == null) {
            throw new IllegalArgumentException("Connection cannot be null");
        }
    }

    public List<Connection> getOutgoingConnections(String type) {
        List<Connection> result = this.outgoingConnections.get(type);
        if (result == null) {
            return new ArrayList<Connection>();
        }
        return result;
    }

    @Override
    public void removeIncomingConnection(String type, Connection connection) {
        this.validateRemoveIncomingConnection(type, connection);
        this.incomingConnections.get(type).remove(connection);
    }

    public void clearIncomingConnection() {
        this.incomingConnections.clear();
    }

    public void clearOutgoingConnection() {
        this.outgoingConnections.clear();
    }

    public void validateRemoveIncomingConnection(String type, Connection connection) {
        if (type == null) {
            throw new IllegalArgumentException("Connection type cannot be null");
        }
        if (connection == null) {
            throw new IllegalArgumentException("Connection is null");
        }
        if (!this.incomingConnections.get(type).contains(connection)) {
            throw new IllegalArgumentException("Given connection <" + connection + "> is not part of the incoming connections");
        }
    }

    @Override
    public void removeOutgoingConnection(String type, Connection connection) {
        this.validateRemoveOutgoingConnection(type, connection);
        this.outgoingConnections.get(type).remove(connection);
    }

    public void validateRemoveOutgoingConnection(String type, Connection connection) {
        if (type == null) {
            throw new IllegalArgumentException("Connection type cannot be null");
        }
        if (connection == null) {
            throw new IllegalArgumentException("Connection is null");
        }
        if (!this.outgoingConnections.get(type).contains(connection)) {
            throw new IllegalArgumentException("Given connection <" + connection + "> is not part of the outgoing connections");
        }
    }

    public Connection getFrom() {
        List<Connection> list = this.getIncomingConnections("DROOLS_DEFAULT");
        if (list.isEmpty()) {
            return null;
        }
        if (list.size() == 1) {
            return list.get(0);
        }
        if ("true".equals(System.getProperty("jbpm.enable.multi.con"))) {
            return list.get(0);
        }
        throw new IllegalArgumentException("Trying to retrieve the from connection but multiple connections are present");
    }

    public Connection getTo() {
        List<Connection> list = this.getOutgoingConnections("DROOLS_DEFAULT");
        if (list.isEmpty()) {
            return null;
        }
        if (list.size() == 1) {
            return list.get(0);
        }
        if ("true".equals(System.getProperty("jbpm.enable.multi.con"))) {
            return list.get(0);
        }
        throw new IllegalArgumentException("Trying to retrieve the to connection but multiple connections are present");
    }

    public List<Connection> getDefaultIncomingConnections() {
        return this.getIncomingConnections("DROOLS_DEFAULT");
    }

    public List<Connection> getDefaultOutgoingConnections() {
        return this.getOutgoingConnections("DROOLS_DEFAULT");
    }

    public org.kie.api.definition.process.NodeContainer getParentContainer() {
        return this.parentContainer;
    }

    @Override
    public void setParentContainer(org.kie.api.definition.process.NodeContainer nodeContainer) {
        this.parentContainer = nodeContainer;
    }

    @Override
    public void setContext(String contextId, Context context) {
        this.contexts.put(contextId, context);
    }

    @Override
    public Context getContext(String contextId) {
        return this.contexts.get(contextId);
    }

    @Override
    public Context resolveContext(String contextId, Object param) {
        Context context = this.getContext(contextId);
        if (context != null && (context = context.resolveContext(param)) != null) {
            return context;
        }
        return ((NodeContainer)this.parentContainer).resolveContext(contextId, param);
    }

    @Override
    public void setMetaData(String name, Object value) {
        this.metaData.put(name, value);
    }

    public Object getMetaData(String name) {
        return this.metaData.get(name);
    }

    public Map<String, Object> getMetaData() {
        return this.metaData;
    }

    public void setMetaData(Map<String, Object> metaData) {
        this.metaData = metaData;
    }

    public Constraint getConstraint(Connection connection) {
        if (connection == null) {
            throw new IllegalArgumentException("connection is null");
        }
        ConnectionRef ref = new ConnectionRef((String)connection.getMetaData().get("UniqueId"), connection.getTo().getId(), connection.getToType());
        return this.constraints.get(ref);
    }

    public Constraint internalGetConstraint(ConnectionRef ref) {
        return this.constraints.get(ref);
    }

    public void setConstraint(Connection connection, Constraint constraint) {
        if (connection == null) {
            throw new IllegalArgumentException("connection is null");
        }
        if (!this.getDefaultOutgoingConnections().contains(connection)) {
            throw new IllegalArgumentException("connection is unknown:" + connection);
        }
        this.addConstraint(new ConnectionRef((String)connection.getMetaData().get("UniqueId"), connection.getTo().getId(), connection.getToType()), constraint);
    }

    public void addConstraint(ConnectionRef connectionRef, Constraint constraint) {
        if (connectionRef == null) {
            throw new IllegalArgumentException("A " + this.getName() + " node only accepts constraints linked to a connection");
        }
        this.constraints.put(connectionRef, constraint);
    }

    public Map<ConnectionRef, Constraint> getConstraints() {
        return Collections.unmodifiableMap(this.constraints);
    }

    public String getNodeUniqueId() {
        return (String)this.getMetaData("UniqueId");
    }

    public org.kie.api.definition.process.NodeContainer getNodeContainer() {
        return this.getParentContainer();
    }
}

