/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workflow.core.impl;

import java.io.Serializable;
import java.util.function.Function;
import java.util.regex.Matcher;
import org.jbpm.process.instance.impl.AssignmentAction;
import org.jbpm.process.instance.impl.AssignmentProducer;
import org.jbpm.util.PatternConstants;
import org.jbpm.workflow.core.impl.DataDefinition;
import org.jbpm.workflow.instance.impl.MVELProcessHelper;
import org.mvel2.integration.VariableResolver;
import org.mvel2.integration.VariableResolverFactory;
import org.mvel2.integration.impl.ImmutableDefaultFactory;
import org.mvel2.integration.impl.SimpleValueResolver;

public class OutputExpressionAssignment
implements AssignmentAction {
    private DataDefinition from;
    private Serializable toCompiled;
    private DataDefinition to;

    public OutputExpressionAssignment(DataDefinition from, DataDefinition to) {
        this.from = from;
        this.to = to;
        Matcher matcher = PatternConstants.PARAMETER_MATCHER.matcher(this.to.getExpression());
        if (matcher.find()) {
            this.toCompiled = MVELProcessHelper.compileExpression(matcher.group(1) + " = _value");
        }
    }

    @Override
    public void execute(final Function<String, Object> sourceResolver, final Function<String, Object> targetResolver, AssignmentProducer producer) throws Exception {
        Object value = MVELProcessHelper.evaluator().executeExpression((Object)this.toCompiled, (VariableResolverFactory)new ImmutableDefaultFactory(){

            public boolean isResolveable(String name) {
                return targetResolver.apply(name) != null || name.equals("_value");
            }

            public VariableResolver getVariableResolver(String name) {
                if ("_value".equals(name)) {
                    return new SimpleValueResolver(sourceResolver.apply(OutputExpressionAssignment.this.from.getLabel()));
                }
                return new SimpleValueResolver(targetResolver.apply(name));
            }
        });
        producer.accept(this.to.getId(), value);
    }
}

