/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bpmn2.xml;

import java.util.HashMap;
import java.util.Map;
import org.jbpm.bpmn2.xml.AbstractNodeHandler;
import org.jbpm.compiler.xml.Parser;
import org.jbpm.workflow.core.DroolsAction;
import org.jbpm.workflow.core.Node;
import org.jbpm.workflow.core.impl.DroolsConsequenceAction;
import org.jbpm.workflow.core.node.ActionNode;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class ScriptTaskHandler
extends AbstractNodeHandler {
    private static Map<String, String> SUPPORTED_SCRIPT_FORMATS = new HashMap<String, String>();

    public static void registerSupportedScriptFormat(String language, String dialect) {
        SUPPORTED_SCRIPT_FORMATS.put(language, dialect);
    }

    @Override
    protected Node createNode(Attributes attrs) {
        ActionNode result = new ActionNode();
        result.setAction((DroolsAction)new DroolsConsequenceAction());
        return result;
    }

    public Class<Node> generateNodeFor() {
        return Node.class;
    }

    @Override
    protected Node handleNode(Node node, Element element, String uri, String localName, Parser parser) throws SAXException {
        boolean isForCompensation;
        super.handleNode(node, element, uri, localName, parser);
        ActionNode actionNode = (ActionNode)node;
        node.setMetaData("NodeType", (Object)"ScriptTask");
        DroolsConsequenceAction action = (DroolsConsequenceAction)actionNode.getAction();
        if (action == null) {
            action = new DroolsConsequenceAction();
            actionNode.setAction((DroolsAction)action);
        }
        String language = element.getAttribute("scriptFormat");
        action.setDialect(SUPPORTED_SCRIPT_FORMATS.getOrDefault(language, "java"));
        action.setConsequence("");
        DroolsConsequenceAction scriptAction = action;
        this.readSingleChildElementByTag(element, "script").ifPresent(script -> scriptAction.setConsequence(script.getTextContent()));
        actionNode.setMetaData("DataInputs", new HashMap());
        actionNode.setMetaData("DataOutputs", new HashMap());
        String compensation = element.getAttribute("isForCompensation");
        if (compensation != null && (isForCompensation = Boolean.parseBoolean(compensation))) {
            actionNode.setMetaData("isForCompensation", (Object)isForCompensation);
        }
        ActionNode currentNode = actionNode;
        actionNode.setIoSpecification(this.readIOEspecification(parser, element));
        actionNode.setMultiInstanceSpecification(this.readMultiInstanceSpecification(parser, element, actionNode.getIoSpecification()));
        return currentNode;
    }

    @Override
    public void writeNode(Node node, StringBuilder xmlDump, int metaDataType) {
        throw new IllegalArgumentException("Writing out should be handled by action node handler");
    }

    static {
        SUPPORTED_SCRIPT_FORMATS.put("http://www.java.com/java", "java");
        SUPPORTED_SCRIPT_FORMATS.put("http://www.omg.org/spec/FEEL/20140401", "FEEL");
        SUPPORTED_SCRIPT_FORMATS.put("application/feel", "FEEL");
    }
}

