/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bpmn2.xml;

import java.util.ArrayList;
import java.util.List;
import org.jbpm.bpmn2.core.Collaboration;
import org.jbpm.bpmn2.core.CorrelationKey;
import org.jbpm.bpmn2.xml.HandlerUtil;
import org.jbpm.compiler.xml.Handler;
import org.jbpm.compiler.xml.Parser;
import org.jbpm.compiler.xml.core.BaseAbstractHandler;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class CollaborationHandler
extends BaseAbstractHandler
implements Handler {
    public Object start(String uri, String localName, Attributes attrs, Parser parser) throws SAXException {
        parser.startElementBuilder(localName, attrs);
        String collaborationPropertyId = attrs.getValue("id");
        String collaborationPropertyName = attrs.getValue("name");
        Collaboration collaboration = new Collaboration();
        collaboration.setId(collaborationPropertyId);
        collaboration.setName(collaborationPropertyName);
        HandlerUtil.collaborations(parser).put(collaborationPropertyId, collaboration);
        return collaboration;
    }

    public Object end(String uri, String localName, Parser parser) throws SAXException {
        Element element = parser.endElementBuilder();
        Collaboration collaboration = (Collaboration)parser.getCurrent();
        this.buildCorrelationKeys(collaboration, element.getChildNodes());
        return null;
    }

    private void buildCorrelationKeys(Collaboration collaboration, NodeList childNodes) {
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node node = childNodes.item(i);
            if ("correlationKey".equals(node.getNodeName())) {
                Element elementCorrelationKey = (Element)node;
                CorrelationKey key = new CorrelationKey();
                key.setId(elementCorrelationKey.getAttribute("id"));
                key.setName(elementCorrelationKey.getAttribute("name"));
                key.getPropertiesRef().addAll(this.buildPropertiesRef(elementCorrelationKey.getChildNodes()));
                collaboration.addCorrelationKey(key);
                continue;
            }
            if (!"participant".equals(node.getNodeName())) continue;
            Element participant = (Element)node;
            collaboration.getProcessesRef().add(participant.getAttribute("processRef"));
        }
    }

    private List<String> buildPropertiesRef(NodeList childNodes) {
        ArrayList<String> propertiesRef = new ArrayList<String>();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node node = childNodes.item(i);
            if (!"correlationPropertyRef".equals(node.getNodeName())) continue;
            propertiesRef.add(node.getTextContent());
        }
        return propertiesRef;
    }

    public Class<?> generateNodeFor() {
        return Collaboration.class;
    }
}

