/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bpmn2.xml;

import java.util.HashMap;
import org.jbpm.bpmn2.xml.AbstractNodeHandler;
import org.jbpm.bpmn2.xml.XmlBPMNProcessDumper;
import org.jbpm.compiler.xml.Parser;
import org.jbpm.workflow.core.Node;
import org.jbpm.workflow.core.impl.ExtendedNodeImpl;
import org.jbpm.workflow.core.impl.NodeImpl;
import org.jbpm.workflow.core.node.SubProcessNode;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class CallActivityHandler
extends AbstractNodeHandler {
    @Override
    protected Node createNode(Attributes attrs) {
        return new SubProcessNode();
    }

    public Class<SubProcessNode> generateNodeFor() {
        return SubProcessNode.class;
    }

    @Override
    protected Node handleNode(Node node, Element element, String uri, String localName, Parser parser) throws SAXException {
        String independent;
        super.handleNode(node, element, uri, localName, parser);
        SubProcessNode subProcessNode = (SubProcessNode)node;
        String processId = element.getAttribute("calledElement");
        if (processId != null && processId.length() > 0) {
            subProcessNode.setProcessId(processId);
        } else {
            String processName = element.getAttribute("calledElementByName");
            subProcessNode.setProcessName(processName);
        }
        String waitForCompletion = element.getAttribute("waitForCompletion");
        if (waitForCompletion != null && "false".equals(waitForCompletion)) {
            subProcessNode.setWaitForCompletion(false);
        }
        if ((independent = element.getAttribute("independent")) != null && "false".equals(independent)) {
            subProcessNode.setIndependent(false);
        }
        subProcessNode.setMetaData("DataInputs", new HashMap());
        subProcessNode.setMetaData("DataOutputs", new HashMap());
        this.handleScript((ExtendedNodeImpl)subProcessNode, element, "onEntry");
        this.handleScript((ExtendedNodeImpl)subProcessNode, element, "onExit");
        SubProcessNode currentNode = subProcessNode;
        subProcessNode.setIoSpecification(this.readIOEspecification(parser, element));
        subProcessNode.setMultiInstanceSpecification(this.readMultiInstanceSpecification(parser, element, subProcessNode.getIoSpecification()));
        if (subProcessNode.getMultiInstanceSpecification().hasMultiInstanceInput()) {
            currentNode = this.decorateMultiInstanceSpecificationActivity((NodeImpl)subProcessNode, subProcessNode.getMultiInstanceSpecification());
        }
        return currentNode;
    }

    @Override
    public void writeNode(Node node, StringBuilder xmlDump, int metaDataType) {
        SubProcessNode subProcessNode = (SubProcessNode)node;
        this.writeNode("callActivity", (Node)subProcessNode, xmlDump, metaDataType);
        if (subProcessNode.getProcessId() != null) {
            xmlDump.append("calledElement=\"" + XmlBPMNProcessDumper.replaceIllegalCharsAttribute(subProcessNode.getProcessId()) + "\" ");
        }
        if (!subProcessNode.isWaitForCompletion()) {
            xmlDump.append("tns:waitForCompletion=\"false\" ");
        }
        if (!subProcessNode.isIndependent()) {
            xmlDump.append("tns:independent=\"false\" ");
        }
        xmlDump.append(">" + EOL);
        this.writeExtensionElements((Node)subProcessNode, xmlDump);
        this.writeIO(subProcessNode.getIoSpecification(), xmlDump);
        this.writeMultiInstance(subProcessNode.getMultiInstanceSpecification(), xmlDump);
        this.endNode("callActivity", xmlDump);
    }
}

