/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.commons.utils;

import java.util.UUID;
import javax.lang.model.SourceVersion;
import org.kie.pmml.api.enums.DATA_TYPE;

public class KiePMMLModelUtils {
    private KiePMMLModelUtils() {
    }

    public static String getSanitizedPackageName(String modelName) {
        return modelName.replaceAll("[^A-Za-z0-9.]", "").toLowerCase();
    }

    public static String getSanitizedClassName(String input) {
        String upperCasedInput = input.substring(0, 1).toUpperCase() + input.substring(1);
        return upperCasedInput.replaceAll("[^A-Za-z0-9]", "");
    }

    public static String getSanitizedVariableName(String input) {
        String lowerCasedInput = input.substring(0, 1).toLowerCase() + input.substring(1);
        Object toReturn = lowerCasedInput.replaceAll("[^A-Za-z0-9]", "");
        if (SourceVersion.isKeyword((CharSequence)toReturn)) {
            toReturn = (String)toReturn + "var";
        }
        return toReturn;
    }

    public static String getGeneratedClassName(String prefix) {
        String rawName = prefix + UUID.randomUUID();
        return KiePMMLModelUtils.getSanitizedClassName(rawName);
    }

    public static Object commonEvaluate(Object rawObject, DATA_TYPE dataType) {
        return dataType != null && rawObject != null ? dataType.getActualValue(rawObject) : rawObject;
    }
}

