/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.api.enums.builtinfunctions;

import java.util.Arrays;
import java.util.Date;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.kie.pmml.api.enums.BUILTIN_FUNCTIONS;
import org.kie.pmml.api.exceptions.KieEnumException;
import org.kie.pmml.api.exceptions.KiePMMLException;

public enum StringFunctions {
    UPPERCASE("uppercase"),
    LOWERCASE("lowercase"),
    STRING_LENGTH("stringLength"),
    SUBSTRING("substring"),
    TRIM_BLANKS("trimBlanks"),
    CONCAT("concat"),
    REPLACE("replace"),
    MATCHES("matches"),
    FORMAT_NUMBER("formatNumber"),
    FORMAT_DATE_TIME("formatDatetime");

    private final String name;

    private StringFunctions(String name) {
        this.name = name;
    }

    public static boolean isStringFunctions(String name) {
        return Arrays.stream(StringFunctions.values()).anyMatch(value -> name.equals(value.name));
    }

    public static StringFunctions byName(String name) {
        return Arrays.stream(StringFunctions.values()).filter(value -> name.equals(value.name)).findFirst().orElseThrow(() -> new KieEnumException("Failed to find StringFunctions with name: " + name));
    }

    public String getName() {
        return this.name;
    }

    public Object getValue(Object[] inputData) {
        switch (this) {
            case LOWERCASE: {
                return this.lowercase(inputData);
            }
            case UPPERCASE: {
                return this.uppercase(inputData);
            }
            case STRING_LENGTH: {
                return this.stringLength(inputData);
            }
            case SUBSTRING: {
                return this.substring(inputData);
            }
            case TRIM_BLANKS: {
                return this.trimBlanks(inputData);
            }
            case CONCAT: {
                return this.concat(inputData);
            }
            case REPLACE: {
                return this.replace(inputData);
            }
            case MATCHES: {
                return this.matches(inputData);
            }
            case FORMAT_NUMBER: {
                return this.formatNumber(inputData);
            }
            case FORMAT_DATE_TIME: {
                return this.formatDatetime(inputData);
            }
        }
        throw new KiePMMLException("Unmanaged StringFunctions " + this);
    }

    private String lowercase(Object[] inputData) {
        BUILTIN_FUNCTIONS.checkStrings(inputData, 1);
        return ((String)inputData[0]).toLowerCase();
    }

    private String uppercase(Object[] inputData) {
        BUILTIN_FUNCTIONS.checkStrings(inputData, 1);
        return ((String)inputData[0]).toUpperCase();
    }

    private int stringLength(Object[] inputData) {
        BUILTIN_FUNCTIONS.checkStrings(inputData, 1);
        return ((String)inputData[0]).length();
    }

    private String substring(Object[] inputData) {
        BUILTIN_FUNCTIONS.checkLength(inputData, 3);
        BUILTIN_FUNCTIONS.checkString(inputData[0]);
        BUILTIN_FUNCTIONS.checkInteger(inputData[1]);
        BUILTIN_FUNCTIONS.checkInteger(inputData[2]);
        int startPos = (Integer)inputData[1] - 1;
        int length = (Integer)inputData[2];
        int endPos = startPos + length;
        return ((String)inputData[0]).substring(startPos, endPos);
    }

    private String trimBlanks(Object[] inputData) {
        BUILTIN_FUNCTIONS.checkStrings(inputData, 1);
        return ((String)inputData[0]).trim();
    }

    private String concat(Object[] inputData) {
        BUILTIN_FUNCTIONS.checkMinimumLength(inputData, 2);
        return Arrays.stream(inputData).map(obj -> obj != null ? obj.toString() : null).collect(Collectors.joining(""));
    }

    private String replace(Object[] inputData) {
        BUILTIN_FUNCTIONS.checkStrings(inputData, 3);
        String pattern = (String)inputData[1];
        String replacement = (String)inputData[2];
        return ((String)inputData[0]).replaceAll(pattern, replacement);
    }

    private boolean matches(Object[] inputData) {
        BUILTIN_FUNCTIONS.checkStrings(inputData, 2);
        String input = (String)inputData[0];
        String pattern = (String)inputData[1];
        return input.contains(pattern) || Pattern.compile(pattern).matcher(input).find();
    }

    private String formatNumber(Object[] inputData) {
        BUILTIN_FUNCTIONS.checkLength(inputData, 2);
        BUILTIN_FUNCTIONS.checkNumber(inputData[0]);
        BUILTIN_FUNCTIONS.checkString(inputData[1]);
        Number input = (Number)inputData[0];
        String pattern = (String)inputData[1];
        return String.format(pattern, input);
    }

    private String formatDatetime(Object[] inputData) {
        BUILTIN_FUNCTIONS.checkLength(inputData, 2);
        BUILTIN_FUNCTIONS.checkDate(inputData[0]);
        BUILTIN_FUNCTIONS.checkString(inputData[1]);
        Date input = (Date)inputData[0];
        String pattern = ((String)inputData[1]).replace("%", "%1$t");
        return String.format(pattern, input);
    }
}

