/*
 * Decompiled with CFR 0.152.
 */
package org.kie.drl.engine.compilation.utils;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.drools.codegen.common.GeneratedFile;
import org.drools.compiler.builder.impl.BuildResultCollector;
import org.drools.compiler.builder.impl.KnowledgeBuilderConfigurationImpl;
import org.drools.compiler.builder.impl.resources.DrlResourceHandler;
import org.drools.compiler.lang.descr.CompositePackageDescr;
import org.drools.drl.ast.descr.PackageDescr;
import org.drools.drl.parser.DroolsParserException;
import org.drools.io.FileSystemResource;
import org.drools.model.codegen.execmodel.PackageModelWriter;
import org.drools.model.codegen.project.CodegenPackageSources;
import org.drools.model.codegen.project.RuleCodegenError;
import org.drools.model.codegen.tool.ExplicitCanonicalModelCompiler;
import org.kie.api.io.Resource;
import org.kie.drl.api.identifiers.DrlIdFactory;
import org.kie.drl.api.identifiers.KieDrlComponentRoot;
import org.kie.drl.api.identifiers.LocalComponentIdDrl;
import org.kie.drl.engine.compilation.model.DecisionTableFileSetResource;
import org.kie.drl.engine.compilation.model.DrlCompilationContext;
import org.kie.drl.engine.compilation.model.DrlFileSetResource;
import org.kie.drl.engine.compilation.model.DrlPackageDescrSetResource;
import org.kie.drl.engine.compilation.model.ExecutableModelClassesContainer;
import org.kie.efesto.common.api.identifiers.EfestoAppRoot;
import org.kie.efesto.common.api.identifiers.ModelLocalUriId;
import org.kie.efesto.compilationmanager.api.exceptions.KieCompilerServiceException;
import org.kie.efesto.compilationmanager.api.model.EfestoSetResource;
import org.kie.internal.builder.KnowledgeBuilderFactory;
import org.kie.internal.builder.KnowledgeBuilderResult;
import org.kie.internal.builder.ResultSeverity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DrlCompilerHelper {
    private static final Logger logger = LoggerFactory.getLogger(DrlCompilerHelper.class);

    private DrlCompilerHelper() {
    }

    public static ExecutableModelClassesContainer dTableToDrl(DecisionTableFileSetResource resources, DrlCompilationContext context) {
        throw new KieCompilerServiceException("Not implemented, yet");
    }

    public static DrlPackageDescrSetResource drlToPackageDescrs(DrlFileSetResource resources, DrlCompilationContext context) {
        KnowledgeBuilderConfigurationImpl conf = (KnowledgeBuilderConfigurationImpl)context.newKnowledgeBuilderConfiguration().as(KnowledgeBuilderConfigurationImpl.KEY);
        HashSet<PackageDescr> packageDescrSet = new HashSet<PackageDescr>();
        packageDescrSet.addAll(DrlCompilerHelper.buildCompositePackageDescrs(resources, conf));
        return new DrlPackageDescrSetResource(packageDescrSet, resources.getModelLocalUriId().basePath());
    }

    public static ExecutableModelClassesContainer pkgDescrToExecModel(EfestoSetResource<PackageDescr> resources, DrlCompilationContext context) {
        return DrlCompilerHelper.pkgDescrToExecModel(DrlCompilerHelper.toCompositePackageDescrs(resources.getContent()), resources.getModelLocalUriId().basePath(), (KnowledgeBuilderConfigurationImpl)KnowledgeBuilderFactory.newKnowledgeBuilderConfiguration().as(KnowledgeBuilderConfigurationImpl.KEY), context);
    }

    public static ExecutableModelClassesContainer drlToExecutableModel(DrlFileSetResource resources, DrlCompilationContext context) {
        KnowledgeBuilderConfigurationImpl conf = (KnowledgeBuilderConfigurationImpl)context.newKnowledgeBuilderConfiguration().as(KnowledgeBuilderConfigurationImpl.KEY);
        return DrlCompilerHelper.pkgDescrToExecModel(DrlCompilerHelper.buildCompositePackageDescrs(resources, conf), resources.getModelLocalUriId().basePath(), conf, context);
    }

    public static ExecutableModelClassesContainer pkgDescrToExecModel(Collection<CompositePackageDescr> packages, String basePath, KnowledgeBuilderConfigurationImpl knowledgeBuilderConfiguration, DrlCompilationContext context) {
        ExplicitCanonicalModelCompiler compiler = ExplicitCanonicalModelCompiler.of(packages, (KnowledgeBuilderConfigurationImpl)knowledgeBuilderConfiguration, pkgModel -> CodegenPackageSources.dumpSources((PackageModelWriter)new PackageModelWriter(pkgModel)));
        compiler.process();
        BuildResultCollector buildResults = compiler.getBuildResults();
        if (buildResults.hasErrors()) {
            for (KnowledgeBuilderResult e : buildResults.getResults(new ResultSeverity[0])) {
                logger.error(e.getMessage(), (Object)e);
            }
            throw new RuleCodegenError(buildResults.getAllResults());
        }
        Collection packageSources = compiler.getPackageSources();
        ArrayList modelFiles = new ArrayList();
        ArrayList<String> generatedRulesModels = new ArrayList<String>();
        for (Object pkgSources : packageSources) {
            pkgSources.collectGeneratedFiles(modelFiles);
            generatedRulesModels.addAll(pkgSources.getExecutableRulesClasses());
        }
        HashMap<String, String> sourceCode = new HashMap<String, String>();
        for (GeneratedFile generatedFile : modelFiles) {
            String key = generatedFile.relativePath().replace(".java", "").replace(File.separatorChar, '.');
            String value = new String(generatedFile.contents(), StandardCharsets.UTF_8);
            sourceCode.put(key, value);
        }
        Map compiledClasses = context.compileClasses(sourceCode);
        LocalComponentIdDrl modelLocalUriId = ((DrlIdFactory)((KieDrlComponentRoot)new EfestoAppRoot().get(KieDrlComponentRoot.class)).get(DrlIdFactory.class)).get(basePath);
        return new ExecutableModelClassesContainer((ModelLocalUriId)modelLocalUriId, generatedRulesModels, compiledClasses);
    }

    private static Collection<CompositePackageDescr> buildCompositePackageDescrs(DrlFileSetResource resources, KnowledgeBuilderConfigurationImpl conf) {
        DrlResourceHandler drlResourceHandler = new DrlResourceHandler(conf);
        ArrayList<PackageDescr> packageDescrs = new ArrayList<PackageDescr>();
        for (FileSystemResource resource : resources.getFileSystemResource()) {
            packageDescrs.add(DrlCompilerHelper.resourceToPackageDescr(drlResourceHandler, (Resource)resource));
        }
        return DrlCompilerHelper.toCompositePackageDescrs(packageDescrs);
    }

    private static Collection<CompositePackageDescr> toCompositePackageDescrs(Iterable<PackageDescr> packageDescrs) {
        HashMap<String, CompositePackageDescr> packages = new HashMap<String, CompositePackageDescr>();
        for (PackageDescr packageDescr : packageDescrs) {
            DrlCompilerHelper.addPackageDescr(packageDescr, packageDescr.getResource(), packages);
        }
        return packages.values();
    }

    private static void addPackageDescr(PackageDescr packageDescr, Resource resource, Map<String, CompositePackageDescr> packages) {
        packages.computeIfAbsent(packageDescr.getNamespace(), CompositePackageDescr::new).addPackageDescr(resource, packageDescr);
    }

    private static PackageDescr resourceToPackageDescr(DrlResourceHandler drlResourceHandler, Resource resource) {
        try {
            return drlResourceHandler.process(resource);
        }
        catch (IOException | DroolsParserException e) {
            throw new KieCompilerServiceException(e);
        }
    }
}

