/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.openapi.impl;

import java.math.BigDecimal;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.microprofile.openapi.models.media.Schema;
import org.kie.dmn.api.core.DMNUnaryTest;
import org.kie.dmn.feel.FEEL;
import org.kie.dmn.feel.runtime.Range;
import org.kie.dmn.feel.runtime.UnaryTestImpl;
import org.kie.dmn.feel.runtime.impl.RangeImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FEELSchemaEnum {
    private static final Logger LOG = LoggerFactory.getLogger(FEELSchemaEnum.class);

    public static void parseValuesIntoSchema(Schema schema, List<DMNUnaryTest> list) {
        boolean allLiterals;
        List<Object> expectLiterals = FEELSchemaEnum.evaluateUnaryTests(list);
        if (expectLiterals.contains(null)) {
            schema.setNullable(Boolean.valueOf(true));
        }
        if (allLiterals = expectLiterals.stream().allMatch(o -> o == null || o instanceof String || o instanceof Number || o instanceof Boolean)) {
            schema.enumeration(expectLiterals);
        } else {
            LOG.warn("Unable to parse generic value into the JSON Schema for enumeration");
        }
    }

    public static void parseNumbersIntoSchema(Schema schema, List<DMNUnaryTest> list) {
        List<Object> uts = FEELSchemaEnum.evaluateUnaryTests(list);
        boolean allowNull = uts.remove(null);
        if (allowNull) {
            schema.setNullable(Boolean.valueOf(true));
        }
        if (uts.size() <= 2 && uts.stream().allMatch(o -> o instanceof Range)) {
            Range range = FEELSchemaEnum.consolidateRanges(uts);
            if (range != null) {
                if (range.getLowEndPoint() != null) {
                    schema.minimum((BigDecimal)range.getLowEndPoint());
                    schema.exclusiveMinimum(Boolean.valueOf(range.getLowBoundary() == Range.RangeBoundary.OPEN));
                }
                if (range.getHighEndPoint() != null) {
                    schema.maximum((BigDecimal)range.getHighEndPoint());
                    schema.exclusiveMaximum(Boolean.valueOf(range.getHighBoundary() == Range.RangeBoundary.OPEN));
                }
            }
        } else if (uts.stream().allMatch(o -> o instanceof Number)) {
            if (allowNull) {
                uts.add(null);
            }
            schema.enumeration(uts);
        } else {
            LOG.warn("Unable to parse number value into the JSON Schema for enumeration");
        }
    }

    public static Range consolidateRanges(List<Range> ranges) {
        boolean consistent = true;
        RangeImpl result = new RangeImpl();
        for (Range r : ranges) {
            if (r.getLowEndPoint() != null) {
                if (result.getLowEndPoint() == null) {
                    result = new RangeImpl(r.getLowBoundary(), r.getLowEndPoint(), result.getHighEndPoint(), result.getHighBoundary());
                } else {
                    consistent = false;
                }
            }
            if (r.getHighEndPoint() == null) continue;
            if (result.getHighEndPoint() == null) {
                result = new RangeImpl(result.getLowBoundary(), result.getLowEndPoint(), r.getHighEndPoint(), r.getHighBoundary());
                continue;
            }
            consistent = false;
        }
        return consistent ? result : null;
    }

    private static List<Object> evaluateUnaryTests(List<DMNUnaryTest> list) {
        FEEL SimpleFEEL = FEEL.newInstance();
        List<Object> utEvaluated = list.stream().map(UnaryTestImpl.class::cast).map(UnaryTestImpl::toString).map(arg_0 -> ((FEEL)SimpleFEEL).evaluate(arg_0)).collect(Collectors.toList());
        return utEvaluated;
    }

    private FEELSchemaEnum() {
    }
}

