/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.model.api;

import java.util.List;
import javax.xml.namespace.QName;
import org.kie.dmn.model.api.Artifact;
import org.kie.dmn.model.api.BusinessContextElement;
import org.kie.dmn.model.api.DRGElement;
import org.kie.dmn.model.api.DecisionService;
import org.kie.dmn.model.api.ElementCollection;
import org.kie.dmn.model.api.Import;
import org.kie.dmn.model.api.ItemDefinition;
import org.kie.dmn.model.api.NamedElement;
import org.kie.dmn.model.api.dmndi.DMNDI;

public interface Definitions
extends NamedElement {
    public List<Import> getImport();

    public List<ItemDefinition> getItemDefinition();

    public List<DRGElement> getDrgElement();

    public List<Artifact> getArtifact();

    public List<ElementCollection> getElementCollection();

    public List<BusinessContextElement> getBusinessContextElement();

    public List<DecisionService> getDecisionService();

    default public void normalize() {
        for (ItemDefinition itemDefinition : this.getItemDefinition()) {
            Definitions.processQNameURIs(itemDefinition, this.getNamespace());
        }
    }

    public String getExpressionLanguage();

    public void setExpressionLanguage(String var1);

    public String getTypeLanguage();

    public void setTypeLanguage(String var1);

    public String getNamespace();

    public void setNamespace(String var1);

    public String getExporter();

    public void setExporter(String var1);

    public String getExporterVersion();

    public void setExporterVersion(String var1);

    public DMNDI getDMNDI();

    public void setDMNDI(DMNDI var1);

    private static void processQNameURIs(ItemDefinition iDef, String defaultNamespace) {
        QName typeRef = iDef.getTypeRef();
        if (typeRef != null && "".equals(typeRef.getNamespaceURI())) {
            String prefix = typeRef.getPrefix();
            String namespace = prefix != null && !prefix.isEmpty() ? iDef.getNamespaceURI(prefix) : defaultNamespace;
            iDef.setTypeRef(new QName(namespace, typeRef.getLocalPart(), typeRef.getPrefix()));
        }
        for (ItemDefinition comp : iDef.getItemComponent()) {
            Definitions.processQNameURIs(comp, defaultNamespace);
        }
    }
}

