/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.efesto.runtime.utils;

import java.util.Map;
import java.util.Optional;
import org.kie.dmn.api.core.DMNModel;
import org.kie.dmn.api.core.DMNResult;
import org.kie.dmn.efesto.runtime.model.EfestoOutputDMN;
import org.kie.dmn.efesto.runtime.service.DMNEvaluator;
import org.kie.efesto.common.api.identifiers.ModelLocalUriId;
import org.kie.efesto.common.api.model.EfestoContext;
import org.kie.efesto.runtimemanager.api.model.EfestoInput;
import org.kie.efesto.runtimemanager.api.model.EfestoLocalRuntimeContext;
import org.kie.efesto.runtimemanager.api.utils.GeneratedResourceUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DmnRuntimeHelper {
    private static final Logger logger = LoggerFactory.getLogger((String)DmnRuntimeHelper.class.getName());

    private DmnRuntimeHelper() {
    }

    public static boolean canManage(EfestoInput toEvaluate, EfestoLocalRuntimeContext context) {
        return GeneratedResourceUtils.isPresentExecutableOrModelOrRedirect((ModelLocalUriId)toEvaluate.getModelLocalUriId(), (EfestoContext)context);
    }

    public static Optional<EfestoOutputDMN> execute(EfestoInput<Map<String, Object>> toEvaluate, EfestoLocalRuntimeContext runtimeContext) {
        ModelLocalUriId modelLocalUriId = toEvaluate.getModelLocalUriId();
        Optional generatedModelResource = GeneratedResourceUtils.getGeneratedModelResource((ModelLocalUriId)modelLocalUriId, (Map)runtimeContext.getGeneratedResourcesMap());
        return generatedModelResource.map(it -> {
            if (it.getCompiledModel() != null) {
                return DmnRuntimeHelper.execute((DMNModel)it.getCompiledModel(), modelLocalUriId, (Map<String, Object>)((Map)toEvaluate.getInputData()));
            }
            return DmnRuntimeHelper.execute(it.getModelSource(), modelLocalUriId, (Map<String, Object>)((Map)toEvaluate.getInputData()));
        });
    }

    static EfestoOutputDMN execute(DMNModel model, ModelLocalUriId modelLocalUriId, Map<String, Object> inputData) {
        try {
            DMNEvaluator dmnEvaluator = DMNEvaluator.fromDMNModel(model);
            DMNResult dmnResult = dmnEvaluator.evaluate(inputData);
            return new EfestoOutputDMN(modelLocalUriId, dmnResult);
        }
        catch (Exception e) {
            logger.error("Failed to evaluate {}", inputData, (Object)e);
            return null;
        }
    }

    static EfestoOutputDMN execute(String modelSource, ModelLocalUriId modelLocalUriId, Map<String, Object> inputData) {
        try {
            DMNEvaluator dmnEvaluator = DMNEvaluator.fromXML(modelSource);
            DMNResult dmnResult = dmnEvaluator.evaluate(inputData);
            return new EfestoOutputDMN(modelLocalUriId, dmnResult);
        }
        catch (Exception e) {
            logger.error("Failed to evaluate {}", inputData, (Object)e);
            return null;
        }
    }
}

