/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.efesto.compiler.service;

import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import org.kie.dmn.efesto.compiler.model.DmnCompilationContext;
import org.kie.dmn.efesto.compiler.service.AbstractKieCompilerServiceDMN;
import org.kie.dmn.efesto.compiler.utils.DmnCompilerUtils;
import org.kie.efesto.common.api.identifiers.LocalUri;
import org.kie.efesto.common.api.identifiers.ModelLocalUriId;
import org.kie.efesto.common.api.model.EfestoCompilationContext;
import org.kie.efesto.compilationmanager.api.exceptions.KieCompilerServiceException;
import org.kie.efesto.compilationmanager.api.model.EfestoCompilationOutput;
import org.kie.efesto.compilationmanager.api.model.EfestoResource;
import org.kie.efesto.compilationmanager.api.model.EfestoStringResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KieCompilerServiceDMNString
extends AbstractKieCompilerServiceDMN {
    private static final Logger LOGGER = LoggerFactory.getLogger(KieCompilerServiceDMNString.class);

    public boolean canManageResource(EfestoResource toProcess) {
        EfestoStringResource efestoStringResource;
        return toProcess instanceof EfestoStringResource && (efestoStringResource = (EfestoStringResource)toProcess).getModelLocalUriId().model().equalsIgnoreCase("dmn");
    }

    public List<EfestoCompilationOutput> processResource(EfestoResource toProcess, EfestoCompilationContext context) {
        if (!this.canManageResource(toProcess)) {
            throw new KieCompilerServiceException(String.format("%s can not process %s", this.getClass().getName(), toProcess.getClass().getName()));
        }
        if (!(context instanceof DmnCompilationContext)) {
            throw new KieCompilerServiceException(String.format("Wrong %s context parameter for from %s", context.getClass().getName(), this.getClass().getName()));
        }
        DmnCompilationContext dmnContext = (DmnCompilationContext)context;
        EfestoStringResource stringResource = (EfestoStringResource)toProcess;
        String modelSource = stringResource.getContent();
        ModelLocalUriId modelLocalUriId = stringResource.getModelLocalUriId();
        String parentComponent = ((LocalUri.LocalUriPathComponent)modelLocalUriId.asLocalUri().parent()).getComponent();
        String basePath = parentComponent.equals(modelLocalUriId.model()) ? modelLocalUriId.basePath() : parentComponent;
        String fileName = URLDecoder.decode(basePath, StandardCharsets.UTF_8);
        fileName = DmnCompilerUtils.getCleanedFilenameForURI(fileName);
        List<AbstractKieCompilerServiceDMN.ModelSourceTuple> modelSourceTuples = Collections.singletonList(new AbstractKieCompilerServiceDMN.ModelSourceTuple(DmnCompilerUtils.getDMNModel(modelSource, fileName), modelSource));
        return this.getListEfestoCompilationOutput(modelSourceTuples, dmnContext, LOGGER);
    }
}

