/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.efesto.compiler.service;

import java.util.List;
import java.util.Set;
import org.kie.dmn.api.core.DMNModel;
import org.kie.dmn.efesto.compiler.model.DmnCompilationContext;
import org.kie.dmn.efesto.compiler.service.AbstractKieCompilerServiceDMN;
import org.kie.dmn.efesto.compiler.utils.DmnCompilerUtils;
import org.kie.efesto.common.api.model.EfestoCompilationContext;
import org.kie.efesto.compilationmanager.api.exceptions.KieCompilerServiceException;
import org.kie.efesto.compilationmanager.api.model.EfestoCompilationOutput;
import org.kie.efesto.compilationmanager.api.model.EfestoFileSetResource;
import org.kie.efesto.compilationmanager.api.model.EfestoResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KieCompilerServiceDMNFileSet
extends AbstractKieCompilerServiceDMN {
    private static final Logger LOGGER = LoggerFactory.getLogger(KieCompilerServiceDMNFileSet.class);

    public boolean canManageResource(EfestoResource toProcess) {
        EfestoFileSetResource efestoFileSetResource;
        return toProcess instanceof EfestoFileSetResource && (efestoFileSetResource = (EfestoFileSetResource)toProcess).getModelLocalUriId().model().equalsIgnoreCase("dmn");
    }

    public List<EfestoCompilationOutput> processResource(EfestoResource toProcess, EfestoCompilationContext context) {
        if (!this.canManageResource(toProcess)) {
            throw new KieCompilerServiceException(String.format("%s can not process %s", this.getClass().getName(), toProcess.getClass().getName()));
        }
        if (!(context instanceof DmnCompilationContext)) {
            throw new KieCompilerServiceException(String.format("Wrong %s context parameter for from %s", context.getClass().getName(), this.getClass().getName()));
        }
        DmnCompilationContext dmnContext = (DmnCompilationContext)context;
        EfestoFileSetResource fileSetResource = (EfestoFileSetResource)toProcess;
        Set dmnFiles = fileSetResource.getContent();
        List<DMNModel> dmnModels = DmnCompilerUtils.getDMNModelsFromFiles(dmnFiles, dmnContext.getCustomDMNProfiles(), dmnContext.getRuntimeTypeCheckOption(), dmnContext.getContextClassloader());
        List<AbstractKieCompilerServiceDMN.ModelSourceTuple> modelSourceTuples = dmnModels.stream().map(this::readDMNModel).toList();
        return this.getListEfestoCompilationOutput(modelSourceTuples, dmnContext, LOGGER);
    }
}

