/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.efesto.compiler.service;

import java.io.File;
import java.util.List;
import java.util.Set;
import org.kie.dmn.api.core.DMNModel;
import org.kie.dmn.efesto.compiler.model.DmnCompilationContext;
import org.kie.dmn.efesto.compiler.service.AbstractKieCompilerServiceDMN;
import org.kie.dmn.efesto.compiler.utils.DmnCompilerUtils;
import org.kie.efesto.common.api.model.EfestoCompilationContext;
import org.kie.efesto.compilationmanager.api.exceptions.KieCompilerServiceException;
import org.kie.efesto.compilationmanager.api.model.EfestoCompilationOutput;
import org.kie.efesto.compilationmanager.api.model.EfestoFileResource;
import org.kie.efesto.compilationmanager.api.model.EfestoResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KieCompilerServiceDMNFile
extends AbstractKieCompilerServiceDMN {
    private static final Logger LOGGER = LoggerFactory.getLogger(KieCompilerServiceDMNFile.class);

    public boolean canManageResource(EfestoResource toProcess) {
        EfestoFileResource efestoFileResource;
        return toProcess instanceof EfestoFileResource && (efestoFileResource = (EfestoFileResource)toProcess).getModelType().equalsIgnoreCase("dmn");
    }

    public List<EfestoCompilationOutput> processResource(EfestoResource toProcess, EfestoCompilationContext context) {
        if (!this.canManageResource(toProcess)) {
            throw new KieCompilerServiceException(String.format("%s can not process %s", this.getClass().getName(), toProcess.getClass().getName()));
        }
        if (!(context instanceof DmnCompilationContext)) {
            throw new KieCompilerServiceException(String.format("Wrong %s context parameter for from %s", context.getClass().getName(), this.getClass().getName()));
        }
        DmnCompilationContext dmnContext = (DmnCompilationContext)context;
        EfestoFileResource fileResource = (EfestoFileResource)toProcess;
        Set<File> dmnFiles = Set.of(fileResource.getContent());
        List<DMNModel> dmnModels = DmnCompilerUtils.getDMNModelsFromFiles(dmnFiles, dmnContext.getCustomDMNProfiles(), dmnContext.getRuntimeTypeCheckOption(), dmnContext.getContextClassloader());
        List<AbstractKieCompilerServiceDMN.ModelSourceTuple> modelSourceTuples = dmnModels.stream().map(this::readDMNModel).toList();
        return this.getListEfestoCompilationOutput(modelSourceTuples, dmnContext, LOGGER);
    }
}

