/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.backend.marshalling.v1_6.xstream;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.AbstractPullReader;
import com.thoughtworks.xstream.io.xml.QNameMap;
import com.thoughtworks.xstream.io.xml.StaxDriver;
import com.thoughtworks.xstream.io.xml.StaxWriter;
import com.thoughtworks.xstream.security.TypeHierarchyPermission;
import com.thoughtworks.xstream.security.TypePermission;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.kie.dmn.api.marshalling.DMNExtensionRegister;
import org.kie.dmn.backend.marshalling.AbstractXStreamMarshaller;
import org.kie.dmn.backend.marshalling.CustomStaxReader;
import org.kie.dmn.backend.marshalling.CustomStaxWriter;
import org.kie.dmn.backend.marshalling.v1_6.xstream.AssociationConverter;
import org.kie.dmn.backend.marshalling.v1_6.xstream.AuthorityRequirementConverter;
import org.kie.dmn.backend.marshalling.v1_6.xstream.BindingConverter;
import org.kie.dmn.backend.marshalling.v1_6.xstream.BoundsConverter;
import org.kie.dmn.backend.marshalling.v1_6.xstream.BusinessKnowledgeModelConverter;
import org.kie.dmn.backend.marshalling.v1_6.xstream.ChildExpressionConverter;
import org.kie.dmn.backend.marshalling.v1_6.xstream.ColorConverter;
import org.kie.dmn.backend.marshalling.v1_6.xstream.ConditionalConverter;
import org.kie.dmn.backend.marshalling.v1_6.xstream.ContextConverter;
import org.kie.dmn.backend.marshalling.v1_6.xstream.ContextEntryConverter;
import org.kie.dmn.backend.marshalling.v1_6.xstream.DMNDIConverter;
import org.kie.dmn.backend.marshalling.v1_6.xstream.DMNDecisionServiceDividerLineConverter;
import org.kie.dmn.backend.marshalling.v1_6.xstream.DMNDiagramConverter;
import org.kie.dmn.backend.marshalling.v1_6.xstream.DMNEdgeConverter;
import org.kie.dmn.backend.marshalling.v1_6.xstream.DMNElementReferenceConverter;
import org.kie.dmn.backend.marshalling.v1_6.xstream.DMNLabelConverter;
import org.kie.dmn.backend.marshalling.v1_6.xstream.DMNListConverter;
import org.kie.dmn.backend.marshalling.v1_6.xstream.DMNShapeConverter;
import org.kie.dmn.backend.marshalling.v1_6.xstream.DMNStyleConverter;
import org.kie.dmn.backend.marshalling.v1_6.xstream.DecisionConverter;
import org.kie.dmn.backend.marshalling.v1_6.xstream.DecisionRuleConverter;
import org.kie.dmn.backend.marshalling.v1_6.xstream.DecisionServiceConverter;
import org.kie.dmn.backend.marshalling.v1_6.xstream.DecisionTableConverter;
import org.kie.dmn.backend.marshalling.v1_6.xstream.DefinitionsConverter;
import org.kie.dmn.backend.marshalling.v1_6.xstream.DiagramElementExtensionConverter;
import org.kie.dmn.backend.marshalling.v1_6.xstream.DimensionConverter;
import org.kie.dmn.backend.marshalling.v1_6.xstream.ElementCollectionConverter;
import org.kie.dmn.backend.marshalling.v1_6.xstream.EveryConverter;
import org.kie.dmn.backend.marshalling.v1_6.xstream.ExtensionElementsConverter;
import org.kie.dmn.backend.marshalling.v1_6.xstream.FilterConverter;
import org.kie.dmn.backend.marshalling.v1_6.xstream.ForConverter;
import org.kie.dmn.backend.marshalling.v1_6.xstream.FunctionDefinitionConverter;
import org.kie.dmn.backend.marshalling.v1_6.xstream.FunctionItemConverter;
import org.kie.dmn.backend.marshalling.v1_6.xstream.GroupConverter;
import org.kie.dmn.backend.marshalling.v1_6.xstream.ImportConverter;
import org.kie.dmn.backend.marshalling.v1_6.xstream.ImportedValuesConverter;
import org.kie.dmn.backend.marshalling.v1_6.xstream.InformationItemConverter;
import org.kie.dmn.backend.marshalling.v1_6.xstream.InformationRequirementConverter;
import org.kie.dmn.backend.marshalling.v1_6.xstream.InputClauseConverter;
import org.kie.dmn.backend.marshalling.v1_6.xstream.InputDataConverter;
import org.kie.dmn.backend.marshalling.v1_6.xstream.InvocationConverter;
import org.kie.dmn.backend.marshalling.v1_6.xstream.ItemDefinitionConverter;
import org.kie.dmn.backend.marshalling.v1_6.xstream.KnowledgeRequirementConverter;
import org.kie.dmn.backend.marshalling.v1_6.xstream.KnowledgeSourceConverter;
import org.kie.dmn.backend.marshalling.v1_6.xstream.LiteralExpressionConverter;
import org.kie.dmn.backend.marshalling.v1_6.xstream.OrganizationUnitConverter;
import org.kie.dmn.backend.marshalling.v1_6.xstream.OutputClauseConverter;
import org.kie.dmn.backend.marshalling.v1_6.xstream.PerformanceIndicatorConverter;
import org.kie.dmn.backend.marshalling.v1_6.xstream.PointConverter;
import org.kie.dmn.backend.marshalling.v1_6.xstream.QNameConverter;
import org.kie.dmn.backend.marshalling.v1_6.xstream.RelationConverter;
import org.kie.dmn.backend.marshalling.v1_6.xstream.RuleAnnotationClauseConverter;
import org.kie.dmn.backend.marshalling.v1_6.xstream.RuleAnnotationConverter;
import org.kie.dmn.backend.marshalling.v1_6.xstream.SomeConverter;
import org.kie.dmn.backend.marshalling.v1_6.xstream.TextAnnotationConverter;
import org.kie.dmn.backend.marshalling.v1_6.xstream.TypedChildExpressionConverter;
import org.kie.dmn.backend.marshalling.v1_6.xstream.UnaryTestsConverter;
import org.kie.dmn.backend.marshalling.v1x.DMNXStream;
import org.kie.dmn.model.api.Definitions;
import org.kie.dmn.model.v1_6.KieDMNModelInstrumentedBase;
import org.kie.dmn.model.v1_6.TArtifact;
import org.kie.dmn.model.v1_6.TAssociation;
import org.kie.dmn.model.v1_6.TAuthorityRequirement;
import org.kie.dmn.model.v1_6.TBinding;
import org.kie.dmn.model.v1_6.TBusinessContextElement;
import org.kie.dmn.model.v1_6.TBusinessKnowledgeModel;
import org.kie.dmn.model.v1_6.TConditional;
import org.kie.dmn.model.v1_6.TContext;
import org.kie.dmn.model.v1_6.TContextEntry;
import org.kie.dmn.model.v1_6.TDMNElement;
import org.kie.dmn.model.v1_6.TDMNElementReference;
import org.kie.dmn.model.v1_6.TDecision;
import org.kie.dmn.model.v1_6.TDecisionRule;
import org.kie.dmn.model.v1_6.TDecisionService;
import org.kie.dmn.model.v1_6.TDecisionTable;
import org.kie.dmn.model.v1_6.TDefinitions;
import org.kie.dmn.model.v1_6.TElementCollection;
import org.kie.dmn.model.v1_6.TEvery;
import org.kie.dmn.model.v1_6.TExpression;
import org.kie.dmn.model.v1_6.TFilter;
import org.kie.dmn.model.v1_6.TFor;
import org.kie.dmn.model.v1_6.TFunctionDefinition;
import org.kie.dmn.model.v1_6.TFunctionItem;
import org.kie.dmn.model.v1_6.TGroup;
import org.kie.dmn.model.v1_6.TImport;
import org.kie.dmn.model.v1_6.TImportedValues;
import org.kie.dmn.model.v1_6.TInformationItem;
import org.kie.dmn.model.v1_6.TInformationRequirement;
import org.kie.dmn.model.v1_6.TInputClause;
import org.kie.dmn.model.v1_6.TInputData;
import org.kie.dmn.model.v1_6.TInvocation;
import org.kie.dmn.model.v1_6.TItemDefinition;
import org.kie.dmn.model.v1_6.TKnowledgeRequirement;
import org.kie.dmn.model.v1_6.TKnowledgeSource;
import org.kie.dmn.model.v1_6.TList;
import org.kie.dmn.model.v1_6.TLiteralExpression;
import org.kie.dmn.model.v1_6.TNamedElement;
import org.kie.dmn.model.v1_6.TOrganizationUnit;
import org.kie.dmn.model.v1_6.TOutputClause;
import org.kie.dmn.model.v1_6.TPerformanceIndicator;
import org.kie.dmn.model.v1_6.TRelation;
import org.kie.dmn.model.v1_6.TRuleAnnotation;
import org.kie.dmn.model.v1_6.TRuleAnnotationClause;
import org.kie.dmn.model.v1_6.TSome;
import org.kie.dmn.model.v1_6.TTextAnnotation;
import org.kie.dmn.model.v1_6.TUnaryTests;
import org.kie.dmn.model.v1_6.dmndi.Bounds;
import org.kie.dmn.model.v1_6.dmndi.Color;
import org.kie.dmn.model.v1_6.dmndi.DMNDI;
import org.kie.dmn.model.v1_6.dmndi.DMNDecisionServiceDividerLine;
import org.kie.dmn.model.v1_6.dmndi.DMNDiagram;
import org.kie.dmn.model.v1_6.dmndi.DMNEdge;
import org.kie.dmn.model.v1_6.dmndi.DMNLabel;
import org.kie.dmn.model.v1_6.dmndi.DMNShape;
import org.kie.dmn.model.v1_6.dmndi.DMNStyle;
import org.kie.dmn.model.v1_6.dmndi.DiagramElement;
import org.kie.dmn.model.v1_6.dmndi.Dimension;
import org.kie.dmn.model.v1_6.dmndi.Point;
import org.kie.utll.xml.XStreamUtils;

public class XStreamMarshaller
extends AbstractXStreamMarshaller {
    private static StaxDriver staxDriver = new StaxDriver(){

        public AbstractPullReader createStaxReader(XMLStreamReader in) {
            return new CustomStaxReader(this.getQnameMap(), in);
        }

        public StaxWriter createStaxWriter(XMLStreamWriter out, boolean writeStartEndDocument) throws XMLStreamException {
            return new CustomStaxWriter(this.newQNameMap(), out, writeStartEndDocument, this.isRepairingNamespace(), this.getNameCoder());
        }

        public QNameMap newQNameMap() {
            QNameMap qmap = new QNameMap();
            XStreamMarshaller.configureQNameMap(qmap);
            return qmap;
        }
    };

    public static void configureQNameMap(QNameMap qmap) {
        qmap.setDefaultNamespace("https://www.omg.org/spec/DMN/20240513/MODEL/");
    }

    public XStreamMarshaller() {
        super(staxDriver);
    }

    public XStreamMarshaller(List<DMNExtensionRegister> extensionRegisters) {
        super(staxDriver, extensionRegisters);
    }

    @Override
    protected boolean isURIDMNEquals(String value) {
        return "https://www.omg.org/spec/DMN/20240513/MODEL/".equals(value);
    }

    @Override
    protected XStream newXStream() {
        XStream xStream = XStreamUtils.createNonTrustingXStream((HierarchicalStreamDriver)staxDriver, (ClassLoader)Definitions.class.getClassLoader(), DMNXStream::from);
        xStream.addPermission((TypePermission)new TypeHierarchyPermission(QName.class));
        xStream.addPermission((TypePermission)new TypeHierarchyPermission(KieDMNModelInstrumentedBase.class));
        xStream.addPermission((TypePermission)new TypeHierarchyPermission(org.kie.dmn.model.v1_4.KieDMNModelInstrumentedBase.class));
        xStream.alias("artifact", TArtifact.class);
        xStream.alias("definitions", TDefinitions.class);
        xStream.alias("inputData", TInputData.class);
        xStream.alias("decision", TDecision.class);
        xStream.alias("variable", TInformationItem.class);
        xStream.alias("informationRequirement", TInformationRequirement.class);
        xStream.alias("requiredInput", TDMNElementReference.class);
        xStream.alias("literalExpression", TLiteralExpression.class);
        xStream.alias("DMNElement", TDMNElement.class);
        xStream.alias("allowedValues", TUnaryTests.class);
        xStream.alias("artifact", TArtifact.class);
        xStream.alias("association", TAssociation.class);
        xStream.alias("authorityRequirement", TAuthorityRequirement.class);
        xStream.alias("binding", TBinding.class);
        xStream.alias("businessContextElement", TBusinessContextElement.class);
        xStream.alias("businessKnowledgeModel", TBusinessKnowledgeModel.class);
        xStream.alias("column", TInformationItem.class);
        xStream.alias("context", TContext.class);
        xStream.alias("contextEntry", TContextEntry.class);
        xStream.alias("decision", TDecision.class);
        xStream.alias("decisionMade", TDMNElementReference.class);
        xStream.alias("decisionMaker", TDMNElementReference.class);
        xStream.alias("decisionOwned", TDMNElementReference.class);
        xStream.alias("decisionOwner", TDMNElementReference.class);
        xStream.alias("decisionService", TDecisionService.class);
        xStream.alias("decisionTable", TDecisionTable.class);
        xStream.alias("defaultOutputEntry", TLiteralExpression.class);
        xStream.alias("definitions", TDefinitions.class);
        xStream.alias("drgElement", TDMNElementReference.class);
        xStream.alias("elementCollection", TElementCollection.class);
        xStream.alias("encapsulatedDecision", TDMNElementReference.class);
        xStream.alias("encapsulatedLogic", TFunctionDefinition.class);
        xStream.alias("expression", TExpression.class);
        xStream.alias("formalParameter", TInformationItem.class);
        xStream.alias("functionItem", TFunctionItem.class);
        xStream.alias("functionDefinition", TFunctionDefinition.class);
        xStream.alias("group", TGroup.class);
        xStream.alias("impactedPerformanceIndicator", TDMNElementReference.class);
        xStream.alias("impactingDecision", TDMNElementReference.class);
        xStream.alias("import", TImport.class);
        xStream.alias("import", TImport.class);
        xStream.alias("importedElement", String.class);
        xStream.alias("importedValues", TImportedValues.class);
        xStream.alias("informationItem", TInformationItem.class);
        xStream.alias("informationRequirement", TInformationRequirement.class);
        xStream.alias("input", TInputClause.class);
        xStream.alias("inputData", TInputData.class);
        xStream.alias("inputDecision", TDMNElementReference.class);
        xStream.alias("inputEntry", TUnaryTests.class);
        xStream.alias("inputExpression", TLiteralExpression.class);
        xStream.alias("inputValues", TUnaryTests.class);
        xStream.alias("invocation", TInvocation.class);
        xStream.alias("itemComponent", TItemDefinition.class);
        xStream.alias("itemDefinition", TItemDefinition.class);
        xStream.alias("knowledgeRequirement", TKnowledgeRequirement.class);
        xStream.alias("knowledgeSource", TKnowledgeSource.class);
        xStream.alias("literalExpression", TLiteralExpression.class);
        xStream.alias("namedElement", TNamedElement.class);
        xStream.alias("organizationUnit", TOrganizationUnit.class);
        xStream.alias("output", TOutputClause.class);
        xStream.alias("outputDecision", TDMNElementReference.class);
        xStream.alias("outputEntry", TLiteralExpression.class);
        xStream.alias("outputValues", TUnaryTests.class);
        xStream.alias("owner", TDMNElementReference.class);
        xStream.alias("parameter", TInformationItem.class);
        xStream.alias("parameters", TInformationItem.class);
        xStream.alias("performanceIndicator", TPerformanceIndicator.class);
        xStream.alias("relation", TRelation.class);
        xStream.alias("requiredAuthority", TDMNElementReference.class);
        xStream.alias("requiredDecision", TDMNElementReference.class);
        xStream.alias("requiredInput", TDMNElementReference.class);
        xStream.alias("requiredKnowledge", TDMNElementReference.class);
        xStream.alias("rule", TDecisionRule.class);
        xStream.alias("sourceRef", TDMNElementReference.class);
        xStream.alias("supportedObjective", TDMNElementReference.class);
        xStream.alias("targetRef", TDMNElementReference.class);
        xStream.alias("textAnnotation", TTextAnnotation.class);
        xStream.alias("type", String.class);
        xStream.alias("typeConstraint", TUnaryTests.class);
        xStream.alias("typeRef", QName.class);
        xStream.alias("usingProcess", TDMNElementReference.class);
        xStream.alias("usingTask", TDMNElementReference.class);
        xStream.alias("useAlternativeInputDataShape", Boolean.class);
        xStream.alias("variable", TInformationItem.class);
        xStream.alias("row", TList.class);
        xStream.alias("list", TList.class);
        xStream.alias("extensionElements", TDMNElement.TExtensionElements.class);
        xStream.alias("text", String.class);
        xStream.alias("question", String.class);
        xStream.alias("allowedAnswers", String.class);
        xStream.alias("description", String.class);
        xStream.alias("annotation", TRuleAnnotationClause.class);
        xStream.alias("annotationEntry", TRuleAnnotation.class);
        xStream.registerConverter((Converter)new RuleAnnotationClauseConverter(xStream));
        xStream.registerConverter((Converter)new RuleAnnotationConverter(xStream));
        xStream.alias("DMNDI", DMNDI.class);
        xStream.registerConverter((Converter)new DMNDIConverter(xStream));
        xStream.alias("DMNDiagram", DMNDiagram.class);
        xStream.registerConverter((Converter)new DMNDiagramConverter(xStream));
        xStream.alias("DMNStyle", DMNStyle.class);
        xStream.registerConverter((Converter)new DMNStyleConverter(xStream));
        xStream.alias("Size", Dimension.class);
        xStream.registerConverter((Converter)new DimensionConverter(xStream));
        xStream.alias("DMNShape", DMNShape.class);
        xStream.registerConverter((Converter)new DMNShapeConverter(xStream));
        xStream.alias("FillColor", Color.class);
        xStream.alias("StrokeColor", Color.class);
        xStream.alias("FontColor", Color.class);
        xStream.registerConverter((Converter)new ColorConverter(xStream));
        xStream.alias("Bounds", Bounds.class);
        xStream.registerConverter((Converter)new BoundsConverter(xStream));
        xStream.alias("DMNLabel", DMNLabel.class);
        xStream.registerConverter((Converter)new DMNLabelConverter(xStream));
        xStream.alias("DMNEdge", DMNEdge.class);
        xStream.registerConverter((Converter)new DMNEdgeConverter(xStream));
        xStream.alias("DMNDecisionServiceDividerLine", DMNDecisionServiceDividerLine.class);
        xStream.registerConverter((Converter)new DMNDecisionServiceDividerLineConverter(xStream));
        xStream.alias("waypoint", Point.class);
        xStream.registerConverter((Converter)new PointConverter(xStream));
        xStream.alias("extension", DiagramElement.Extension.class);
        xStream.alias("Text", String.class);
        xStream.alias("for", TFor.class);
        xStream.alias("every", TEvery.class);
        xStream.alias("some", TSome.class);
        xStream.alias("conditional", TConditional.class);
        xStream.alias("filter", TFilter.class);
        xStream.registerConverter((Converter)new AssociationConverter(xStream));
        xStream.registerConverter((Converter)new AuthorityRequirementConverter(xStream));
        xStream.registerConverter((Converter)new BindingConverter(xStream));
        xStream.registerConverter((Converter)new BusinessKnowledgeModelConverter(xStream));
        xStream.registerConverter((Converter)new ContextConverter(xStream));
        xStream.registerConverter((Converter)new ContextEntryConverter(xStream));
        xStream.registerConverter((Converter)new DecisionConverter(xStream));
        xStream.registerConverter((Converter)new DecisionRuleConverter(xStream));
        xStream.registerConverter((Converter)new DecisionServiceConverter(xStream));
        xStream.registerConverter((Converter)new DecisionTableConverter(xStream));
        xStream.registerConverter((Converter)new DefinitionsConverter(xStream));
        xStream.registerConverter((Converter)new DMNElementReferenceConverter(xStream));
        xStream.registerConverter((Converter)new GroupConverter(xStream));
        xStream.registerConverter((Converter)new FunctionDefinitionConverter(xStream));
        xStream.registerConverter((Converter)new ImportConverter(xStream));
        xStream.registerConverter((Converter)new ImportedValuesConverter(xStream));
        xStream.registerConverter((Converter)new InformationItemConverter(xStream));
        xStream.registerConverter((Converter)new InformationRequirementConverter(xStream));
        xStream.registerConverter((Converter)new InputClauseConverter(xStream));
        xStream.registerConverter((Converter)new InputDataConverter(xStream));
        xStream.registerConverter((Converter)new InvocationConverter(xStream));
        xStream.registerConverter((Converter)new ItemDefinitionConverter(xStream));
        xStream.registerConverter((Converter)new KnowledgeRequirementConverter(xStream));
        xStream.registerConverter((Converter)new KnowledgeSourceConverter(xStream));
        xStream.registerConverter((Converter)new LiteralExpressionConverter(xStream));
        xStream.registerConverter((Converter)new OrganizationUnitConverter(xStream));
        xStream.registerConverter((Converter)new OutputClauseConverter(xStream));
        xStream.registerConverter((Converter)new PerformanceIndicatorConverter(xStream));
        xStream.registerConverter((Converter)new RelationConverter(xStream));
        xStream.registerConverter((Converter)new TextAnnotationConverter(xStream));
        xStream.registerConverter((Converter)new UnaryTestsConverter(xStream));
        xStream.registerConverter((Converter)new FunctionItemConverter(xStream));
        xStream.registerConverter((Converter)new ChildExpressionConverter(xStream));
        xStream.registerConverter((Converter)new TypedChildExpressionConverter(xStream));
        xStream.registerConverter((Converter)new ForConverter(xStream));
        xStream.registerConverter((Converter)new EveryConverter(xStream));
        xStream.registerConverter((Converter)new SomeConverter(xStream));
        xStream.registerConverter((Converter)new ConditionalConverter(xStream));
        xStream.registerConverter((Converter)new FilterConverter(xStream));
        xStream.registerConverter((Converter)new QNameConverter());
        xStream.registerConverter((Converter)new DMNListConverter(xStream));
        xStream.registerConverter((Converter)new ElementCollectionConverter(xStream));
        xStream.registerConverter((Converter)new ExtensionElementsConverter(xStream, this.extensionRegisters));
        xStream.registerConverter((Converter)new DiagramElementExtensionConverter(xStream, this.extensionRegisters));
        for (DMNExtensionRegister extensionRegister : this.extensionRegisters) {
            extensionRegister.registerExtensionConverters(xStream);
        }
        xStream.ignoreUnknownElements();
        return xStream;
    }

    static {
        QNameMap qmap = new QNameMap();
        XStreamMarshaller.configureQNameMap(qmap);
        staxDriver.setQnameMap(qmap);
        staxDriver.setRepairingNamespace(false);
    }
}

