/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.backend.marshalling.v1_4.xstream;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.Converter;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.namespace.QName;
import org.kie.dmn.backend.marshalling.v1x.ConverterDefinesExpressionNodeName;
import org.kie.dmn.model.api.Conditional;
import org.kie.dmn.model.api.Context;
import org.kie.dmn.model.api.DMNModelInstrumentedBase;
import org.kie.dmn.model.api.DecisionTable;
import org.kie.dmn.model.api.Every;
import org.kie.dmn.model.api.Expression;
import org.kie.dmn.model.api.Filter;
import org.kie.dmn.model.api.For;
import org.kie.dmn.model.api.FunctionDefinition;
import org.kie.dmn.model.api.Invocation;
import org.kie.dmn.model.api.List;
import org.kie.dmn.model.api.LiteralExpression;
import org.kie.dmn.model.api.Relation;
import org.kie.dmn.model.api.Some;
import org.kie.dmn.model.api.dmndi.DMNEdge;
import org.kie.dmn.model.api.dmndi.DMNShape;

public final class MarshallingUtils {
    private static final Pattern QNAME_PAT = Pattern.compile("(\\{([^\\}]*)\\})?(([^:]*):)?(.*)");

    public static QName parseQNameString(String qns) {
        if (qns != null) {
            Matcher m = QNAME_PAT.matcher(qns);
            if (m.matches()) {
                if (m.group(4) != null) {
                    return new QName(m.group(2), m.group(5), m.group(4));
                }
                return new QName(m.group(2), m.group(5));
            }
            return new QName(qns);
        }
        return null;
    }

    public static String formatQName(QName qname, DMNModelInstrumentedBase parent) {
        if (!"".equals(qname.getPrefix())) {
            String nsForPrefix = parent.getNamespaceURI(qname.getPrefix());
            if (parent.getURIFEEL().equals(nsForPrefix)) {
                return qname.getLocalPart();
            }
            if (parent instanceof DMNShape || parent instanceof DMNEdge) {
                return qname.getPrefix() + ":" + qname.getLocalPart();
            }
            return qname.getPrefix() + "." + qname.getLocalPart();
        }
        return qname.toString();
    }

    public static String defineExpressionNodeName(XStream xstream, Expression e) {
        Converter converter = xstream.getConverterLookup().lookupConverterForType(e.getClass());
        if (converter instanceof ConverterDefinesExpressionNodeName) {
            ConverterDefinesExpressionNodeName defines = (ConverterDefinesExpressionNodeName)converter;
            return defines.defineExpressionNodeName(e);
        }
        return MarshallingUtils.defineExpressionNodeName(e);
    }

    private static String defineExpressionNodeName(Expression e) {
        String nodeName = "expression";
        if (e instanceof Context) {
            nodeName = "context";
        } else if (e instanceof DecisionTable) {
            nodeName = "decisionTable";
        } else if (e instanceof FunctionDefinition) {
            nodeName = "functionDefinition";
        } else if (e instanceof Invocation) {
            nodeName = "invocation";
        } else if (e instanceof LiteralExpression) {
            nodeName = "literalExpression";
        } else if (e instanceof Relation) {
            nodeName = "relation";
        } else if (e instanceof List) {
            nodeName = "list";
        } else if (e instanceof For) {
            nodeName = "for";
        } else if (e instanceof Every) {
            nodeName = "every";
        } else if (e instanceof Some) {
            nodeName = "some";
        } else if (e instanceof Conditional) {
            nodeName = "conditional";
        } else if (e instanceof Filter) {
            nodeName = "filter";
        }
        return nodeName;
    }

    private MarshallingUtils() {
    }
}

