/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.backend.marshalling.v1_5.xstream;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import org.kie.dmn.backend.marshalling.v1_5.xstream.InvocableConverter;
import org.kie.dmn.model.api.DMNElementReference;
import org.kie.dmn.model.api.DMNModelInstrumentedBase;
import org.kie.dmn.model.api.DecisionService;
import org.kie.dmn.model.impl.AbstractKieDMNModelInstrumentedBase;
import org.kie.dmn.model.v1_5.TDMNElementReference;
import org.kie.dmn.model.v1_5.TDecisionService;

public class DecisionServiceConverter
extends InvocableConverter {
    public static final String OUTPUT_DECISION = "outputDecision";
    public static final String ENCAPSULATED_DECISION = "encapsulatedDecision";
    public static final String INPUT_DECISION = "inputDecision";
    public static final String INPUT_DATA = "inputData";

    public DecisionServiceConverter(XStream xstream) {
        super(xstream);
    }

    @Override
    protected DMNModelInstrumentedBase createModelObject() {
        return new TDecisionService();
    }

    public boolean canConvert(Class clazz) {
        return clazz.equals(TDecisionService.class);
    }

    @Override
    protected void parseElements(HierarchicalStreamReader reader, UnmarshallingContext context, Object parent) {
        while (reader.hasMoreChildren()) {
            Object object;
            reader.moveDown();
            String nodeName = reader.getNodeName();
            if (nodeName.equals(INPUT_DATA)) {
                TDMNElementReference ref = new TDMNElementReference();
                ref.setHref(reader.getAttribute("href"));
                object = ref;
            } else {
                object = this.readItem(reader, context, null);
            }
            if (object instanceof DMNModelInstrumentedBase) {
                ((AbstractKieDMNModelInstrumentedBase)object).setParent((DMNModelInstrumentedBase)((AbstractKieDMNModelInstrumentedBase)parent));
                ((AbstractKieDMNModelInstrumentedBase)parent).addChildren((DMNModelInstrumentedBase)((AbstractKieDMNModelInstrumentedBase)object));
            }
            reader.moveUp();
            this.assignChildElement(parent, nodeName, object);
        }
    }

    @Override
    protected void assignChildElement(Object parent, String nodeName, Object child) {
        DecisionService decisionService = (DecisionService)parent;
        switch (nodeName) {
            case "outputDecision": {
                decisionService.getOutputDecision().add((DMNElementReference)child);
                break;
            }
            case "encapsulatedDecision": {
                decisionService.getEncapsulatedDecision().add((DMNElementReference)child);
                break;
            }
            case "inputDecision": {
                decisionService.getInputDecision().add((DMNElementReference)child);
                break;
            }
            case "inputData": {
                decisionService.getInputData().add((DMNElementReference)child);
                break;
            }
            default: {
                super.assignChildElement(parent, nodeName, child);
            }
        }
    }

    @Override
    protected void writeChildren(HierarchicalStreamWriter writer, MarshallingContext context, Object parent) {
        super.writeChildren(writer, context, parent);
        DecisionService decisionService = (DecisionService)parent;
        for (DMNElementReference ref : decisionService.getOutputDecision()) {
            this.writeChildrenNode(writer, context, ref, OUTPUT_DECISION);
        }
        for (DMNElementReference ref : decisionService.getEncapsulatedDecision()) {
            this.writeChildrenNode(writer, context, ref, ENCAPSULATED_DECISION);
        }
        for (DMNElementReference ref : decisionService.getInputDecision()) {
            this.writeChildrenNode(writer, context, ref, INPUT_DECISION);
        }
        for (DMNElementReference ref : decisionService.getInputData()) {
            this.writeChildrenNode(writer, context, ref, INPUT_DATA);
        }
    }
}

