/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.backend.marshalling.v1_5.xstream;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import org.kie.dmn.backend.marshalling.v1_5.xstream.MarshallingUtils;
import org.kie.dmn.backend.marshalling.v1_5.xstream.ShapeConverter;
import org.kie.dmn.model.api.DMNModelInstrumentedBase;
import org.kie.dmn.model.api.dmndi.DMNDecisionServiceDividerLine;
import org.kie.dmn.model.api.dmndi.DMNLabel;
import org.kie.dmn.model.v1_5.dmndi.DMNShape;

public class DMNShapeConverter
extends ShapeConverter {
    private static final String FILL_COLOR = "FillColor";
    private static final String STROKE_COLOR = "StrokeColor";
    private static final String FONT_COLOR = "FontColor";
    private static final String FONT_FAMILY = "fontFamily";
    private static final String FONT_SIZE = "fontSize";
    private static final String FONT_ITALIC = "fontItalic";
    private static final String FONT_BOLD = "fontBold";
    private static final String FONT_UNDERLINE = "fontUnderline";
    private static final String FONT_STRIKE_THROUGH = "fontStrikeThrough";
    private static final String LABEL_HORIZONTAL_ALIGNMENT = "labelHorizontalAlignement";
    private static final String LABEL_VERTICAL_ALIGNMENT = "labelVerticalAlignment";

    @Override
    protected void assignChildElement(Object parent, String nodeName, Object child) {
        DMNShape style = (DMNShape)parent;
        if (child instanceof DMNLabel) {
            style.setDMNLabel((DMNLabel)child);
        } else if (child instanceof DMNDecisionServiceDividerLine) {
            style.setDMNDecisionServiceDividerLine((DMNDecisionServiceDividerLine)child);
        } else {
            super.assignChildElement(style, nodeName, child);
        }
    }

    @Override
    protected void assignAttributes(HierarchicalStreamReader reader, Object parent) {
        super.assignAttributes(reader, parent);
        DMNShape style = (DMNShape)parent;
        style.setDmnElementRef(MarshallingUtils.parseQNameString(reader.getAttribute("dmnElementRef")));
        String isListedInputData = reader.getAttribute("isListedInputData");
        String isCollapsed = reader.getAttribute("isCollapsed");
        if (isListedInputData != null) {
            style.setIsListedInputData(Boolean.valueOf(isListedInputData));
        }
        if (isCollapsed != null) {
            style.setIsCollapsed(Boolean.valueOf(isCollapsed));
        }
    }

    @Override
    protected void writeChildren(HierarchicalStreamWriter writer, MarshallingContext context, Object parent) {
        super.writeChildren(writer, context, parent);
        DMNShape style = (DMNShape)parent;
        if (style.getDMNLabel() != null) {
            this.writeChildrenNode(writer, context, style.getDMNLabel(), "DMNLabel");
        }
        if (style.getDMNDecisionServiceDividerLine() != null) {
            this.writeChildrenNode(writer, context, style.getDMNDecisionServiceDividerLine(), "DMNDecisionServiceDividerLine");
        }
    }

    @Override
    protected void writeAttributes(HierarchicalStreamWriter writer, Object parent) {
        super.writeAttributes(writer, parent);
        DMNShape style = (DMNShape)parent;
        writer.addAttribute("dmnElementRef", MarshallingUtils.formatQName(style.getDmnElementRef(), (DMNModelInstrumentedBase)style));
        if (style.isIsListedInputData() != null) {
            writer.addAttribute("isListedInputData", style.isIsListedInputData().toString());
        }
        writer.addAttribute("isCollapsed", Boolean.valueOf(style.isIsCollapsed()).toString());
    }

    public DMNShapeConverter(XStream xstream) {
        super(xstream);
    }

    @Override
    protected DMNModelInstrumentedBase createModelObject() {
        return new DMNShape();
    }

    public boolean canConvert(Class clazz) {
        return clazz.equals(DMNShape.class);
    }
}

