/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.backend.marshalling.v1_1.xstream;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.AbstractPullReader;
import com.thoughtworks.xstream.io.xml.QNameMap;
import com.thoughtworks.xstream.io.xml.StaxDriver;
import com.thoughtworks.xstream.io.xml.StaxWriter;
import com.thoughtworks.xstream.security.TypeHierarchyPermission;
import com.thoughtworks.xstream.security.TypePermission;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.kie.dmn.api.marshalling.DMNExtensionRegister;
import org.kie.dmn.backend.marshalling.AbstractXStreamMarshaller;
import org.kie.dmn.backend.marshalling.CustomStaxReader;
import org.kie.dmn.backend.marshalling.CustomStaxWriter;
import org.kie.dmn.backend.marshalling.v1_1.xstream.AssociationConverter;
import org.kie.dmn.backend.marshalling.v1_1.xstream.AuthorityRequirementConverter;
import org.kie.dmn.backend.marshalling.v1_1.xstream.BindingConverter;
import org.kie.dmn.backend.marshalling.v1_1.xstream.BusinessKnowledgeModelConverter;
import org.kie.dmn.backend.marshalling.v1_1.xstream.ContextConverter;
import org.kie.dmn.backend.marshalling.v1_1.xstream.ContextEntryConverter;
import org.kie.dmn.backend.marshalling.v1_1.xstream.DMNElementReferenceConverter;
import org.kie.dmn.backend.marshalling.v1_1.xstream.DMNListConverter;
import org.kie.dmn.backend.marshalling.v1_1.xstream.DecisionConverter;
import org.kie.dmn.backend.marshalling.v1_1.xstream.DecisionRuleConverter;
import org.kie.dmn.backend.marshalling.v1_1.xstream.DecisionServiceConverter;
import org.kie.dmn.backend.marshalling.v1_1.xstream.DecisionTableConverter;
import org.kie.dmn.backend.marshalling.v1_1.xstream.DefinitionsConverter;
import org.kie.dmn.backend.marshalling.v1_1.xstream.ElementCollectionConverter;
import org.kie.dmn.backend.marshalling.v1_1.xstream.ExtensionElementsConverter;
import org.kie.dmn.backend.marshalling.v1_1.xstream.FunctionDefinitionConverter;
import org.kie.dmn.backend.marshalling.v1_1.xstream.ImportConverter;
import org.kie.dmn.backend.marshalling.v1_1.xstream.ImportedValuesConverter;
import org.kie.dmn.backend.marshalling.v1_1.xstream.InformationItemConverter;
import org.kie.dmn.backend.marshalling.v1_1.xstream.InformationRequirementConverter;
import org.kie.dmn.backend.marshalling.v1_1.xstream.InputClauseConverter;
import org.kie.dmn.backend.marshalling.v1_1.xstream.InputDataConverter;
import org.kie.dmn.backend.marshalling.v1_1.xstream.InvocationConverter;
import org.kie.dmn.backend.marshalling.v1_1.xstream.ItemDefinitionConverter;
import org.kie.dmn.backend.marshalling.v1_1.xstream.KnowledgeRequirementConverter;
import org.kie.dmn.backend.marshalling.v1_1.xstream.KnowledgeSourceConverter;
import org.kie.dmn.backend.marshalling.v1_1.xstream.LiteralExpressionConverter;
import org.kie.dmn.backend.marshalling.v1_1.xstream.OrganizationUnitConverter;
import org.kie.dmn.backend.marshalling.v1_1.xstream.OutputClauseConverter;
import org.kie.dmn.backend.marshalling.v1_1.xstream.PerformanceIndicatorConverter;
import org.kie.dmn.backend.marshalling.v1_1.xstream.QNameConverter;
import org.kie.dmn.backend.marshalling.v1_1.xstream.RelationConverter;
import org.kie.dmn.backend.marshalling.v1_1.xstream.TextAnnotationConverter;
import org.kie.dmn.backend.marshalling.v1_1.xstream.UnaryTestsConverter;
import org.kie.dmn.backend.marshalling.v1x.DMNXStream;
import org.kie.dmn.model.api.Definitions;
import org.kie.dmn.model.v1_1.KieDMNModelInstrumentedBase;
import org.kie.dmn.model.v1_1.TArtifact;
import org.kie.dmn.model.v1_1.TAssociation;
import org.kie.dmn.model.v1_1.TAuthorityRequirement;
import org.kie.dmn.model.v1_1.TBinding;
import org.kie.dmn.model.v1_1.TBusinessContextElement;
import org.kie.dmn.model.v1_1.TBusinessKnowledgeModel;
import org.kie.dmn.model.v1_1.TContext;
import org.kie.dmn.model.v1_1.TContextEntry;
import org.kie.dmn.model.v1_1.TDMNElement;
import org.kie.dmn.model.v1_1.TDMNElementReference;
import org.kie.dmn.model.v1_1.TDecision;
import org.kie.dmn.model.v1_1.TDecisionRule;
import org.kie.dmn.model.v1_1.TDecisionService;
import org.kie.dmn.model.v1_1.TDecisionTable;
import org.kie.dmn.model.v1_1.TDefinitions;
import org.kie.dmn.model.v1_1.TElementCollection;
import org.kie.dmn.model.v1_1.TExpression;
import org.kie.dmn.model.v1_1.TFunctionDefinition;
import org.kie.dmn.model.v1_1.TImport;
import org.kie.dmn.model.v1_1.TImportedValues;
import org.kie.dmn.model.v1_1.TInformationItem;
import org.kie.dmn.model.v1_1.TInformationRequirement;
import org.kie.dmn.model.v1_1.TInputClause;
import org.kie.dmn.model.v1_1.TInputData;
import org.kie.dmn.model.v1_1.TInvocation;
import org.kie.dmn.model.v1_1.TItemDefinition;
import org.kie.dmn.model.v1_1.TKnowledgeRequirement;
import org.kie.dmn.model.v1_1.TKnowledgeSource;
import org.kie.dmn.model.v1_1.TList;
import org.kie.dmn.model.v1_1.TLiteralExpression;
import org.kie.dmn.model.v1_1.TNamedElement;
import org.kie.dmn.model.v1_1.TOrganizationUnit;
import org.kie.dmn.model.v1_1.TOutputClause;
import org.kie.dmn.model.v1_1.TPerformanceIndicator;
import org.kie.dmn.model.v1_1.TRelation;
import org.kie.dmn.model.v1_1.TTextAnnotation;
import org.kie.dmn.model.v1_1.TUnaryTests;
import org.kie.utll.xml.XStreamUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XStreamMarshaller
extends AbstractXStreamMarshaller {
    private static Logger logger = LoggerFactory.getLogger(XStreamMarshaller.class);
    private static StaxDriver staxDriver = new StaxDriver(){

        public AbstractPullReader createStaxReader(XMLStreamReader in) {
            return new CustomStaxReader(this.getQnameMap(), in);
        }

        public StaxWriter createStaxWriter(XMLStreamWriter out, boolean writeStartEndDocument) throws XMLStreamException {
            return new CustomStaxWriter(this.newQNameMap(), out, writeStartEndDocument, this.isRepairingNamespace(), this.getNameCoder());
        }

        public QNameMap newQNameMap() {
            QNameMap qmap = new QNameMap();
            XStreamMarshaller.configureQNameMap(qmap);
            return qmap;
        }
    };

    public static void configureQNameMap(QNameMap qmap) {
        qmap.setDefaultNamespace("http://www.omg.org/spec/DMN/20151101/dmn.xsd");
    }

    public XStreamMarshaller() {
        super(staxDriver);
    }

    public XStreamMarshaller(List<DMNExtensionRegister> extensionRegisters) {
        super(staxDriver, extensionRegisters);
    }

    @Deprecated
    public void marshalMarshall(Object o) {
        this.marshalMarshall(o, System.out);
    }

    @Deprecated
    public void marshalMarshall(Object o, OutputStream out) {
        try {
            XStream xStream = this.newXStream();
            out.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n".getBytes());
            OutputStreamWriter ows = new OutputStreamWriter(out, "UTF-8");
            xStream.toXML(o, (Writer)ows);
        }
        catch (Exception e) {
            logger.error("Exception", (Throwable)e);
        }
    }

    @Override
    protected boolean isURIDMNEquals(String value) {
        return "http://www.omg.org/spec/DMN/20151101/dmn.xsd".equals(value);
    }

    @Override
    protected XStream newXStream() {
        XStream xStream = XStreamUtils.createNonTrustingXStream((HierarchicalStreamDriver)staxDriver, (ClassLoader)Definitions.class.getClassLoader(), DMNXStream::from);
        xStream.addPermission((TypePermission)new TypeHierarchyPermission(QName.class));
        xStream.addPermission((TypePermission)new TypeHierarchyPermission(KieDMNModelInstrumentedBase.class));
        xStream.alias("artifact", TArtifact.class);
        xStream.alias("definitions", TDefinitions.class);
        xStream.alias("inputData", TInputData.class);
        xStream.alias("decision", TDecision.class);
        xStream.alias("variable", TInformationItem.class);
        xStream.alias("informationRequirement", TInformationRequirement.class);
        xStream.alias("requiredInput", TDMNElementReference.class);
        xStream.alias("literalExpression", TLiteralExpression.class);
        xStream.alias("DMNElement", TDMNElement.class);
        xStream.alias("allowedValues", TUnaryTests.class);
        xStream.alias("artifact", TArtifact.class);
        xStream.alias("association", TAssociation.class);
        xStream.alias("authorityRequirement", TAuthorityRequirement.class);
        xStream.alias("authorityRequirement", TAuthorityRequirement.class);
        xStream.alias("authorityRequirement", TAuthorityRequirement.class);
        xStream.alias("binding", TBinding.class);
        xStream.alias("businessContextElement", TBusinessContextElement.class);
        xStream.alias("businessKnowledgeModel", TBusinessKnowledgeModel.class);
        xStream.alias("column", TInformationItem.class);
        xStream.alias("context", TContext.class);
        xStream.alias("contextEntry", TContextEntry.class);
        xStream.alias("decision", TDecision.class);
        xStream.alias("decisionMade", TDMNElementReference.class);
        xStream.alias("decisionMaker", TDMNElementReference.class);
        xStream.alias("decisionOwned", TDMNElementReference.class);
        xStream.alias("decisionOwner", TDMNElementReference.class);
        xStream.alias("decisionService", TDecisionService.class);
        xStream.alias("decisionTable", TDecisionTable.class);
        xStream.alias("defaultOutputEntry", TLiteralExpression.class);
        xStream.alias("definitions", TDefinitions.class);
        xStream.alias("drgElement", TDMNElementReference.class);
        xStream.alias("elementCollection", TElementCollection.class);
        xStream.alias("elementCollection", TElementCollection.class);
        xStream.alias("encapsulatedDecision", TDMNElementReference.class);
        xStream.alias("encapsulatedLogic", TFunctionDefinition.class);
        xStream.alias("expression", TExpression.class);
        xStream.alias("formalParameter", TInformationItem.class);
        xStream.alias("functionDefinition", TFunctionDefinition.class);
        xStream.alias("impactedPerformanceIndicator", TDMNElementReference.class);
        xStream.alias("impactingDecision", TDMNElementReference.class);
        xStream.alias("import", TImport.class);
        xStream.alias("import", TImport.class);
        xStream.alias("importedElement", String.class);
        xStream.alias("importedValues", TImportedValues.class);
        xStream.alias("informationItem", TInformationItem.class);
        xStream.alias("informationRequirement", TInformationRequirement.class);
        xStream.alias("input", TInputClause.class);
        xStream.alias("inputData", TDMNElementReference.class);
        xStream.alias("inputData", TInputData.class);
        xStream.alias("inputDecision", TDMNElementReference.class);
        xStream.alias("inputEntry", TUnaryTests.class);
        xStream.alias("inputExpression", TLiteralExpression.class);
        xStream.alias("inputValues", TUnaryTests.class);
        xStream.alias("invocation", TInvocation.class);
        xStream.alias("itemComponent", TItemDefinition.class);
        xStream.alias("itemDefinition", TItemDefinition.class);
        xStream.alias("itemDefinition", TItemDefinition.class);
        xStream.alias("knowledgeRequirement", TKnowledgeRequirement.class);
        xStream.alias("knowledgeRequirement", TKnowledgeRequirement.class);
        xStream.alias("knowledgeSource", TKnowledgeSource.class);
        xStream.alias("literalExpression", TLiteralExpression.class);
        xStream.alias("namedElement", TNamedElement.class);
        xStream.alias("organizationUnit", TOrganizationUnit.class);
        xStream.alias("output", TOutputClause.class);
        xStream.alias("outputDecision", TDMNElementReference.class);
        xStream.alias("outputEntry", TLiteralExpression.class);
        xStream.alias("outputValues", TUnaryTests.class);
        xStream.alias("owner", TDMNElementReference.class);
        xStream.alias("parameter", TInformationItem.class);
        xStream.alias("performanceIndicator", TPerformanceIndicator.class);
        xStream.alias("relation", TRelation.class);
        xStream.alias("requiredAuthority", TDMNElementReference.class);
        xStream.alias("requiredDecision", TDMNElementReference.class);
        xStream.alias("requiredDecision", TDMNElementReference.class);
        xStream.alias("requiredInput", TDMNElementReference.class);
        xStream.alias("requiredInput", TDMNElementReference.class);
        xStream.alias("requiredKnowledge", TDMNElementReference.class);
        xStream.alias("rule", TDecisionRule.class);
        xStream.alias("sourceRef", TDMNElementReference.class);
        xStream.alias("supportedObjective", TDMNElementReference.class);
        xStream.alias("targetRef", TDMNElementReference.class);
        xStream.alias("textAnnotation", TTextAnnotation.class);
        xStream.alias("type", String.class);
        xStream.alias("typeRef", QName.class);
        xStream.alias("usingProcess", TDMNElementReference.class);
        xStream.alias("usingTask", TDMNElementReference.class);
        xStream.alias("variable", TInformationItem.class);
        xStream.alias("variable", TInformationItem.class);
        xStream.alias("variable", TInformationItem.class);
        xStream.alias("variable", TInformationItem.class);
        xStream.alias("row", TList.class);
        xStream.alias("list", TList.class);
        xStream.alias("extensionElements", TDMNElement.TExtensionElements.class);
        xStream.alias("text", String.class);
        xStream.alias("text", String.class);
        xStream.alias("text", String.class);
        xStream.alias("question", String.class);
        xStream.alias("allowedAnswers", String.class);
        xStream.alias("description", String.class);
        xStream.registerConverter((Converter)new AssociationConverter(xStream));
        xStream.registerConverter((Converter)new AuthorityRequirementConverter(xStream));
        xStream.registerConverter((Converter)new BindingConverter(xStream));
        xStream.registerConverter((Converter)new BusinessKnowledgeModelConverter(xStream));
        xStream.registerConverter((Converter)new ContextConverter(xStream));
        xStream.registerConverter((Converter)new ContextEntryConverter(xStream));
        xStream.registerConverter((Converter)new DecisionConverter(xStream));
        xStream.registerConverter((Converter)new DecisionRuleConverter(xStream));
        xStream.registerConverter((Converter)new DecisionServiceConverter(xStream));
        xStream.registerConverter((Converter)new DecisionTableConverter(xStream));
        xStream.registerConverter((Converter)new DefinitionsConverter(xStream));
        xStream.registerConverter((Converter)new DMNElementReferenceConverter(xStream));
        xStream.registerConverter((Converter)new FunctionDefinitionConverter(xStream));
        xStream.registerConverter((Converter)new ImportConverter(xStream));
        xStream.registerConverter((Converter)new ImportedValuesConverter(xStream));
        xStream.registerConverter((Converter)new InformationItemConverter(xStream));
        xStream.registerConverter((Converter)new InformationRequirementConverter(xStream));
        xStream.registerConverter((Converter)new InputClauseConverter(xStream));
        xStream.registerConverter((Converter)new InputDataConverter(xStream));
        xStream.registerConverter((Converter)new InvocationConverter(xStream));
        xStream.registerConverter((Converter)new ItemDefinitionConverter(xStream));
        xStream.registerConverter((Converter)new KnowledgeRequirementConverter(xStream));
        xStream.registerConverter((Converter)new KnowledgeSourceConverter(xStream));
        xStream.registerConverter((Converter)new LiteralExpressionConverter(xStream));
        xStream.registerConverter((Converter)new OrganizationUnitConverter(xStream));
        xStream.registerConverter((Converter)new OutputClauseConverter(xStream));
        xStream.registerConverter((Converter)new PerformanceIndicatorConverter(xStream));
        xStream.registerConverter((Converter)new RelationConverter(xStream));
        xStream.registerConverter((Converter)new TextAnnotationConverter(xStream));
        xStream.registerConverter((Converter)new UnaryTestsConverter(xStream));
        xStream.registerConverter((Converter)new QNameConverter());
        xStream.registerConverter((Converter)new DMNListConverter(xStream));
        xStream.registerConverter((Converter)new ElementCollectionConverter(xStream));
        xStream.registerConverter((Converter)new ExtensionElementsConverter(xStream, this.extensionRegisters));
        xStream.ignoreUnknownElements();
        for (DMNExtensionRegister extensionRegister : this.extensionRegisters) {
            extensionRegister.registerExtensionConverters(xStream);
        }
        return xStream;
    }

    static {
        QNameMap qmap = new QNameMap();
        XStreamMarshaller.configureQNameMap(qmap);
        staxDriver.setQnameMap(qmap);
        staxDriver.setRepairingNamespace(false);
    }
}

