/*
 * Decompiled with CFR 0.152.
 */
package org.kie.efesto.runtimemanager.api.utils;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.kie.efesto.common.api.model.EfestoRuntimeContext;
import org.kie.efesto.common.api.utils.CollectionUtils;
import org.kie.efesto.runtimemanager.api.exceptions.KieRuntimeServiceException;
import org.kie.efesto.runtimemanager.api.model.EfestoInput;
import org.kie.efesto.runtimemanager.api.model.EfestoLocalRuntimeContext;
import org.kie.efesto.runtimemanager.api.service.DistributedRuntimeManager;
import org.kie.efesto.runtimemanager.api.service.KieRuntimeService;
import org.kie.efesto.runtimemanager.api.service.LocalRuntimeManager;
import org.kie.efesto.runtimemanager.api.service.RuntimeManager;
import org.kie.efesto.runtimemanager.api.service.RuntimeServiceProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SPIUtils {
    private static final Logger logger = LoggerFactory.getLogger((String)SPIUtils.class.getName());
    private static final ServiceLoader<RuntimeManager> runtimeManagerLoader = ServiceLoader.load(RuntimeManager.class);
    private static final ServiceLoader<LocalRuntimeManager> localRuntimeManagerLoader = ServiceLoader.load(LocalRuntimeManager.class);
    private static final ServiceLoader<DistributedRuntimeManager> distributedRuntimeManagerLoader = ServiceLoader.load(DistributedRuntimeManager.class);
    private static final ServiceLoader<RuntimeServiceProvider> runtimeServiceProvidersLoader = ServiceLoader.load(RuntimeServiceProvider.class);
    private static final ServiceLoader<KieRuntimeService> kieRuntimeServiceLoader = ServiceLoader.load(KieRuntimeService.class);
    private static List<RuntimeServiceProvider> runtimeServiceProviders = SPIUtils.getRuntimeServiceProviders(runtimeServiceProvidersLoader);
    private static List<KieRuntimeService> kieRuntimeServices = SPIUtils.getKieRuntimeServices(kieRuntimeServiceLoader);

    private SPIUtils() {
    }

    public static List<KieRuntimeService> getLocalDiscoveredKieRuntimeServices() {
        return kieRuntimeServices;
    }

    public static Optional<KieRuntimeService> getKieRuntimeService(List<KieRuntimeService> discoveredServices, EfestoInput<?> input, EfestoRuntimeContext context) {
        if (logger.isTraceEnabled()) {
            logger.trace("getKieRuntimeService {} {} {}", new Object[]{discoveredServices, input, context});
        }
        return CollectionUtils.findAtMostOne(discoveredServices, service -> service.canManageInput(input, context), (s1, s2) -> new KieRuntimeServiceException("Found more than one compiler service: " + s1 + " and " + s2));
    }

    public static List<RuntimeServiceProvider> getRuntimeServiceProviders(boolean refresh) {
        if (logger.isTraceEnabled()) {
            logger.trace("getRuntimeServiceProviders {}", (Object)refresh);
        }
        if (!refresh) {
            return runtimeServiceProviders;
        }
        runtimeServiceProviders = SPIUtils.getRuntimeServiceProviders(SPIUtils.getProviders(refresh));
        return runtimeServiceProviders;
    }

    public static List<KieRuntimeService> getKieRuntimeServices(boolean refresh) {
        if (logger.isTraceEnabled()) {
            logger.trace("getKieRuntimeServices {}", (Object)refresh);
        }
        if (!refresh) {
            return kieRuntimeServices;
        }
        kieRuntimeServices = SPIUtils.getKieRuntimeServices(SPIUtils.getServices(refresh));
        return kieRuntimeServices;
    }

    public static Optional<RuntimeManager> getRuntimeManager(boolean refresh) {
        logger.debug("getRuntimeManager {}", (Object)refresh);
        Iterable<RuntimeManager> managers = SPIUtils.getManagers(refresh);
        return managers.iterator().hasNext() ? Optional.of(managers.iterator().next()) : Optional.empty();
    }

    public static Optional<LocalRuntimeManager> getLocalRuntimeManager(boolean refresh) {
        logger.debug("getLocalRuntimeManager {}", (Object)refresh);
        Iterable<LocalRuntimeManager> managers = SPIUtils.getLocalManagers(refresh);
        return managers.iterator().hasNext() ? Optional.of(managers.iterator().next()) : Optional.empty();
    }

    public static List<DistributedRuntimeManager> getDistributedRuntimeManagers(boolean refresh) {
        logger.debug("getDistributedRuntimeManagers {}", (Object)refresh);
        Iterable<DistributedRuntimeManager> managers = SPIUtils.getDistributedManagers(refresh);
        return StreamSupport.stream(managers.spliterator(), false).collect(Collectors.toList());
    }

    private static List<RuntimeServiceProvider> getRuntimeServiceProviders(Iterable<RuntimeServiceProvider> serviceIterable) {
        ArrayList<RuntimeServiceProvider> toReturn = new ArrayList<RuntimeServiceProvider>();
        serviceIterable.forEach(toReturn::add);
        if (logger.isTraceEnabled()) {
            logger.trace("toReturn {} {}", toReturn, (Object)toReturn.size());
            toReturn.forEach(provider -> logger.trace("{}", provider));
        }
        return toReturn;
    }

    private static List<KieRuntimeService> getKieRuntimeServices(Iterable<KieRuntimeService> serviceIterable) {
        ArrayList<KieRuntimeService> toReturn = new ArrayList<KieRuntimeService>();
        serviceIterable.forEach(toReturn::add);
        if (logger.isTraceEnabled()) {
            logger.trace("toReturn {} {}", toReturn, (Object)toReturn.size());
            toReturn.forEach(provider -> logger.trace("{}", provider));
        }
        return toReturn;
    }

    private static Iterable<KieRuntimeService> getServices(boolean refresh) {
        if (refresh) {
            kieRuntimeServiceLoader.reload();
        }
        return kieRuntimeServiceLoader;
    }

    private static Iterable<RuntimeManager> getManagers(boolean refresh) {
        if (refresh) {
            runtimeManagerLoader.reload();
        }
        return runtimeManagerLoader;
    }

    private static Iterable<LocalRuntimeManager> getLocalManagers(boolean refresh) {
        if (refresh) {
            localRuntimeManagerLoader.reload();
        }
        return localRuntimeManagerLoader;
    }

    private static Iterable<DistributedRuntimeManager> getDistributedManagers(boolean refresh) {
        if (refresh) {
            distributedRuntimeManagerLoader.reload();
        }
        return distributedRuntimeManagerLoader;
    }

    private static Iterable<RuntimeServiceProvider> getProviders(boolean refresh) {
        if (refresh) {
            runtimeServiceProvidersLoader.reload();
        }
        return runtimeServiceProvidersLoader;
    }

    public static Set<String> collectModelTypes(EfestoLocalRuntimeContext context) {
        List<KieRuntimeService> kieRuntimeServices = SPIUtils.getKieRuntimeServices(false);
        HashSet<String> modelTypes = new HashSet<String>();
        for (KieRuntimeService kieRuntimeService : kieRuntimeServices) {
            modelTypes.add(kieRuntimeService.getModelType());
        }
        ServiceLoader<KieRuntimeService> serviceLoader = context.getKieRuntimeService();
        for (KieRuntimeService kieRuntimeService : serviceLoader) {
            modelTypes.add(kieRuntimeService.getModelType());
        }
        return modelTypes;
    }
}

