/*
 * Decompiled with CFR 0.152.
 */
package org.kie.efesto.common.api.identifiers;

import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.StringTokenizer;

public abstract class LocalUri {
    public static final String SCHEME = "efesto-local";
    public static final LocalUri Root = new LocalUriRoot();
    public static final String SLASH = "/";

    public static LocalUri parse(String path) {
        if (path.startsWith(SCHEME)) {
            URI parsed = URI.create(path);
            path = parsed.getPath();
        }
        if (!path.startsWith(SLASH)) {
            throw new IllegalArgumentException("Path must start at root /");
        }
        StringTokenizer tok = new StringTokenizer(path, SLASH);
        LocalUri hpath = Root;
        while (tok.hasMoreTokens()) {
            hpath = hpath.append(tok.nextToken());
        }
        return hpath;
    }

    private LocalUri() {
    }

    public abstract String path();

    public abstract LocalUri parent();

    public abstract boolean startsWith(String var1);

    public LocalUri append(String component) {
        return new LocalUriPathComponent(this, component);
    }

    public URI toUri() {
        try {
            return new URI(SCHEME, "", this.path(), null);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public String toString() {
        return this.toUri().toString();
    }

    public static class LocalUriPathComponent
    extends LocalUri {
        private final LocalUri parent;
        final String component;

        private LocalUriPathComponent(LocalUri parent, String component) {
            this.parent = parent;
            this.component = URLEncoder.encode(component, StandardCharsets.UTF_8);
        }

        @Override
        public LocalUri parent() {
            return this.parent;
        }

        public String getComponent() {
            return this.component;
        }

        @Override
        public boolean startsWith(String component) {
            return this.parent() == Root && this.component.equals(component) || this.parent().startsWith(component);
        }

        @Override
        public String path() {
            return this.parent == Root ? LocalUri.SLASH + this.component : this.parent.path() + LocalUri.SLASH + this.component;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            LocalUriPathComponent that = (LocalUriPathComponent)o;
            return Objects.equals(this.parent, that.parent) && Objects.equals(this.component, that.component);
        }

        public int hashCode() {
            return Objects.hash(this.parent, this.component);
        }
    }

    public static class LocalUriRoot
    extends LocalUri {
        private LocalUriRoot() {
        }

        @Override
        public LocalUri parent() {
            return null;
        }

        @Override
        public boolean startsWith(String component) {
            return false;
        }

        @Override
        public String path() {
            return LocalUri.SLASH;
        }
    }
}

