/*
 * Decompiled with CFR 0.152.
 */
package org.drools.util;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoveCommentsMain {
    private static final Logger LOGGER = LoggerFactory.getLogger(RemoveCommentsMain.class);

    public static void main(String ... args) {
        String ignoreMissingFilesArgument = args[0];
        boolean ignoreMissingFiles = Boolean.parseBoolean(ignoreMissingFilesArgument);
        for (int i = 0; i < args.length; ++i) {
            if ((ignoreMissingFiles || "false".equalsIgnoreCase(ignoreMissingFilesArgument)) && i == 0) continue;
            try {
                String fileName = args[i];
                String result = RemoveCommentsMain.removeComments(fileName, ignoreMissingFiles);
                if (result == null) continue;
                Files.write(Path.of(fileName, new String[0]), result.getBytes(), new OpenOption[0]);
                continue;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    static String removeComments(String fileName, boolean ignoreMissingFiles) {
        String string;
        block9: {
            Stream<String> lines = Files.lines(Path.of(fileName, new String[0]));
            try {
                string = lines.filter(line -> !line.startsWith("#")).collect(Collectors.joining("\n"));
                if (lines == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (lines != null) {
                        try {
                            lines.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    if (ignoreMissingFiles && e instanceof NoSuchFileException) {
                        LOGGER.info("Ignoring file that doesn't exist: " + fileName);
                        return null;
                    }
                    throw new RuntimeException(e);
                }
            }
            lines.close();
        }
        return string;
    }
}

