/*
 * Decompiled with CFR 0.152.
 */
package org.drools.scenariosimulation.backend.util;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.drools.scenariosimulation.backend.util.ImpossibleToFindDMNException;
import org.kie.dmn.api.core.DMNModel;
import org.kie.dmn.efesto.compiler.model.DmnCompilationContext;
import org.kie.efesto.common.api.identifiers.LocalUri;
import org.kie.efesto.common.api.identifiers.ModelLocalUriId;
import org.kie.efesto.common.api.model.EfestoCompilationContext;
import org.kie.efesto.common.api.model.GeneratedResources;
import org.kie.efesto.compilationmanager.api.model.EfestoFileSetResource;
import org.kie.efesto.compilationmanager.api.model.EfestoResource;
import org.kie.efesto.compilationmanager.api.service.CompilationManager;
import org.kie.efesto.compilationmanager.api.utils.SPIUtils;
import org.kie.efesto.runtimemanager.api.model.BaseEfestoInput;
import org.kie.efesto.runtimemanager.api.model.EfestoInput;
import org.kie.efesto.runtimemanager.api.model.EfestoLocalRuntimeContext;
import org.kie.efesto.runtimemanager.api.model.EfestoOutput;
import org.kie.efesto.runtimemanager.api.service.RuntimeManager;
import org.kie.efesto.runtimemanager.core.model.EfestoRuntimeContextUtils;
import org.kie.memorycompiler.KieMemoryCompiler;

public class DMNSimulationUtils {
    private static final String SLASH = "/";
    private static final KieMemoryCompiler.MemoryCompilerClassLoader memoryCompilerClassLoader = new KieMemoryCompiler.MemoryCompilerClassLoader(Thread.currentThread().getContextClassLoader());
    private static final CompilationManager compilationManager = (CompilationManager)SPIUtils.getCompilationManager((boolean)true).orElseThrow(() -> new RuntimeException("Compilation Manager not available"));
    private static final RuntimeManager runtimeManager = (RuntimeManager)org.kie.efesto.runtimemanager.api.utils.SPIUtils.getRuntimeManager((boolean)true).orElseThrow(() -> new RuntimeException("Runtime Manager not available"));

    private DMNSimulationUtils() {
    }

    public static Map<String, GeneratedResources> compileModels(Collection<File> dmnFiles) {
        ModelLocalUriId dmnModelLocalUriId = new ModelLocalUriId(LocalUri.Root.append("dmn").append("scesim"));
        EfestoFileSetResource toProcessDmn = new EfestoFileSetResource(new HashSet<File>(dmnFiles), dmnModelLocalUriId);
        DmnCompilationContext dmnCompilationContext = DmnCompilationContext.buildWithParentClassLoader((ClassLoader)memoryCompilerClassLoader);
        compilationManager.processResource((EfestoCompilationContext)dmnCompilationContext, new EfestoResource[]{toProcessDmn});
        return dmnCompilationContext.getGeneratedResourcesMap();
    }

    public static EfestoOutput getEfestoOutput(Map<String, GeneratedResources> generatedResourcesMap, ModelLocalUriId modelLocalUriId, Map<String, Object> inputData) {
        EfestoLocalRuntimeContext runtimeContext = EfestoRuntimeContextUtils.buildWithParentClassLoader((ClassLoader)memoryCompilerClassLoader, generatedResourcesMap);
        BaseEfestoInput inputDMN = new BaseEfestoInput(modelLocalUriId, inputData);
        Collection efestoOutputs = runtimeManager.evaluateInput(runtimeContext, new EfestoInput[]{inputDMN});
        return (EfestoOutput)efestoOutputs.iterator().next();
    }

    public static DMNModel findDMNModel(List<DMNModel> dmnModels, List<String> pathToFind, int step) {
        ArrayList<DMNModel> result = new ArrayList<DMNModel>();
        String pathToCompare = String.join((CharSequence)SLASH, pathToFind.subList(0, step));
        for (DMNModel dmnModel : dmnModels) {
            String modelPath = new StringBuilder(dmnModel.getResource().getSourcePath()).reverse().toString();
            if (!modelPath.startsWith(pathToCompare)) continue;
            result.add(dmnModel);
        }
        if (result.isEmpty()) {
            throw new ImpossibleToFindDMNException("Retrieving the DMNModel has failed. Make sure the used DMN asset does not produce any compilation errors and that the project does not contain multiple DMN assets with the same name and namespace. In addition, check if the reference to the DMN file is correct in the Settings panel. After addressing the issues, build the project again.");
        }
        if (result.size() == 1) {
            return (DMNModel)result.get(0);
        }
        return DMNSimulationUtils.findDMNModel(dmnModels, pathToFind, step + 1);
    }
}

