/*
 * Decompiled with CFR 0.152.
 */
package org.drools.scenariosimulation.backend.runner;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.List;
import java.util.Scanner;
import java.util.stream.Stream;
import org.drools.scenariosimulation.api.model.Scenario;
import org.drools.scenariosimulation.api.model.ScenarioSimulationModel;
import org.drools.scenariosimulation.api.model.ScenarioWithIndex;
import org.drools.scenariosimulation.backend.expression.ExpressionEvaluatorFactory;
import org.drools.scenariosimulation.backend.runner.AbstractRunnerHelper;
import org.drools.scenariosimulation.backend.runner.DMNScenarioRunnerHelper;
import org.drools.scenariosimulation.backend.runner.IndexedScenarioAssertionError;
import org.drools.scenariosimulation.backend.runner.IndexedScenarioException;
import org.drools.scenariosimulation.backend.runner.RuleScenarioRunnerHelper;
import org.drools.scenariosimulation.backend.runner.ScenarioException;
import org.drools.scenariosimulation.backend.runner.TestScenarioActivator;
import org.drools.scenariosimulation.backend.runner.TestScenarioTestDescriptor;
import org.drools.scenariosimulation.backend.runner.TestScenarioTestSuiteDescriptor;
import org.drools.scenariosimulation.backend.runner.model.ScenarioRunnerDTO;
import org.drools.scenariosimulation.backend.runner.model.ScenarioRunnerData;
import org.drools.scenariosimulation.backend.util.ScenarioSimulationXMLPersistence;
import org.junit.platform.commons.support.AnnotationSupport;
import org.junit.platform.engine.EngineDiscoveryRequest;
import org.junit.platform.engine.EngineExecutionListener;
import org.junit.platform.engine.ExecutionRequest;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.TestEngine;
import org.junit.platform.engine.TestExecutionResult;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.engine.discovery.ClassSelector;
import org.junit.platform.engine.support.descriptor.EngineDescriptor;
import org.kie.api.KieServices;
import org.kie.api.runtime.KieContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestScenarioEngine
implements TestEngine {
    private static final Logger LOGGER = LoggerFactory.getLogger(TestScenarioEngine.class);
    private static final String TEST_ENGINE_ID = "kie-test-scenario";
    private static final String TEST_ENGINE_DESCRIPTION = "Apache KIE Test Scenario engine";
    private static final ScenarioSimulationXMLPersistence XML_READER = ScenarioSimulationXMLPersistence.getInstance();

    public String getId() {
        return TEST_ENGINE_ID;
    }

    public TestDescriptor discover(EngineDiscoveryRequest discoveryRequest, UniqueId uniqueId) {
        LOGGER.debug("Discovering scesim files for {}", (Object)TEST_ENGINE_DESCRIPTION);
        EngineDescriptor engineDescriptor = new EngineDescriptor(uniqueId, TEST_ENGINE_DESCRIPTION);
        discoveryRequest.getSelectorsByType(ClassSelector.class).forEach(selector -> TestScenarioEngine.appendTestSuites(selector.getJavaClass(), (TestDescriptor)engineDescriptor));
        LOGGER.debug("Discovered {} scesim files", (Object)engineDescriptor.getChildren().size());
        return engineDescriptor;
    }

    public void execute(ExecutionRequest executionRequest) {
        LOGGER.debug("Executing {} Test Scenarios", (Object)executionRequest.getRootTestDescriptor().getChildren().size());
        EngineExecutionListener listener = executionRequest.getEngineExecutionListener();
        executionRequest.getRootTestDescriptor().getChildren().stream().map(TestScenarioTestSuiteDescriptor.class::cast).forEach(testSuiteDescriptor -> {
            LOGGER.debug("Executing {} Test Scenario which contains {} scenarios", (Object)testSuiteDescriptor.getDisplayName(), (Object)testSuiteDescriptor.getChildren().size());
            ScenarioRunnerDTO scenarioRunnerDTO = testSuiteDescriptor.getScenarioRunnerDTO();
            if (scenarioRunnerDTO.getSettings().isSkipFromBuild()) {
                LOGGER.debug("Skipping {} scenario", (Object)testSuiteDescriptor.getDisplayName());
                listener.executionSkipped((TestDescriptor)testSuiteDescriptor, testSuiteDescriptor.getDisplayName() + " skipped from the build");
                return;
            }
            listener.executionStarted((TestDescriptor)testSuiteDescriptor);
            AbstractRunnerHelper runnerHelper = TestScenarioEngine.getRunnerHelper(testSuiteDescriptor.getTestScenarioType());
            testSuiteDescriptor.getChildren().stream().map(TestScenarioTestDescriptor.class::cast).forEach(testDescriptor -> {
                LOGGER.debug("Executing {} scenario", (Object)testSuiteDescriptor.getDisplayName());
                listener.executionStarted((TestDescriptor)testDescriptor);
                KieContainer kieContainer = KieServices.get().getKieClasspathContainer();
                ExpressionEvaluatorFactory expressionEvaluatorFactory = ExpressionEvaluatorFactory.create(kieContainer.getClassLoader(), scenarioRunnerDTO.getSettings().getType());
                try {
                    runnerHelper.run(kieContainer, scenarioRunnerDTO.getSimulationModelDescriptor(), testDescriptor.getScenarioWithIndex(), expressionEvaluatorFactory, kieContainer.getClassLoader(), new ScenarioRunnerData(), scenarioRunnerDTO.getSettings(), scenarioRunnerDTO.getBackground());
                    LOGGER.debug("{} scenario successful", (Object)testSuiteDescriptor.getDisplayName());
                    listener.executionFinished((TestDescriptor)testDescriptor, TestExecutionResult.successful());
                }
                catch (Exception e) {
                    LOGGER.debug("{} scenario failed", (Object)testSuiteDescriptor.getDisplayName());
                    listener.executionFinished((TestDescriptor)testDescriptor, TestExecutionResult.failed((Throwable)TestScenarioEngine.defineFailureException(e, testDescriptor.getScenarioWithIndex().getIndex(), ((Scenario)testDescriptor.getScenarioWithIndex().getScesimData()).getDescription(), testSuiteDescriptor.getDisplayName())));
                }
            });
            LOGGER.debug("{} Test Scenario suite executed", (Object)testSuiteDescriptor.getDisplayName());
            listener.executionFinished((TestDescriptor)testSuiteDescriptor, TestExecutionResult.successful());
        });
    }

    static void appendTestSuites(Class<?> javaClass, TestDescriptor engineDescriptor) {
        if (AnnotationSupport.isAnnotated(javaClass, TestScenarioActivator.class)) {
            LOGGER.debug("A class with @TestScenarioActivator annotation found: {}", (Object)javaClass.getCanonicalName());
            TestScenarioEngine.getScesimFileAbsolutePaths().stream().map(TestScenarioEngine::parseFile).forEach(scenarioRunnerDTO -> {
                String fileName = TestScenarioEngine.getScesimFileName(scenarioRunnerDTO.getFileName());
                TestScenarioTestSuiteDescriptor suite = new TestScenarioTestSuiteDescriptor(engineDescriptor, javaClass, fileName, (ScenarioRunnerDTO)scenarioRunnerDTO);
                engineDescriptor.addChild((TestDescriptor)suite);
                scenarioRunnerDTO.getScenarioWithIndices().forEach(scenarioWithIndex -> suite.addChild((TestDescriptor)new TestScenarioTestDescriptor((TestDescriptor)suite, javaClass, fileName, (ScenarioWithIndex)scenarioWithIndex)));
            });
        }
    }

    static List<String> getScesimFileAbsolutePaths() {
        List<String> list;
        block8: {
            Stream<Path> fileStream = Files.walk(Paths.get(".", new String[0]), new FileVisitOption[0]);
            try {
                LOGGER.debug("Scanning Test Scenario (*.scesim) files");
                List<String> scesimFileAbsolutePaths = fileStream.filter(TestScenarioEngine::filterResource).map(Path::normalize).map(Path::toFile).map(File::getAbsolutePath).toList();
                LOGGER.debug("Found Test Scenario (*.scesim) {} files", (Object)scesimFileAbsolutePaths.size());
                scesimFileAbsolutePaths.forEach(arg_0 -> ((Logger)LOGGER).debug(arg_0));
                list = scesimFileAbsolutePaths;
                if (fileStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (fileStream != null) {
                        try {
                            fileStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    LOGGER.error("Error scanning Test Scenario (*.scesim)", (Throwable)e);
                    return Collections.emptyList();
                }
            }
            fileStream.close();
        }
        return list;
    }

    static String getScesimFileName(String fileFullPath) {
        int idx = fileFullPath.replace("\\", "/").lastIndexOf(47);
        String fileName = idx >= 0 ? fileFullPath.substring(idx + 1) : fileFullPath;
        return fileName.endsWith(".scesim") ? fileName.substring(0, fileName.lastIndexOf(".scesim")) : fileName;
    }

    static boolean filterResource(Path path) {
        return path.toString().endsWith(".scesim") && !path.toAbsolutePath().toString().replace("\\", "/").contains("/target/") && Files.isRegularFile(path, new LinkOption[0]);
    }

    static ScenarioRunnerDTO parseFile(String path) {
        Scanner scanner = new Scanner(new File(path));
        try {
            String rawFile = scanner.useDelimiter("\\Z").next();
            ScenarioSimulationModel scenarioSimulationModel = XML_READER.unmarshal(rawFile);
            ScenarioRunnerDTO scenarioRunnerDTO = new ScenarioRunnerDTO(scenarioSimulationModel, path);
            scanner.close();
            return scenarioRunnerDTO;
        }
        catch (Throwable throwable) {
            try {
                try {
                    scanner.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (FileNotFoundException e) {
                throw new ScenarioException("File not found, this should not happen: " + path, e);
            }
            catch (Exception e) {
                throw new ScenarioException("Issue on parsing file: " + path, e);
            }
        }
    }

    static AbstractRunnerHelper getRunnerHelper(ScenarioSimulationModel.Type type) {
        if (ScenarioSimulationModel.Type.RULE.equals((Object)type)) {
            return new RuleScenarioRunnerHelper();
        }
        if (ScenarioSimulationModel.Type.DMN.equals((Object)type)) {
            return new DMNScenarioRunnerHelper();
        }
        throw new IllegalArgumentException("Impossible to run simulation of type " + type);
    }

    static Throwable defineFailureException(Exception e, int index, String scenarioName, String fileName) {
        ScenarioException scenarioException;
        if (e instanceof ScenarioException && (scenarioException = (ScenarioException)e).isFailedAssertion()) {
            return new IndexedScenarioAssertionError(index, scenarioName, fileName, e);
        }
        return new IndexedScenarioException(index, scenarioName, fileName, e);
    }
}

