/*
 * Decompiled with CFR 0.152.
 */
package org.drools.modelcompiler.constraints;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.drools.base.base.ValueResolver;
import org.drools.base.reteoo.AccumulateContextEntry;
import org.drools.base.reteoo.BaseTuple;
import org.drools.base.rule.Accumulate;
import org.drools.base.rule.Declaration;
import org.drools.base.rule.accessor.Accumulator;
import org.drools.core.common.ReteEvaluator;
import org.drools.core.reteoo.AccumulateNode;
import org.drools.core.reteoo.Tuple;
import org.drools.core.reteoo.TupleImpl;
import org.drools.core.util.index.TupleListWithContext;
import org.drools.model.functions.Function1;
import org.drools.model.functions.FunctionN;
import org.kie.api.runtime.rule.FactHandle;

public class LambdaGroupByAccumulate
extends Accumulate {
    private Accumulate innerAccumulate;
    private Declaration[] groupingDeclarations;
    private FunctionN groupingFunction;
    private Function1 groupingFunction1;

    public LambdaGroupByAccumulate() {
    }

    public LambdaGroupByAccumulate(Accumulate innerAccumulate, Declaration[] groupingDeclarations, FunctionN groupingFunction) {
        super(innerAccumulate.getSource(), innerAccumulate.getRequiredDeclarations());
        this.innerAccumulate = innerAccumulate;
        this.groupingDeclarations = groupingDeclarations;
        this.groupingFunction = groupingFunction;
        this.groupingFunction1 = groupingDeclarations.length == 1 ? groupingFunction.asFunction1() : null;
    }

    private Object getKey(Tuple tuple, FactHandle handle, ReteEvaluator reteEvaluator) {
        if (this.groupingFunction1 != null) {
            return this.groupingFunction1.apply(this.getValue(tuple, handle, reteEvaluator, this.groupingDeclarations[0]));
        }
        Object[] args = new Object[this.groupingDeclarations.length];
        for (int i = 0; i < this.groupingDeclarations.length; ++i) {
            args[i] = this.getValue(tuple, handle, reteEvaluator, this.groupingDeclarations[i]);
        }
        return this.groupingFunction.apply(args);
    }

    private Object getValue(Tuple tuple, FactHandle handle, ReteEvaluator reteEvaluator, Declaration declaration) {
        return declaration.getValue((ValueResolver)reteEvaluator, declaration.getTupleIndex() < tuple.size() ? tuple.get(declaration).getObject() : handle.getObject());
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.innerAccumulate = (Accumulate)in.readObject();
        this.groupingDeclarations = (Declaration[])in.readObject();
        this.groupingFunction = (FunctionN)in.readObject();
        this.groupingFunction1 = this.groupingDeclarations.length == 1 ? this.groupingFunction.asFunction1() : null;
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeObject(this.innerAccumulate);
        out.writeObject(this.groupingDeclarations);
        out.writeObject(this.groupingFunction);
    }

    public Accumulator[] getAccumulators() {
        return this.innerAccumulate.getAccumulators();
    }

    public Object createFunctionContext() {
        return this.innerAccumulate.createFunctionContext();
    }

    public Object init(Object workingMemoryContext, Object accContext, Object funcContext, BaseTuple leftTuple, ValueResolver valueResolver) {
        return funcContext;
    }

    public Object accumulate(Object workingMemoryContext, Object context, BaseTuple match, FactHandle handle, ValueResolver valueResolver) {
        AccumulateNode.GroupByContext groupByContext = (AccumulateNode.GroupByContext)context;
        TupleImpl leftTupleMatch = (TupleImpl)match;
        TupleListWithContext tupleList = groupByContext.getGroup(workingMemoryContext, this.innerAccumulate, (BaseTuple)leftTupleMatch, this.getKey((Tuple)leftTupleMatch, handle, (ReteEvaluator)valueResolver), (ValueResolver)((ReteEvaluator)valueResolver));
        return this.accumulate(workingMemoryContext, match, handle, groupByContext, tupleList, valueResolver);
    }

    public Object accumulate(Object workingMemoryContext, BaseTuple match, FactHandle handle, Object groupByContext, Object tupleList, ValueResolver valueResolver) {
        TupleListWithContext list = (TupleListWithContext)tupleList;
        ((AccumulateNode.GroupByContext)groupByContext).moveToPropagateTupleList(list);
        return this.innerAccumulate.accumulate(workingMemoryContext, list.getContext(), match, handle, valueResolver);
    }

    public boolean tryReverse(Object workingMemoryContext, Object context, BaseTuple leftTuple, FactHandle handle, BaseTuple match, ValueResolver valueResolver) {
        TupleImpl tupleMatch = (TupleImpl)match;
        TupleListWithContext memory = (TupleListWithContext)tupleMatch.getMemory();
        AccumulateContextEntry entry = (AccumulateContextEntry)memory.getContext();
        boolean reversed = this.innerAccumulate.tryReverse(workingMemoryContext, (Object)entry, leftTuple, handle, match, valueResolver);
        if (reversed) {
            AccumulateNode.GroupByContext groupByContext = (AccumulateNode.GroupByContext)context;
            groupByContext.moveToPropagateTupleList(memory);
            memory.remove(tupleMatch);
            if (memory.isEmpty()) {
                groupByContext.removeGroup(entry.getKey());
                ((AccumulateContextEntry)memory.getContext()).setEmpty(true);
            }
        }
        return reversed;
    }

    public Object getResult(Object workingMemoryContext, Object context, BaseTuple leftTuple, ValueResolver valueResolver) {
        AccumulateContextEntry entry = (AccumulateContextEntry)context;
        return entry.isEmpty() ? null : this.innerAccumulate.getResult(workingMemoryContext, context, leftTuple, valueResolver);
    }

    public boolean supportsReverse() {
        return this.innerAccumulate.supportsReverse();
    }

    public Accumulate clone() {
        return new LambdaGroupByAccumulate(this.innerAccumulate.clone(), this.groupingDeclarations, this.groupingFunction);
    }

    public Object createWorkingMemoryContext() {
        return this.innerAccumulate.createWorkingMemoryContext();
    }

    public boolean isMultiFunction() {
        return this.innerAccumulate.isMultiFunction();
    }

    public void replaceAccumulatorDeclaration(Declaration declaration, Declaration resolved) {
        this.innerAccumulate.replaceAccumulatorDeclaration(declaration, resolved);
    }

    public boolean isGroupBy() {
        return true;
    }
}

