/*
 * Decompiled with CFR 0.152.
 */
package org.drools.modelcompiler.constraints;

import java.io.Serializable;
import org.drools.base.base.ValueResolver;
import org.drools.base.reteoo.BaseTuple;
import org.drools.base.rule.ContextEntry;
import org.drools.base.rule.Declaration;
import org.drools.base.rule.IndexableConstraint;
import org.drools.base.rule.MutableTypeConstraint;
import org.drools.base.rule.accessor.FieldValue;
import org.drools.base.rule.accessor.ReadAccessor;
import org.drools.base.rule.accessor.RightTupleValueExtractor;
import org.drools.base.rule.accessor.TupleValueExtractor;
import org.drools.base.util.IndexedValueReader;
import org.drools.base.util.index.ConstraintTypeOperator;
import org.drools.core.base.DroolsQueryImpl;
import org.drools.model.Index;
import org.drools.model.functions.Function1;
import org.drools.modelcompiler.constraints.ConstraintEvaluator;
import org.drools.modelcompiler.constraints.LambdaConstraint;
import org.drools.modelcompiler.constraints.LambdaReadAccessor;
import org.kie.api.KieBaseConfiguration;
import org.kie.api.runtime.rule.FactHandle;

public class UnificationConstraint
extends MutableTypeConstraint<ContextEntry>
implements IndexableConstraint {
    private Declaration leftIndexingDeclaration;
    private final ReadAccessor readAccessor;
    private final ConstraintEvaluator evaluator;
    private boolean unification = true;

    public UnificationConstraint(Declaration leftIndexingDeclaration) {
        this(leftIndexingDeclaration, null);
    }

    public UnificationConstraint(Declaration leftIndexingDeclaration, ConstraintEvaluator evaluator) {
        this.leftIndexingDeclaration = leftIndexingDeclaration;
        this.evaluator = evaluator;
        if (evaluator != null) {
            Index index = evaluator.getIndex();
            this.readAccessor = new LambdaReadAccessor(index.getIndexId(), index.getIndexedClass(), index.getLeftOperandExtractor());
        } else {
            this.readAccessor = new LambdaReadAccessor(leftIndexingDeclaration.getDeclarationClass(), (Function1 & Serializable)x -> x);
        }
    }

    public boolean isUnification() {
        return this.unification;
    }

    public void unsetUnification() {
        this.unification = false;
    }

    public boolean isIndexable(int nodeType, KieBaseConfiguration config) {
        return true;
    }

    public ConstraintTypeOperator getConstraintType() {
        return ConstraintTypeOperator.EQUAL;
    }

    public FieldValue getField() {
        throw new UnsupportedOperationException();
    }

    public IndexedValueReader getFieldIndex() {
        return new IndexedValueReader((TupleValueExtractor)this.leftIndexingDeclaration, this.getRightIndexExtractor());
    }

    public ReadAccessor getFieldExtractor() {
        return this.readAccessor;
    }

    public TupleValueExtractor getRightIndexExtractor() {
        return new RightTupleValueExtractor(this.readAccessor);
    }

    public Declaration getLeftIndexExtractor() {
        return this.leftIndexingDeclaration;
    }

    public Declaration[] getRequiredDeclarations() {
        return new Declaration[]{this.leftIndexingDeclaration};
    }

    public void replaceDeclaration(Declaration oldDecl, Declaration newDecl) {
        if (this.leftIndexingDeclaration == oldDecl) {
            this.leftIndexingDeclaration = newDecl;
        }
        if (this.evaluator != null) {
            this.evaluator.replaceDeclaration(oldDecl, newDecl);
        }
    }

    public MutableTypeConstraint clone() {
        return new UnificationConstraint(this.leftIndexingDeclaration, this.evaluator);
    }

    public boolean isTemporal() {
        return false;
    }

    public boolean isAllowed(FactHandle handle, ValueResolver valueResolver) {
        throw new UnsupportedOperationException();
    }

    public boolean isAllowedCachedLeft(ContextEntry context, FactHandle handle) {
        return this.evaluateUnification(handle, ((LambdaConstraint.LambdaContextEntry)context).getTuple(), ((LambdaConstraint.LambdaContextEntry)context).getReteEvaluator());
    }

    public boolean isAllowedCachedRight(BaseTuple tuple, ContextEntry context) {
        return this.evaluateUnification(((LambdaConstraint.LambdaContextEntry)context).getHandle(), tuple, ((LambdaConstraint.LambdaContextEntry)context).getReteEvaluator());
    }

    private boolean evaluateUnification(FactHandle handle, BaseTuple tuple, ValueResolver reteEvaluator) {
        if (!this.unification) {
            return this.evaluator.evaluate(handle, tuple, reteEvaluator);
        }
        DroolsQueryImpl query = (DroolsQueryImpl)tuple.getObject(0);
        if (query.getVariables()[this.leftIndexingDeclaration.getExtractor().getIndex()] != null) {
            return true;
        }
        if (this.evaluator != null) {
            return this.evaluator.evaluate(handle, tuple, reteEvaluator);
        }
        Object argument = this.leftIndexingDeclaration.getValue(null, (Object)query);
        return handle.getObject().equals(argument);
    }

    public ContextEntry createContext() {
        return new LambdaConstraint.LambdaContextEntry();
    }
}

