/*
 * Decompiled with CFR 0.152.
 */
package org.drools.modelcompiler.consequence;

import java.util.IdentityHashMap;
import java.util.Map;
import org.kie.api.runtime.rule.FactHandle;

public interface FactHandleLookup {
    public void put(Object var1, FactHandle var2);

    public FactHandle get(Object var1);

    public void clear();

    public static FactHandleLookup create(int arity) {
        switch (arity) {
            case 0: {
                return new Empty();
            }
            case 1: {
                return new Single();
            }
            case 2: {
                return new Double();
            }
        }
        return new Multi();
    }

    public static class Empty
    implements FactHandleLookup {
        @Override
        public void put(Object obj, FactHandle fh) {
            throw new UnsupportedOperationException();
        }

        @Override
        public FactHandle get(Object obj) {
            return null;
        }

        @Override
        public void clear() {
        }
    }

    public static class Single
    implements FactHandleLookup {
        private Object obj;
        private FactHandle fh;

        @Override
        public void put(Object obj, FactHandle fh) {
            this.obj = obj;
            this.fh = fh;
        }

        @Override
        public FactHandle get(Object obj) {
            return this.obj == obj ? this.fh : null;
        }

        @Override
        public void clear() {
            this.obj = null;
            this.fh = null;
        }
    }

    public static class Double
    implements FactHandleLookup {
        private Object obj1;
        private Object obj2;
        private FactHandle fh1;
        private FactHandle fh2;

        @Override
        public void put(Object obj, FactHandle fh) {
            if (this.obj1 == null) {
                this.obj1 = obj;
                this.fh1 = fh;
            } else {
                this.obj2 = obj;
                this.fh2 = fh;
            }
        }

        @Override
        public FactHandle get(Object obj) {
            return this.obj1 == obj ? this.fh1 : (this.obj2 == obj ? this.fh2 : null);
        }

        @Override
        public void clear() {
            this.obj1 = null;
            this.obj2 = null;
            this.fh1 = null;
            this.fh2 = null;
        }
    }

    public static class Multi
    implements FactHandleLookup {
        private final Map<Object, FactHandle> map = new IdentityHashMap<Object, FactHandle>();

        @Override
        public void put(Object obj, FactHandle fh) {
            this.map.put(obj, fh);
        }

        @Override
        public FactHandle get(Object obj) {
            return this.map.get(obj);
        }

        @Override
        public void clear() {
            this.map.clear();
        }
    }
}

