/*
 * Decompiled with CFR 0.152.
 */
package org.drools.drl.parser;

import java.util.Arrays;
import org.drools.drl.parser.MessageImpl;
import org.kie.api.io.Resource;
import org.kie.internal.builder.InternalMessage;
import org.kie.internal.builder.KnowledgeBuilderResult;
import org.kie.internal.builder.ResultSeverity;

public abstract class BaseKnowledgeBuilderResultImpl
implements KnowledgeBuilderResult {
    private Resource resource;
    private String message;

    protected BaseKnowledgeBuilderResultImpl(Resource resource, String message) {
        this.message = message != null ? message : "";
        this.resource = resource;
    }

    public Resource getResource() {
        return this.resource;
    }

    public void setResource(Resource resource) {
        this.resource = resource;
    }

    public abstract ResultSeverity getSeverity();

    public boolean isError() {
        return this.getSeverity().equals((Object)ResultSeverity.ERROR);
    }

    public final String getMessage() {
        return this.message;
    }

    public final void setMessage(String message) {
        this.message = message;
    }

    public abstract int[] getLines();

    public String toString() {
        return this.getClass().getSimpleName() + ": " + this.getMessage();
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (this.getClass() != o.getClass()) {
            return false;
        }
        BaseKnowledgeBuilderResultImpl that = (BaseKnowledgeBuilderResultImpl)o;
        if (this.resource != null ? !this.resource.equals(that.getResource()) : that.getResource() != null) {
            return false;
        }
        return this.message.equals(that.message) && Arrays.equals(this.getLines(), that.getLines());
    }

    public int hashCode() {
        int hash = 29 * this.message.hashCode() + 31 * Arrays.hashCode(this.getLines());
        return this.resource != null ? hash + 37 * this.resource.hashCode() : hash;
    }

    public InternalMessage asMessage(long id) {
        return new MessageImpl(id, this);
    }
}

