/*
 * Decompiled with CFR 0.152.
 */
package org.drools.drl.parser.util;

public class ParserStringUtils {
    private ParserStringUtils() {
    }

    public static String safeStripStringDelimiters(String value) {
        if (value != null && (value = value.trim()).length() >= 2 && (value.startsWith("\"") && value.endsWith("\"") || value.startsWith("'") && value.endsWith("'"))) {
            value = value.substring(1, value.length() - 1);
        }
        return value;
    }

    public static String safeStripDelimiters(String value, String left, String right) {
        if (value != null && (value = value.trim()).length() >= left.length() + right.length() && value.startsWith(left) && value.endsWith(right)) {
            value = value.substring(left.length(), value.length() - right.length());
        }
        return value;
    }

    public static String appendPrefix(String prefix, String expr) {
        if (prefix.length() == 0) {
            return expr;
        }
        StringBuilder sb = new StringBuilder();
        ParserStringUtils.appendPrefixToOrExpression(sb, prefix, expr);
        return sb.toString();
    }

    private static void appendPrefixToOrExpression(StringBuilder sb, String prefix, String expr) {
        int start = 0;
        int end = expr.indexOf("||");
        do {
            if (start > 0) {
                sb.append(" || ");
            }
            ParserStringUtils.appendPrefixToAndExpression(sb, prefix, end > 0 ? expr.substring(start, end) : expr.substring(start));
            start = end + 2;
            end = expr.indexOf("||", start);
        } while (start > 1);
    }

    private static void appendPrefixToAndExpression(StringBuilder sb, String prefix, String expr) {
        int start = 0;
        int end = expr.indexOf("&&");
        do {
            if (start > 0) {
                sb.append(" && ");
            }
            sb.append(ParserStringUtils.appendPrefixToExpression(prefix, end > 0 ? expr.substring(start, end) : expr.substring(start)));
            start = end + 2;
            end = expr.indexOf("&&", start);
        } while (start > 1);
    }

    private static String appendPrefixToExpression(String prefix, String expr) {
        int colonPos = (expr = expr.trim()).indexOf(":");
        return colonPos < 0 ? prefix + expr : expr.substring(0, colonPos + 1) + " " + prefix + expr.substring(colonPos + 1).trim();
    }
}

