/*
 * Decompiled with CFR 0.152.
 */
package org.drools.drl.parser.lang.dsl;

import org.drools.drl.parser.DroolsError;

public class MappingError
extends DroolsError {
    public static final int TEMPLATE_UNKNOWN = 0;
    public static final int TEMPLATE_NATURAL = 1;
    public static final int TEMPLATE_TARGET = 2;
    public static final int ERROR_UNUSED_TOKEN = 21;
    public static final int ERROR_UNDECLARED_TOKEN = 22;
    public static final int ERROR_INVALID_TOKEN = 23;
    public static final int ERROR_UNMATCHED_BRACES = 24;
    private final int errorCode;
    private final int template;
    private final int offset;
    private final String token;
    private String templateText;
    private final int[] line;

    public MappingError(int errorCode, int template, int offset, String token, String templateText, int line) {
        super(MappingError.getSpecificMessage(errorCode, offset, token));
        this.errorCode = errorCode;
        this.template = template;
        this.token = token;
        this.offset = offset;
        this.templateText = templateText;
        this.line = new int[]{line};
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    @Override
    public int[] getLines() {
        return this.line;
    }

    public int getOffset() {
        return this.offset;
    }

    public int getTemplate() {
        return this.template;
    }

    public String getTemplateText() {
        return this.templateText;
    }

    private static String getSpecificMessage(int errorCode, int offset, String token) {
        switch (errorCode) {
            case 21: {
                return "Warning, the token " + token + " not used in the mapping.";
            }
            case 22: {
                return "Warning, the token " + token + " not found in the expression. (May not be a problem).";
            }
            case 23: {
                return "Invalid token declaration at offset " + offset + ": " + token;
            }
            case 24: {
                return "Unexpected } found at offset " + offset;
            }
        }
        return "Unkown error at offset: " + offset;
    }
}

