/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.util;

import java.util.ArrayList;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.drools.core.reteoo.LeftTuple;
import org.drools.core.reteoo.RightTuple;
import org.drools.core.reteoo.TupleImpl;
import org.drools.core.util.AbstractHashTable;
import org.drools.core.util.index.TupleIndexHashTable;
import org.drools.core.util.index.TupleList;
import org.junit.jupiter.api.Test;

public class IndexedHashtableIteratorTest {
    @Test
    public void testCanReachAllEntriesInLastTableRowRightTupleIndexHashTable() {
        RightTuple rightTuple;
        int i;
        TupleList rtList;
        int numEntries = 3;
        TupleList[] table = new TupleList[3];
        table[0] = rtList = new TupleList();
        for (i = 0; i < numEntries; ++i) {
            rightTuple = new RightTuple();
            rightTuple.setMemory(rtList);
            rtList.add((TupleImpl)rightTuple);
        }
        table[2] = rtList = new TupleList();
        for (i = 0; i < numEntries; ++i) {
            rightTuple = new RightTuple();
            rightTuple.setMemory(rtList);
            rtList.add((TupleImpl)rightTuple);
        }
        rtList = new TupleList();
        table[2].setNext(rtList);
        for (i = 0; i < numEntries; ++i) {
            rightTuple = new RightTuple();
            rightTuple.setMemory(rtList);
            rtList.add((TupleImpl)rightTuple);
        }
        TupleIndexHashTable.FullFastIterator iter = new TupleIndexHashTable.FullFastIterator(table);
        ArrayList<RightTuple> list = new ArrayList<RightTuple>();
        RightTuple rightTuple2 = (RightTuple)iter.next(null);
        while (rightTuple2 != null) {
            Assertions.assertThat((boolean)IndexedHashtableIteratorTest.contains(list, rightTuple2)).isFalse();
            list.add(rightTuple2);
            rightTuple2 = (RightTuple)iter.next((TupleImpl)rightTuple2);
        }
        TupleIndexHashTable rthTable = new TupleIndexHashTable();
        rthTable.init(table, 3, numEntries * 3);
        TupleIndexHashTable.FieldIndexHashTableFullIterator iter2 = new TupleIndexHashTable.FieldIndexHashTableFullIterator((AbstractHashTable)rthTable);
        list = new ArrayList();
        RightTuple rightTuple3 = (RightTuple)iter2.next();
        while (rightTuple3 != null) {
            Assertions.assertThat((boolean)IndexedHashtableIteratorTest.contains(list, rightTuple3)).isFalse();
            list.add(rightTuple3);
            rightTuple3 = (RightTuple)iter2.next();
        }
        Assertions.assertThat(list).hasSize(numEntries * 3);
    }

    @Test
    public void testCanReachAllEntriesInLastTableRowLeftTupleIndexHashTable() {
        LeftTuple leftTuple;
        int i;
        TupleList rtList;
        int numEntries = 3;
        TupleList[] table = new TupleList[3];
        table[0] = rtList = new TupleList();
        for (i = 0; i < numEntries; ++i) {
            leftTuple = new LeftTuple();
            leftTuple.setMemory(rtList);
            rtList.add((TupleImpl)leftTuple);
        }
        table[2] = rtList = new TupleList();
        for (i = 0; i < numEntries; ++i) {
            leftTuple = new LeftTuple();
            leftTuple.setMemory(rtList);
            rtList.add((TupleImpl)leftTuple);
        }
        rtList = new TupleList();
        table[2].setNext(rtList);
        for (i = 0; i < numEntries; ++i) {
            leftTuple = new LeftTuple();
            leftTuple.setMemory(rtList);
            rtList.add((TupleImpl)leftTuple);
        }
        TupleIndexHashTable.FullFastIterator iter = new TupleIndexHashTable.FullFastIterator(table);
        ArrayList<LeftTuple> list = new ArrayList<LeftTuple>();
        LeftTuple leftTuple2 = (LeftTuple)iter.next(null);
        while (leftTuple2 != null) {
            Assertions.assertThat((boolean)IndexedHashtableIteratorTest.contains(list, leftTuple2)).isFalse();
            list.add(leftTuple2);
            leftTuple2 = (LeftTuple)iter.next((TupleImpl)leftTuple2);
        }
        Assertions.assertThat(list).hasSize(numEntries * 3);
        TupleIndexHashTable lthTable = new TupleIndexHashTable();
        lthTable.init(table, 3, numEntries * 3);
        TupleIndexHashTable.FieldIndexHashTableFullIterator iter2 = new TupleIndexHashTable.FieldIndexHashTableFullIterator((AbstractHashTable)lthTable);
        list = new ArrayList();
        LeftTuple leftTuple3 = (LeftTuple)iter2.next();
        while (leftTuple3 != null) {
            Assertions.assertThat((boolean)IndexedHashtableIteratorTest.contains(list, leftTuple3)).isFalse();
            list.add(leftTuple3);
            leftTuple3 = (LeftTuple)iter2.next();
        }
        Assertions.assertThat(list).hasSize(numEntries * 3);
    }

    public static boolean contains(List list, Object object) {
        for (Object o : list) {
            if (o != object) continue;
            return true;
        }
        return false;
    }
}

