/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.util.index;

import java.io.Serializable;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.reteoo.TupleImpl;
import org.drools.core.reteoo.TupleMemory;
import org.drools.core.util.FastIterator;
import org.drools.core.util.LinkedList;
import org.drools.core.util.SingleLinkedEntry;

public class TupleList
extends LinkedList<TupleImpl>
implements TupleMemory,
SingleLinkedEntry<TupleList>,
Serializable {
    public static final long serialVersionUID = 510L;
    private TupleList next;

    public TupleList() {
    }

    public TupleList(TupleImpl first, TupleImpl last, int size) {
        super(first, last, size);
    }

    @Override
    public void add(TupleImpl node) {
        super.add(node);
        node.setMemory(this);
    }

    @Override
    public void remove(TupleImpl node) {
        super.remove(node);
        node.clear();
    }

    @Override
    public TupleImpl getFirst(TupleImpl tuple) {
        return (TupleImpl)this.getFirst();
    }

    @Override
    public TupleImpl get(InternalFactHandle handle) {
        for (TupleImpl current = (TupleImpl)this.getFirst(); current != null; current = current.getNext()) {
            if (handle != current.getFactHandle()) continue;
            return current;
        }
        return null;
    }

    @Override
    public TupleImpl removeFirst() {
        TupleImpl node = (TupleImpl)super.removeFirst();
        node.clear();
        return node;
    }

    @Override
    public TupleImpl removeLast() {
        TupleImpl node = (TupleImpl)super.removeLast();
        node.clear();
        return node;
    }

    @Override
    public TupleMemory.IndexType getIndexType() {
        return TupleMemory.IndexType.NONE;
    }

    @Override
    public FastIterator<TupleImpl> fastIterator() {
        return LinkedList.fastIterator;
    }

    @Override
    public FastIterator<TupleImpl> fullFastIterator() {
        return LinkedList.fastIterator;
    }

    @Override
    public FastIterator<TupleImpl> fullFastIterator(TupleImpl tuple) {
        return LinkedList.fastIterator;
    }

    @Override
    public boolean isIndexed() {
        return false;
    }

    @Override
    public TupleList getNext() {
        return this.next;
    }

    @Override
    public void setNext(TupleList next) {
        this.next = next;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        FastIterator<TupleImpl> it = super.fastIterator();
        TupleImpl tuple = (TupleImpl)this.getFirst();
        while (tuple != null) {
            builder.append(tuple).append("\n");
            tuple = it.next(tuple);
        }
        return builder.toString();
    }

    protected void copyStateInto(TupleList other) {
        super.copyStateInto(other);
        for (TupleImpl current = (TupleImpl)this.getFirst(); current != null; current = current.getNext()) {
            current.setMemory(other);
        }
    }
}

