/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.phreak;

import org.drools.base.base.ValueResolver;
import org.drools.base.definitions.rule.impl.RuleImpl;
import org.drools.base.rule.accessor.Salience;
import org.drools.core.common.ActivationsManager;
import org.drools.core.common.InternalAgendaGroup;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.PropagationContext;
import org.drools.core.common.ReteEvaluator;
import org.drools.core.common.TupleSets;
import org.drools.core.phreak.RuleAgendaItem;
import org.drools.core.phreak.RuleExecutor;
import org.drools.core.reteoo.ObjectTypeConf;
import org.drools.core.reteoo.RuleTerminalNode;
import org.drools.core.reteoo.RuleTerminalNodeLeftTuple;
import org.drools.core.reteoo.TerminalNode;
import org.drools.core.reteoo.TupleImpl;
import org.drools.core.rule.consequence.InternalMatch;
import org.kie.api.definition.rule.Rule;
import org.kie.api.event.rule.MatchCancelledCause;
import org.kie.api.runtime.rule.Match;

public class PhreakRuleTerminalNode {
    public void doNode(TerminalNode rtnNode, ActivationsManager activationsManager, TupleSets srcLeftTuples, RuleExecutor executor) {
        if (srcLeftTuples.getDeleteFirst() != null) {
            this.doLeftDeletes(activationsManager, srcLeftTuples, executor);
        }
        if (srcLeftTuples.getUpdateFirst() != null) {
            this.doLeftUpdates(rtnNode, activationsManager, srcLeftTuples, executor);
        }
        if (srcLeftTuples.getInsertFirst() != null) {
            this.doLeftInserts(rtnNode, activationsManager, srcLeftTuples, executor);
        }
        srcLeftTuples.resetAll();
    }

    public void doLeftInserts(TerminalNode rtnNode, ActivationsManager activationsManager, TupleSets srcLeftTuples, RuleExecutor executor) {
        RuleAgendaItem ruleAgendaItem = executor.getRuleAgendaItem();
        if (rtnNode.getRule().getAutoFocus() && !ruleAgendaItem.getAgendaGroup().isActive()) {
            activationsManager.getAgendaGroupsManager().setFocus(ruleAgendaItem.getAgendaGroup());
        }
        RuleTerminalNodeLeftTuple leftTuple = (RuleTerminalNodeLeftTuple)srcLeftTuples.getInsertFirst();
        while (leftTuple != null) {
            RuleTerminalNodeLeftTuple next = (RuleTerminalNodeLeftTuple)leftTuple.getStagedNext();
            PhreakRuleTerminalNode.doLeftTupleInsert(rtnNode, executor, activationsManager, ruleAgendaItem, leftTuple);
            leftTuple.clearStaged();
            leftTuple = next;
        }
    }

    private static boolean sameRules(TerminalNode rtn1, TerminalNode rtn2) {
        if (rtn2 == null) {
            return false;
        }
        RuleImpl rule1 = rtn1.getRule();
        RuleImpl rule2 = rtn2.getRule();
        return rule1.getName().equals(rule2.getName()) && rule1.getPackageName().equals(rule2.getPackageName()) && ((RuleTerminalNode)rtn1).getConsequenceName().equals(((RuleTerminalNode)rtn2).getConsequenceName());
    }

    public static void doLeftTupleInsert(TerminalNode rtnNode, RuleExecutor executor, ActivationsManager activationsManager, RuleAgendaItem ruleAgendaItem, RuleTerminalNodeLeftTuple leftTuple) {
        PropagationContext pctx;
        ReteEvaluator reteEvaluator = activationsManager.getReteEvaluator();
        if (reteEvaluator.getRuleSessionConfiguration().isDirectFiring()) {
            executor.addActiveTuple(leftTuple);
            return;
        }
        if (rtnNode.getRule().isNoLoop()) {
            pctx = leftTuple.findMostRecentPropagationContext();
            if (PhreakRuleTerminalNode.sameRules(rtnNode, pctx.getTerminalNodeOrigin())) {
                return;
            }
        } else {
            pctx = leftTuple.getPropagationContext();
        }
        int salienceInt = PhreakRuleTerminalNode.getSalienceValue(rtnNode, ruleAgendaItem, leftTuple, reteEvaluator);
        activationsManager.createAgendaItem(leftTuple, salienceInt, pctx, ruleAgendaItem, ruleAgendaItem.getAgendaGroup());
        activationsManager.getAgendaEventSupport().fireActivationCreated(leftTuple, activationsManager.getReteEvaluator());
        if (rtnNode.getRule().isLockOnActive() && pctx.getType() != PropagationContext.Type.RULE_ADDITION) {
            pctx = leftTuple.findMostRecentPropagationContext();
            InternalAgendaGroup agendaGroup = executor.getRuleAgendaItem().getAgendaGroup();
            if (PhreakRuleTerminalNode.blockedByLockOnActive(rtnNode.getRule(), pctx, agendaGroup)) {
                activationsManager.getAgendaEventSupport().fireActivationCancelled(leftTuple, reteEvaluator, MatchCancelledCause.FILTER);
                return;
            }
        }
        if (activationsManager.getActivationsFilter() != null && !activationsManager.getActivationsFilter().accept(leftTuple)) {
            executor.addDormantTuple(leftTuple);
            return;
        }
        executor.addActiveTuple(leftTuple);
        activationsManager.addItemToActivationGroup(leftTuple);
        if (!rtnNode.isFireDirect() && executor.isDeclarativeAgendaEnabled()) {
            PhreakRuleTerminalNode.insertAndStageActivation(reteEvaluator, leftTuple);
        }
    }

    private static void insertAndStageActivation(ReteEvaluator reteEvaluator, InternalMatch internalMatch) {
        ObjectTypeConf activationObjectTypeConf = reteEvaluator.getDefaultEntryPoint().getObjectTypeConfigurationRegistry().getObjectTypeConf(internalMatch);
        InternalFactHandle factHandle = reteEvaluator.getFactHandleFactory().newFactHandle(internalMatch, activationObjectTypeConf, reteEvaluator, reteEvaluator.getDefaultEntryPoint());
        reteEvaluator.getDefaultEntryPoint().getEntryPointNode().assertActivation(factHandle, internalMatch.getPropagationContext(), reteEvaluator);
        internalMatch.setActivationFactHandle(factHandle);
    }

    private static int getSalienceValue(TerminalNode rtnNode, RuleAgendaItem ruleAgendaItem, InternalMatch leftTuple, ReteEvaluator reteEvaluator) {
        Salience salience = ruleAgendaItem.getRule().getSalience();
        return salience == null ? 0 : (salience.isDynamic() ? salience.getValue((Match)leftTuple, (Rule)rtnNode.getRule(), (ValueResolver)reteEvaluator) : salience.getValue());
    }

    public void doLeftUpdates(TerminalNode rtnNode, ActivationsManager activationsManager, TupleSets srcLeftTuples, RuleExecutor executor) {
        RuleAgendaItem ruleAgendaItem = executor.getRuleAgendaItem();
        if (rtnNode.getRule().getAutoFocus() && !ruleAgendaItem.getAgendaGroup().isActive()) {
            activationsManager.getAgendaGroupsManager().setFocus(ruleAgendaItem.getAgendaGroup());
        }
        RuleTerminalNodeLeftTuple leftTuple = (RuleTerminalNodeLeftTuple)srcLeftTuples.getUpdateFirst();
        while (leftTuple != null) {
            RuleTerminalNodeLeftTuple next = (RuleTerminalNodeLeftTuple)leftTuple.getStagedNext();
            PhreakRuleTerminalNode.doLeftTupleUpdate(rtnNode, executor, activationsManager, leftTuple);
            leftTuple.clearStaged();
            leftTuple = next;
        }
    }

    public static void doLeftTupleUpdate(TerminalNode rtnNode, RuleExecutor executor, ActivationsManager activationsManager, RuleTerminalNodeLeftTuple leftTuple) {
        ReteEvaluator reteEvaluator = activationsManager.getReteEvaluator();
        if (reteEvaluator.getRuleSessionConfiguration().isDirectFiring()) {
            if (!leftTuple.isQueued()) {
                executor.modifyActiveTuple(leftTuple);
                reteEvaluator.getRuleEventSupport().onUpdateMatch(leftTuple);
            }
            return;
        }
        PropagationContext pctx = leftTuple.getPropagationContext();
        boolean blocked = false;
        if (executor.isDeclarativeAgendaEnabled()) {
            if (leftTuple.hasBlockers()) {
                blocked = true;
            }
        } else if (rtnNode.getRule().isNoLoop() && (pctx = leftTuple.findMostRecentPropagationContext()).getTerminalNodeOrigin() != null) {
            blocked = rtnNode.equals(pctx.getTerminalNodeOrigin());
        }
        int salienceInt = PhreakRuleTerminalNode.getSalienceValue(rtnNode, executor.getRuleAgendaItem(), leftTuple, reteEvaluator);
        if (activationsManager.getActivationsFilter() != null && !activationsManager.getActivationsFilter().accept(leftTuple)) {
            executor.addDormantTuple(leftTuple);
            return;
        }
        if (!blocked) {
            boolean addToExector = true;
            if (rtnNode.getRule().isLockOnActive() && pctx.getType() != PropagationContext.Type.RULE_ADDITION) {
                pctx = leftTuple.findMostRecentPropagationContext();
                InternalAgendaGroup agendaGroup = executor.getRuleAgendaItem().getAgendaGroup();
                if (PhreakRuleTerminalNode.blockedByLockOnActive(rtnNode.getRule(), pctx, agendaGroup)) {
                    addToExector = false;
                }
            }
            if (addToExector && !leftTuple.isQueued()) {
                activationsManager.getAgendaEventSupport().fireActivationCreated(leftTuple, reteEvaluator);
                leftTuple.update(salienceInt, pctx);
                executor.modifyActiveTuple(leftTuple);
                reteEvaluator.getRuleEventSupport().onUpdateMatch(leftTuple);
            }
        } else {
            leftTuple.update(salienceInt, pctx);
        }
        if (!rtnNode.isFireDirect() && executor.isDeclarativeAgendaEnabled()) {
            PhreakRuleTerminalNode.modifyActivation(reteEvaluator, leftTuple);
        }
    }

    private static void modifyActivation(ReteEvaluator reteEvaluator, InternalMatch internalMatch) {
        InternalFactHandle factHandle = internalMatch.getActivationFactHandle();
        if (factHandle != null) {
            reteEvaluator.getDefaultEntryPoint().getEntryPointNode().modifyActivation(factHandle, internalMatch.getPropagationContext(), reteEvaluator);
        }
    }

    public void doLeftDeletes(ActivationsManager activationsManager, TupleSets srcLeftTuples, RuleExecutor executor) {
        TupleImpl leftTuple = srcLeftTuples.getDeleteFirst();
        while (leftTuple != null) {
            TupleImpl next = leftTuple.getStagedNext();
            PhreakRuleTerminalNode.doLeftDelete(activationsManager, executor, (RuleTerminalNodeLeftTuple)leftTuple);
            leftTuple.clearStaged();
            leftTuple = next;
        }
    }

    public static void doLeftDelete(ActivationsManager activationsManager, RuleExecutor executor, RuleTerminalNodeLeftTuple leftTuple) {
        leftTuple.setMatched(false);
        leftTuple.cancelActivation(activationsManager);
        if (leftTuple.getMemory() != null) {
            executor.removeActiveTuple(leftTuple);
        } else if (leftTuple.getStagedType() == 3 && !leftTuple.isQueued()) {
            executor.removeDormantTuple(leftTuple);
        }
        leftTuple.setContextObject(null);
    }

    private static boolean blockedByLockOnActive(RuleImpl rule, PropagationContext pctx, InternalAgendaGroup agendaGroup) {
        if (rule.isLockOnActive()) {
            long handleRecency = pctx.getFactHandle().getRecency();
            boolean isActive = agendaGroup.isActive();
            long activatedForRecency = agendaGroup.getActivatedForRecency();
            long clearedForRecency = agendaGroup.getClearedForRecency();
            if (isActive && activatedForRecency < handleRecency && agendaGroup.getAutoFocusActivator() != pctx) {
                return true;
            }
            return clearedForRecency != -1L && clearedForRecency >= handleRecency;
        }
        return false;
    }
}

