/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.util.index;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.drools.core.reteoo.TupleImpl;
import org.drools.core.reteoo.TupleMemory;
import org.drools.core.util.AbstractHashTable;
import org.drools.core.util.FastIterator;
import org.drools.core.util.Iterator;
import org.drools.core.util.LinkedList;
import org.drools.core.util.index.TupleList;

public class TupleIndexHashTable
extends AbstractHashTable
implements TupleMemory {
    private static final long serialVersionUID = 510L;
    private transient FieldIndexHashTableFullIterator tupleValueFullIterator;
    private transient FullFastIterator fullFastIterator;
    private int factSize;
    private AbstractHashTable.Index index;
    private boolean left;

    public TupleIndexHashTable() {
    }

    public TupleIndexHashTable(AbstractHashTable.Index index, boolean left) {
        this(128, 0.75f, index, left);
    }

    public TupleIndexHashTable(int capacity, float loadFactor, AbstractHashTable.Index index, boolean left) {
        super(capacity, loadFactor);
        this.left = left;
        this.index = index;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.factSize = in.readInt();
        this.index = (AbstractHashTable.Index)in.readObject();
        this.left = in.readBoolean();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeInt(this.factSize);
        out.writeObject(this.index);
        out.writeBoolean(this.left);
    }

    public void init(TupleList[] table, int size, int factSize) {
        this.table = table;
        this.size = size;
        this.factSize = factSize;
    }

    @Override
    public Iterator<TupleImpl> iterator() {
        if (this.tupleValueFullIterator == null) {
            this.tupleValueFullIterator = new FieldIndexHashTableFullIterator(this);
        } else {
            this.tupleValueFullIterator.reset();
        }
        return this.tupleValueFullIterator;
    }

    @Override
    public FastIterator<TupleImpl> fastIterator() {
        return LinkedList.fastIterator;
    }

    @Override
    public FastIterator<TupleImpl> fullFastIterator() {
        if (this.fullFastIterator == null) {
            this.fullFastIterator = new FullFastIterator(this.table);
        } else {
            this.fullFastIterator.reset(this.table);
        }
        return this.fullFastIterator;
    }

    @Override
    public FastIterator<TupleImpl> fullFastIterator(TupleImpl tuple) {
        this.fullFastIterator.resume(tuple.getMemory(), this.table);
        return this.fullFastIterator;
    }

    @Override
    public TupleImpl getFirst(TupleImpl tuple) {
        TupleList bucket = this.get(tuple, !this.left);
        return bucket != null ? (TupleImpl)bucket.getFirst() : null;
    }

    @Override
    public boolean isIndexed() {
        return true;
    }

    @Override
    public AbstractHashTable.Index getIndex() {
        return this.index;
    }

    @Override
    public int getResizeHashcode(TupleList entry) {
        return entry.hashCode();
    }

    @Override
    public void removeAdd(TupleImpl tuple) {
        AbstractHashTable.HashEntry hashEntry;
        try {
            hashEntry = this.index.hashCodeOf(tuple, this.left);
        }
        catch (UnsupportedOperationException e) {
            return;
        }
        TupleList memory = tuple.getMemory();
        memory.remove(tuple);
        if (hashEntry.hashCode() == memory.hashCode()) {
            memory.add(tuple);
            return;
        }
        --this.factSize;
        if (memory.getFirst() == null) {
            TupleList current;
            int index = TupleIndexHashTable.indexOf(memory.hashCode(), this.table.length);
            TupleList previous = null;
            for (current = this.table[index]; current != memory; current = current.getNext()) {
                previous = current;
            }
            if (previous != null) {
                previous.setNext(current.getNext());
            } else {
                this.table[index] = current.getNext();
            }
            --this.size;
        }
        this.add(tuple);
    }

    @Override
    public void add(TupleImpl tuple) {
        TupleList entry = this.getOrCreate(tuple);
        if (entry != null) {
            entry.add(tuple);
            ++this.factSize;
        }
    }

    @Override
    public void remove(TupleImpl tuple) {
        TupleList memory = tuple.getMemory();
        memory.remove(tuple);
        --this.factSize;
        if (memory.getFirst() == null) {
            TupleList current;
            int index = TupleIndexHashTable.indexOf(memory.hashCode(), this.table.length);
            TupleList previous = null;
            for (current = this.table[index]; current != memory; current = current.getNext()) {
                previous = current;
            }
            if (previous != null) {
                previous.setNext(current.getNext());
            } else {
                this.table[index] = current.getNext();
            }
            --this.size;
        }
        tuple.clear();
    }

    private TupleList getOrCreate(TupleImpl tuple) {
        TupleList entry;
        AbstractHashTable.HashEntry hashEntry;
        try {
            hashEntry = this.index.hashCodeOf(tuple, this.left);
        }
        catch (UnsupportedOperationException e) {
            return null;
        }
        int index = TupleIndexHashTable.indexOf(hashEntry.hashCode(), this.table.length);
        for (entry = this.table[index]; entry != null; entry = entry.getNext()) {
            if (!this.matches(entry, hashEntry)) continue;
            return entry;
        }
        entry = new AbstractHashTable.IndexTupleList(this.index, hashEntry.clone());
        entry.setNext(this.table[index]);
        this.table[index] = entry;
        if (this.size++ >= this.threshold) {
            this.resize(2 * this.table.length);
        }
        return entry;
    }

    private TupleList get(TupleImpl tuple, boolean isLeftTuple) {
        AbstractHashTable.HashEntry hashEntry;
        try {
            hashEntry = this.index.hashCodeOf(tuple, isLeftTuple);
        }
        catch (UnsupportedOperationException e) {
            return null;
        }
        int index = TupleIndexHashTable.indexOf(hashEntry.hashCode(), this.table.length);
        for (TupleList entry = this.table[index]; entry != null; entry = entry.getNext()) {
            if (!this.matches(entry, hashEntry)) continue;
            return entry;
        }
        return null;
    }

    private boolean matches(TupleList list, AbstractHashTable.HashEntry hashEntry) {
        return list.hashCode() == hashEntry.hashCode() && hashEntry.equals(((AbstractHashTable.IndexTupleList)list).getHashEntry());
    }

    @Override
    public int size() {
        return this.factSize;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        Iterator<TupleImpl> it = this.iterator();
        TupleImpl leftTuple = it.next();
        while (leftTuple != null) {
            builder.append(leftTuple).append("\n");
            leftTuple = it.next();
        }
        return builder.toString();
    }

    @Override
    public void clear() {
        super.clear();
        this.factSize = 0;
        this.fullFastIterator = null;
        this.tupleValueFullIterator = null;
    }

    @Override
    public TupleMemory.IndexType getIndexType() {
        return TupleMemory.IndexType.EQUAL;
    }

    public static class FieldIndexHashTableFullIterator
    implements Iterator<TupleImpl> {
        private final AbstractHashTable hashTable;
        private TupleList[] table;
        private int row;
        private int length;
        private TupleList list;
        private TupleImpl tuple;

        public FieldIndexHashTableFullIterator(AbstractHashTable hashTable) {
            this.hashTable = hashTable;
            this.reset();
        }

        @Override
        public TupleImpl next() {
            while (this.row <= this.length) {
                while (this.list == null) {
                    if (this.row < this.length) {
                        this.list = this.table[this.row];
                        ++this.row;
                    } else {
                        return null;
                    }
                    if (this.list == null) continue;
                    this.tuple = (TupleImpl)this.list.getFirst();
                    return this.tuple;
                }
                this.tuple = this.tuple.getNext();
                if (this.tuple != null) {
                    return this.tuple;
                }
                this.list = this.list.getNext();
                if (this.list == null) continue;
                this.tuple = (TupleImpl)this.list.getFirst();
                return this.tuple;
            }
            return null;
        }

        public void remove() {
            throw new UnsupportedOperationException("FieldIndexHashTableFullIterator does not support remove().");
        }

        public void reset() {
            this.table = this.hashTable.getTable();
            this.length = this.table.length;
            this.row = 0;
            this.list = null;
            this.tuple = null;
        }
    }

    public static class FullFastIterator
    implements FastIterator<TupleImpl> {
        private TupleList[] table;
        private int row;

        public FullFastIterator(TupleList[] table) {
            this.table = table;
            this.row = 0;
        }

        public void resume(TupleList target, TupleList[] table) {
            this.table = table;
            this.row = TupleIndexHashTable.indexOf(target.hashCode(), this.table.length);
            ++this.row;
        }

        @Override
        public TupleImpl next(TupleImpl tuple) {
            TupleList list = null;
            if (tuple != null) {
                list = tuple.getMemory();
            }
            int length = this.table.length;
            while (this.row <= length) {
                while (list == null) {
                    if (this.row < length) {
                        list = this.table[this.row];
                        ++this.row;
                    } else {
                        return null;
                    }
                    if (list == null) continue;
                    tuple = (TupleImpl)list.getFirst();
                    return tuple;
                }
                if ((tuple = tuple.getNext()) != null) {
                    return tuple;
                }
                if ((list = list.getNext()) == null) continue;
                tuple = (TupleImpl)list.getFirst();
                return tuple;
            }
            return null;
        }

        @Override
        public boolean isFullIterator() {
            return true;
        }

        public void reset(TupleList[] table) {
            this.table = table;
            this.row = 0;
        }
    }
}

