/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.util;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.NoSuchElementException;
import org.drools.core.reteoo.TupleImpl;
import org.drools.core.util.DoubleLinkedEntry;
import org.drools.core.util.FastIterator;
import org.drools.core.util.Iterator;
import org.drools.core.util.SingleLinkedEntry;

public class LinkedList<T extends DoubleLinkedEntry<T>>
implements Externalizable {
    private static final long serialVersionUID = 510L;
    private T firstNode;
    private T lastNode;
    private int size;
    public static final FastIterator fastIterator = new LinkedListFastIterator();

    public LinkedList() {
    }

    public LinkedList(T node) {
        this.firstNode = node;
        this.lastNode = node;
        ++this.size;
    }

    public LinkedList(T firstNode, T lastNode, int size) {
        this.firstNode = firstNode;
        this.lastNode = lastNode;
        this.size = size;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.firstNode = (DoubleLinkedEntry)in.readObject();
        this.lastNode = (DoubleLinkedEntry)in.readObject();
        this.size = in.readInt();
        DoubleLinkedEntry current = this.firstNode;
        Object previous = null;
        while (current != this.lastNode) {
            DoubleLinkedEntry next = (DoubleLinkedEntry)in.readObject();
            current.setPrevious(previous);
            current.setNext((DoubleLinkedEntry)next);
            previous = current;
            current = next;
        }
        if (current != null) {
            current.setPrevious(previous);
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.firstNode);
        out.writeObject(this.lastNode);
        out.writeInt(this.size);
        if (this.firstNode == this.lastNode) {
            return;
        }
        for (Object node = this.firstNode; node != null; node = (DoubleLinkedEntry)node.getNext()) {
            out.writeObject(node.getNext());
        }
    }

    public void add(T node) {
        if (this.firstNode == null) {
            this.firstNode = node;
            this.lastNode = node;
        } else {
            this.lastNode.setNext(node);
            node.setPrevious(this.lastNode);
            this.lastNode = node;
        }
        ++this.size;
    }

    public void addLast(T node) {
        if (this.firstNode == null) {
            this.firstNode = node;
            this.lastNode = node;
        } else {
            T currentLast = this.lastNode;
            currentLast.setNext(node);
            node.setPrevious(currentLast);
            this.lastNode = node;
        }
        ++this.size;
    }

    public void addFirst(T node) {
        if (this.firstNode == null) {
            this.firstNode = node;
            this.lastNode = node;
        } else {
            T currentFirst = this.firstNode;
            currentFirst.setPrevious(node);
            node.setNext(currentFirst);
            this.firstNode = node;
        }
        ++this.size;
    }

    public void remove(T node) {
        if (this.firstNode == node) {
            this.removeFirst();
        } else if (this.lastNode == node) {
            this.removeLast();
        } else {
            node.getPrevious().setNext((DoubleLinkedEntry)((DoubleLinkedEntry)node.getNext()));
            ((DoubleLinkedEntry)node.getNext()).setPrevious(node.getPrevious());
            --this.size;
            node.setPrevious(null);
            node.setNext(null);
        }
    }

    public T removeFirst() {
        if (this.firstNode == null) {
            return null;
        }
        T node = this.firstNode;
        this.firstNode = (DoubleLinkedEntry)node.getNext();
        node.setNext(null);
        if (this.firstNode != null) {
            this.firstNode.setPrevious(null);
        } else {
            this.lastNode = null;
        }
        --this.size;
        return node;
    }

    public T removeLast() {
        if (this.lastNode == null) {
            return null;
        }
        T node = this.lastNode;
        this.lastNode = node.getPrevious();
        node.setPrevious(null);
        if (this.lastNode != null) {
            this.lastNode.setNext(null);
        } else {
            this.firstNode = null;
        }
        --this.size;
        return node;
    }

    public void insertAfter(T existingNode, T newNode) {
        if (newNode.getPrevious() != null || newNode.getNext() != null) {
            return;
        }
        if (existingNode == null) {
            if (this.isEmpty()) {
                this.firstNode = newNode;
                this.lastNode = newNode;
            } else {
                T node = this.firstNode;
                node.setPrevious(newNode);
                newNode.setNext(node);
                this.firstNode = newNode;
            }
        } else if (existingNode == this.lastNode) {
            existingNode.setNext(newNode);
            newNode.setPrevious(existingNode);
            this.lastNode = newNode;
        } else {
            ((DoubleLinkedEntry)existingNode.getNext()).setPrevious(newNode);
            newNode.setNext((DoubleLinkedEntry)((DoubleLinkedEntry)existingNode.getNext()));
            existingNode.setNext(newNode);
            newNode.setPrevious(existingNode);
        }
        ++this.size;
    }

    public void removeAdd(T node) {
        if (this.lastNode == node) {
            return;
        }
        DoubleLinkedEntry previous = node.getPrevious();
        DoubleLinkedEntry next = (DoubleLinkedEntry)node.getNext();
        if (previous == null) {
            next.setPrevious(null);
            this.firstNode = next;
        } else {
            previous.setNext((DoubleLinkedEntry)next);
            next.setPrevious(previous);
        }
        this.lastNode.setNext(node);
        node.setPrevious(this.lastNode);
        node.setNext(null);
        this.lastNode = node;
    }

    public boolean contains(T node) {
        for (Object currentNode = this.firstNode; currentNode != null; currentNode = (DoubleLinkedEntry)currentNode.getNext()) {
            if (currentNode != node) continue;
            return true;
        }
        return false;
    }

    public final T getFirst() {
        return this.firstNode;
    }

    public final T getLast() {
        return this.lastNode;
    }

    public T get(int i) {
        Object current = this.getFirst();
        for (int j = 0; j < i; ++j) {
            current = (DoubleLinkedEntry)current.getNext();
        }
        return current;
    }

    public T get(T node) {
        for (Object current = this.getFirst(); current != null; current = (DoubleLinkedEntry)current.getNext()) {
            if (!node.equals(current)) continue;
            return current;
        }
        return null;
    }

    public final boolean isEmpty() {
        return this.firstNode == null;
    }

    public void clear() {
        this.firstNode = null;
        this.lastNode = null;
        this.size = 0;
    }

    public final int size() {
        return this.size;
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        for (Object node = this.firstNode; node != null; node = (DoubleLinkedEntry)node.getNext()) {
            result = 31 * result + node.hashCode();
        }
        return result;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof LinkedList)) {
            return false;
        }
        LinkedList other = (LinkedList)object;
        if (this.size() != other.size()) {
            return false;
        }
        Object thisNode = this.firstNode;
        for (Object otherNode = other.firstNode; thisNode != null && otherNode != null; thisNode = (DoubleLinkedEntry)thisNode.getNext(), otherNode = (DoubleLinkedEntry)otherNode.getNext()) {
            if (thisNode.equals(otherNode)) continue;
            return false;
        }
        return true;
    }

    public FastIterator<T> fastIterator() {
        return fastIterator;
    }

    public java.util.Iterator<T> javaUtilIterator() {
        return new JavaUtilIterator(this);
    }

    protected void copyStateInto(LinkedList<T> other) {
        other.firstNode = this.firstNode;
        other.lastNode = this.lastNode;
        other.size = this.size;
    }

    public static class JavaUtilIterator<T extends DoubleLinkedEntry<T>>
    implements java.util.Iterator<T>,
    Externalizable {
        private LinkedList<T> list;
        private T currentNode;
        private T nextNode;
        private boolean immutable;

        public JavaUtilIterator() {
        }

        public JavaUtilIterator(LinkedList<T> list) {
            this(list, true);
        }

        public JavaUtilIterator(LinkedList<T> list, boolean immutable) {
            this.list = list;
            this.nextNode = this.list.getFirst();
            this.immutable = immutable;
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.list = (LinkedList)in.readObject();
            this.currentNode = (DoubleLinkedEntry)in.readObject();
            this.nextNode = (DoubleLinkedEntry)in.readObject();
            this.immutable = in.readBoolean();
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeObject(this.list);
            out.writeObject(this.currentNode);
            out.writeObject(this.nextNode);
            out.writeBoolean(this.immutable);
        }

        @Override
        public boolean hasNext() {
            return this.nextNode != null;
        }

        @Override
        public T next() {
            this.currentNode = this.nextNode;
            if (this.currentNode == null) {
                throw new NoSuchElementException("No more elements to return");
            }
            this.nextNode = (DoubleLinkedEntry)this.currentNode.getNext();
            return this.currentNode;
        }

        @Override
        public void remove() {
            if (this.immutable) {
                throw new UnsupportedOperationException("This  Iterator is immutable, you cannot call remove()");
            }
            if (this.currentNode == null) {
                throw new IllegalStateException("No item to remove. Call next() before calling remove().");
            }
            this.list.remove(this.currentNode);
            this.currentNode = null;
        }
    }

    public static class LinkedListFastIterator
    implements FastIterator<TupleImpl> {
        @Override
        public TupleImpl next(TupleImpl object) {
            return object.getNext();
        }

        @Override
        public boolean isFullIterator() {
            return false;
        }
    }

    public static class LinkedListIterator<T extends DoubleLinkedEntry<T>>
    implements Iterator<T>,
    Externalizable {
        private LinkedList<T> list;
        private T current;

        public void reset(LinkedList<T> list) {
            this.list = list;
            this.current = this.list.firstNode;
        }

        @Override
        public T next() {
            if (this.current == null) {
                return null;
            }
            T node = this.current;
            this.current = (DoubleLinkedEntry)this.current.getNext();
            return node;
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.list = (LinkedList)in.readObject();
            this.current = (DoubleLinkedEntry)in.readObject();
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeObject(this.list);
            out.writeObject(this.current);
        }
    }

    public static class TMSLinkedListFastIterator<K extends SingleLinkedEntry<K>>
    implements FastIterator<K> {
        @Override
        public K next(K object) {
            return (K)object.getNext();
        }

        @Override
        public boolean isFullIterator() {
            return false;
        }
    }
}

