/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.builder.conf;

import com.sun.tools.xjc.Language;
import com.sun.tools.xjc.Options;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.drools.io.ResourceConfigurationImpl;
import org.kie.api.io.ResourceConfiguration;
import org.kie.internal.builder.JaxbConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JaxbConfigurationImpl
extends ResourceConfigurationImpl
implements JaxbConfiguration {
    private final Logger logger = LoggerFactory.getLogger(JaxbConfigurationImpl.class);
    private Options xjcOpts;
    private String systemId;
    private List<String> classes;

    public JaxbConfigurationImpl() {
    }

    public JaxbConfigurationImpl(Options xjcOpts, String systemId) {
        this.xjcOpts = xjcOpts;
        this.systemId = systemId;
        this.classes = new ArrayList<String>();
    }

    public Options getXjcOpts() {
        return this.xjcOpts;
    }

    public String getSystemId() {
        return this.systemId;
    }

    public List<String> getClasses() {
        return this.classes;
    }

    public void setClasses(List<String> classes) {
        this.classes = classes;
    }

    public void setSystemId(String systemId) {
        this.systemId = systemId;
    }

    public void setXjcOpts(Options xjcOpts) {
        this.xjcOpts = xjcOpts;
    }

    public byte[] toByteArray() {
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        try {
            ObjectOutputStream out = new ObjectOutputStream(buf);
            out.writeObject(this.xjcOpts);
            out.writeObject(this.systemId);
            out.writeObject(this.classes);
            out.close();
        }
        catch (IOException e) {
            this.logger.error("Error serializing decision table configuration.", (Throwable)e);
        }
        return buf.toByteArray();
    }

    public JaxbConfiguration fromByteArray(byte[] conf) {
        try {
            ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(conf));
            this.xjcOpts = (Options)in.readObject();
            this.systemId = (String)in.readObject();
            this.classes = (List)in.readObject();
        }
        catch (Exception e) {
            this.logger.error("Error deserializing decision table configuration.", (Throwable)e);
        }
        return this;
    }

    public Properties toProperties() {
        Properties prop = super.toProperties();
        prop.setProperty("drools.jaxb.conf.systemId", this.systemId);
        prop.setProperty("drools.jaxb.conf.classes", this.classes.toString());
        if (this.xjcOpts != null) {
            prop.setProperty("drools.jaxb.conf.opts.class", this.xjcOpts.getClass().getName());
            if (this.xjcOpts.getSchemaLanguage() != null) {
                prop.setProperty("drools.jaxb.conf.opts.lang", this.xjcOpts.getSchemaLanguage().toString());
            }
        }
        return prop;
    }

    public ResourceConfiguration fromProperties(Properties prop) {
        String optsClass;
        super.fromProperties(prop);
        this.systemId = prop.getProperty("drools.jaxb.conf.systemId", null);
        String classesStr = prop.getProperty("drools.jaxb.conf.classes", "[]");
        classesStr = classesStr.substring(1, classesStr.length() - 1).trim();
        this.classes = new ArrayList<String>();
        if (classesStr != null && classesStr.length() > 1) {
            for (String clz : classesStr.split(",")) {
                this.classes.add(clz.trim());
            }
        }
        if ((optsClass = prop.getProperty("drools.jaxb.conf.opts.class", null)) != null) {
            try {
                this.xjcOpts = (Options)Class.forName(optsClass).newInstance();
                String optsLang = prop.getProperty("drools.jaxb.conf.opts.lang", null);
                if (optsLang != null) {
                    this.xjcOpts.setSchemaLanguage(Language.valueOf((String)optsLang));
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return this;
    }
}

