/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.rule.builder;

import org.drools.base.base.ClassObjectType;
import org.drools.base.base.ObjectType;
import org.drools.base.base.extractors.ArrayElementReader;
import org.drools.base.definitions.rule.impl.QueryImpl;
import org.drools.base.rule.Declaration;
import org.drools.base.rule.Pattern;
import org.drools.base.rule.accessor.AcceptsReadAccessor;
import org.drools.base.rule.accessor.ReadAccessor;
import org.drools.base.rule.constraint.Constraint;
import org.drools.base.rule.constraint.QueryNameConstraint;
import org.drools.compiler.compiler.DescrBuildError;
import org.drools.compiler.rule.builder.EngineElementBuilder;
import org.drools.compiler.rule.builder.PatternBuilder;
import org.drools.compiler.rule.builder.RuleBuildContext;
import org.drools.drl.ast.descr.BaseDescr;
import org.drools.drl.ast.descr.QueryDescr;

public class PatternBuilderForQuery
implements EngineElementBuilder {
    public void build(RuleBuildContext context, QueryDescr queryDescr) {
        ClassObjectType queryObjectType = ClassObjectType.DroolsQuery_ObjectType;
        Pattern pattern = new Pattern(context.getNextPatternId(), 0, 0, (ObjectType)queryObjectType, null);
        ReadAccessor extractor = PatternBuilder.getFieldReadAccessor(context, (BaseDescr)queryDescr, pattern, "name", null, true);
        QueryNameConstraint constraint = new QueryNameConstraint(extractor, queryDescr.getName());
        PatternBuilder.registerReadAccessor(context, (ObjectType)queryObjectType, "name", (AcceptsReadAccessor)constraint);
        pattern.addConstraint((Constraint)constraint);
        ClassObjectType argsObjectType = ClassObjectType.DroolsQuery_ObjectType;
        ReadAccessor arrayExtractor = PatternBuilder.getFieldReadAccessor(context, (BaseDescr)queryDescr, null, (ObjectType)argsObjectType, "elements", null, true);
        QueryImpl query = (QueryImpl)context.getRule();
        String[] params = this.getQueryParams(queryDescr);
        String[] types = this.getQueryTypes(queryDescr, query);
        Declaration[] declarations = new Declaration[params.length];
        int i = 0;
        try {
            for (i = 0; i < params.length; ++i) {
                Declaration declr = pattern.addDeclaration(params[i]);
                ArrayElementReader reader = new ArrayElementReader(arrayExtractor, i, context.getDialect().getTypeResolver().resolveType(types[i]));
                PatternBuilder.registerReadAccessor(context, (ObjectType)argsObjectType, "elements", (AcceptsReadAccessor)reader);
                declr.setReadAccessor((ReadAccessor)reader);
                declarations[i] = declr;
            }
            query.setParameters(declarations);
        }
        catch (ClassNotFoundException e) {
            context.addError(new DescrBuildError(context.getParentDescr(), (BaseDescr)queryDescr, e, "Unable to resolve type '" + types[i] + " for parameter" + params[i]));
        }
        context.setPrefixPattern(pattern);
        this.postBuild(context, queryDescr, query, params, types, declarations);
    }

    protected void postBuild(RuleBuildContext context, QueryDescr queryDescr, QueryImpl query, String[] params, String[] types, Declaration[] declarations) {
    }

    protected String[] getQueryParams(QueryDescr queryDescr) {
        return queryDescr.getParameters();
    }

    protected String[] getQueryTypes(QueryDescr queryDescr, QueryImpl query) {
        return queryDescr.getParameterTypes();
    }
}

