/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.rule.builder;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.drools.base.base.ClassObjectType;
import org.drools.base.base.CoreComponentsBuilder;
import org.drools.base.base.ObjectType;
import org.drools.base.base.extractors.ArrayElementReader;
import org.drools.base.base.extractors.SelfReferenceClassFieldReader;
import org.drools.base.definitions.rule.impl.QueryImpl;
import org.drools.base.rule.Declaration;
import org.drools.base.rule.LogicTransformer;
import org.drools.base.rule.Pattern;
import org.drools.base.rule.QueryArgument;
import org.drools.base.rule.QueryElement;
import org.drools.base.rule.RuleConditionElement;
import org.drools.base.rule.accessor.DeclarationScopeResolver;
import org.drools.base.rule.accessor.ReadAccessor;
import org.drools.compiler.compiler.AnalysisResult;
import org.drools.compiler.compiler.BoundIdentifiers;
import org.drools.compiler.compiler.DescrBuildError;
import org.drools.compiler.lang.DescrDumper;
import org.drools.compiler.lang.DumperContext;
import org.drools.compiler.rule.builder.ConstraintBuilder;
import org.drools.compiler.rule.builder.RuleBuildContext;
import org.drools.compiler.rule.builder.RuleConditionBuilder;
import org.drools.drl.ast.descr.BaseDescr;
import org.drools.drl.ast.descr.BindingDescr;
import org.drools.drl.ast.descr.ConstraintConnectiveDescr;
import org.drools.drl.ast.descr.ExprConstraintDescr;
import org.drools.drl.ast.descr.PatternDescr;
import org.drools.drl.parser.DrlExprParser;
import org.drools.drl.parser.DrlExprParserFactory;
import org.drools.drl.parser.DroolsParserException;
import org.drools.util.ClassUtils;
import org.drools.util.StringUtils;
import org.kie.internal.builder.conf.LanguageLevelOption;

public class QueryElementBuilder
implements RuleConditionBuilder {
    private static final QueryElementBuilder INSTANCE = new QueryElementBuilder();

    public static QueryElementBuilder getInstance() {
        return INSTANCE;
    }

    public RuleConditionElement build(RuleBuildContext context, BaseDescr descr) {
        throw new UnsupportedOperationException();
    }

    public RuleConditionElement build(RuleBuildContext context, BaseDescr descr, Pattern prefixPattern) {
        throw new UnsupportedOperationException();
    }

    public RuleConditionElement build(RuleBuildContext context, BaseDescr descr, QueryImpl query) {
        boolean addAbductiveReturnArgument;
        PatternDescr patternDescr = (PatternDescr)descr;
        Declaration[] params = query.getParameters();
        List args = patternDescr.getDescrs();
        ArrayList<Declaration> requiredDeclarations = new ArrayList<Declaration>();
        ClassObjectType argsObjectType = ClassObjectType.ObjectArray_ObjectType;
        SelfReferenceClassFieldReader arrayReader = new SelfReferenceClassFieldReader(Object[].class);
        Pattern pattern = new Pattern(context.getNextPatternId(), 0, 0, (ObjectType)argsObjectType, null);
        if (!StringUtils.isEmpty((CharSequence)patternDescr.getIdentifier())) {
            if (query.isAbductive()) {
                Declaration declr = context.getDeclarationResolver().getDeclaration(patternDescr.getIdentifier());
                if (declr != null && !patternDescr.isUnification()) {
                    context.addError(new DescrBuildError(context.getParentDescr(), descr, null, "Duplicate declaration " + patternDescr.getIdentifier() + ", unable to bind abducted value"));
                }
            } else {
                context.addError(new DescrBuildError(context.getParentDescr(), descr, null, "Query binding is not supported by non-abductive queries : " + patternDescr.getIdentifier()));
            }
        }
        boolean bl = addAbductiveReturnArgument = query.isAbductive() && !StringUtils.isEmpty((CharSequence)patternDescr.getIdentifier()) && args.size() < params.length;
        if (addAbductiveReturnArgument) {
            ExprConstraintDescr extraDescr = new ExprConstraintDescr(patternDescr.getIdentifier());
            extraDescr.setPosition(patternDescr.getConstraint().getDescrs().size());
            extraDescr.setType(ExprConstraintDescr.Type.POSITIONAL);
            args.add(extraDescr);
        }
        QueryArgument[] arguments = new QueryArgument[params.length];
        for (BaseDescr base : args) {
            Object expression = null;
            boolean isPositional = false;
            boolean isBinding = false;
            BindingDescr bind = null;
            ConstraintConnectiveDescr result = null;
            if (base instanceof BindingDescr) {
                bind = (BindingDescr)base;
                expression = bind.getVariable() + (bind.isUnification() ? " := " : " : ") + bind.getExpression();
                isBinding = true;
            } else {
                if (base instanceof ExprConstraintDescr) {
                    ExprConstraintDescr ecd = (ExprConstraintDescr)base;
                    expression = ecd.getExpression();
                    isPositional = ecd.getType() == ExprConstraintDescr.Type.POSITIONAL;
                } else {
                    expression = base.getText();
                }
                result = this.parseExpression(context, patternDescr, (String)expression);
                if (result == null) {
                    context.addError(new DescrBuildError(context.getParentDescr(), descr, null, "Unable to parse constraint: \n" + (String)expression));
                    continue;
                }
                boolean bl2 = isBinding = result.getDescrs().size() == 1 && result.getDescrs().get(0) instanceof BindingDescr;
                if (isBinding) {
                    bind = (BindingDescr)result.getDescrs().get(0);
                }
            }
            if (!isPositional && !isBinding) {
                context.addError(new DescrBuildError(context.getParentDescr(), descr, null, "Query's must use positional or bindings, not field constraints:\n" + (String)expression));
                continue;
            }
            if (isPositional && isBinding) {
                context.addError(new DescrBuildError(context.getParentDescr(), descr, null, "Query's can't use positional bindings:\n" + (String)expression));
                continue;
            }
            if (isPositional) {
                this.processPositional(context, query, params, arguments, requiredDeclarations, (ReadAccessor)arrayReader, pattern, base, (String)expression, result);
                continue;
            }
            this.processBinding(context, descr, params, arguments, requiredDeclarations, (ReadAccessor)arrayReader, pattern, bind);
        }
        ArrayList<Integer> varIndexList = new ArrayList<Integer>();
        for (int i = 0; i < arguments.length; ++i) {
            Declaration formalArgument;
            Class formal;
            if (!(arguments[i] instanceof QueryArgument.Declr)) {
                if (!(arguments[i] instanceof QueryArgument.Var)) continue;
                varIndexList.add(i);
                continue;
            }
            Class actual = ((QueryArgument.Declr)arguments[i]).getArgumentClass();
            if (ClassUtils.isTypeCompatibleWithArgumentType((Class)actual, (Class)(formal = (formalArgument = query.getParameters()[i]).getDeclarationClass())) || ClassUtils.isTypeCompatibleWithArgumentType((Class)formal, (Class)actual)) continue;
            context.addError(new DescrBuildError(context.getParentDescr(), descr, null, "Query is being invoked with known argument of type " + actual + " at position " + i + ", but the expected query argument is of type " + formal));
        }
        return new QueryElement(pattern, query.getName(), arguments, LogicTransformer.toIntArray(varIndexList), requiredDeclarations.toArray(new Declaration[requiredDeclarations.size()]), !patternDescr.isQuery(), query.isAbductive());
    }

    private void processBinding(RuleBuildContext context, BaseDescr descr, Declaration[] params, QueryArgument[] arguments, List<Declaration> requiredDeclarations, ReadAccessor arrayReader, Pattern pattern, BindingDescr bind) {
        int pos;
        Declaration declr = context.getDeclarationResolver().getDeclaration(bind.getVariable());
        if (declr != null && (pos = QueryElementBuilder.getPos(bind.getExpression(), params)) >= 0) {
            String slot = bind.getExpression();
            String var = bind.getVariable();
            bind.setVariable(slot);
            bind.setExpression(var);
        }
        if ((pos = QueryElementBuilder.getPos(bind.getVariable(), params)) >= 0) {
            declr = context.getDeclarationResolver().getDeclaration(bind.getExpression());
            if (declr != null) {
                requiredDeclarations.add(declr);
                arguments[pos] = new QueryArgument.Declr(declr);
            } else {
                DrlExprParser parser = DrlExprParserFactory.getDrlExprParser((LanguageLevelOption)((LanguageLevelOption)context.getConfiguration().getOption(LanguageLevelOption.KEY)));
                ConstraintConnectiveDescr bresult = parser.parse(bind.getExpression());
                if (parser.hasErrors()) {
                    for (DroolsParserException error : parser.getErrors()) {
                        context.addError(new DescrBuildError(context.getParentDescr(), descr, null, "Unable to parser pattern expression:\n" + error.getMessage()));
                    }
                    return;
                }
                arguments[pos] = this.getLiteralQueryArgument(context, descr, bresult);
            }
        } else {
            pos = QueryElementBuilder.getPos(bind.getExpression(), params);
            if (pos < 0) {
                context.addError(new DescrBuildError(context.getParentDescr(), descr, null, "named argument does not exist:\n" + bind.getExpression()));
                return;
            }
            arguments[pos] = this.getVariableQueryArgument(arrayReader, params, pos, pattern, bind.getVariable());
        }
    }

    private void processPositional(RuleBuildContext context, QueryImpl query, Declaration[] params, QueryArgument[] arguments, List<Declaration> requiredDeclarations, ReadAccessor arrayReader, Pattern pattern, BaseDescr base, String expression, ConstraintConnectiveDescr result) {
        Declaration declr;
        int pos = ((ExprConstraintDescr)base).getPosition();
        if (pos >= arguments.length) {
            context.addError(new DescrBuildError(context.getParentDescr(), base, null, "Unable to parse query '" + query.getName() + "', as postion " + pos + " for expression '" + expression + "' does not exist on query size " + arguments.length));
            return;
        }
        boolean isVariable = QueryElementBuilder.isVariable(expression);
        DeclarationScopeResolver declarationResolver = context.getDeclarationResolver();
        Declaration declaration = declr = isVariable ? declarationResolver.getDeclaration(expression) : null;
        if (declr != null) {
            requiredDeclarations.add(declr);
            arguments[pos] = new QueryArgument.Declr(declr);
        } else if (isVariable && expression.indexOf(46) < 0) {
            arguments[pos] = this.getVariableQueryArgument(arrayReader, params, pos, pattern, expression);
        } else {
            AnalysisResult analysisResult = this.analyzeExpression(context, base, expression);
            if (analysisResult == null || analysisResult.getIdentifiers().isEmpty()) {
                arguments[pos] = this.getLiteralQueryArgument(context, base, result);
            } else {
                ArrayList<Declaration> declarations = new ArrayList<Declaration>();
                for (String identifier : analysisResult.getIdentifiers()) {
                    Declaration declaration2 = declarationResolver.getDeclaration(identifier);
                    if (declaration2 == null) continue;
                    declarations.add(declaration2);
                }
                arguments[pos] = declarations.size() == analysisResult.getIdentifiers().size() ? ConstraintBuilder.get().buildExpressionQueryArgument(context, declarations, expression) : this.getLiteralQueryArgument(context, base, result);
            }
        }
    }

    private AnalysisResult analyzeExpression(RuleBuildContext context, BaseDescr base, String expression) {
        Map decls = context.getDeclarationResolver().getDeclarations(context.getRule());
        Map declarationClasses = DeclarationScopeResolver.getDeclarationClasses((Map)decls);
        BoundIdentifiers boundIds = new BoundIdentifiers(declarationClasses, context);
        return context.getDialect().analyzeBlock(context, base, expression, boundIds);
    }

    private QueryArgument getVariableQueryArgument(ReadAccessor arrayReader, Declaration[] params, int pos, Pattern pattern, String expression) {
        ArrayElementReader reader = new ArrayElementReader(arrayReader, pos, params[pos].getDeclarationClass());
        pattern.addDeclaration(expression).setReadAccessor((ReadAccessor)reader);
        return QueryArgument.VAR;
    }

    private QueryArgument getLiteralQueryArgument(RuleBuildContext context, BaseDescr descr, ConstraintConnectiveDescr result) {
        DumperContext mvelCtx = new DumperContext();
        String expr = DescrDumper.getInstance().dump((BaseDescr)result, mvelCtx);
        try {
            Object value = CoreComponentsBuilder.get().evaluateMvelExpression(context.getPkg().getDialectRuntimeRegistry().getDialectData("mvel"), context.getKnowledgeBuilder().getRootClassLoader(), expr);
            return new QueryArgument.Literal(value);
        }
        catch (Exception e) {
            context.addError(new DescrBuildError(context.getParentDescr(), descr, null, "Unable to compile expression: " + expr));
            return null;
        }
    }

    private static int getPos(String identifier, Declaration[] params) {
        for (int i = 0; i < params.length; ++i) {
            if (!params[i].getIdentifier().trim().equals(identifier)) continue;
            return i;
        }
        return -1;
    }

    private ConstraintConnectiveDescr parseExpression(RuleBuildContext context, PatternDescr patternDescr, String expression) {
        DrlExprParser parser = DrlExprParserFactory.getDrlExprParser((LanguageLevelOption)((LanguageLevelOption)context.getConfiguration().getOption(LanguageLevelOption.KEY)));
        ConstraintConnectiveDescr result = parser.parse(expression);
        if (result == null || parser.hasErrors()) {
            for (DroolsParserException error : parser.getErrors()) {
                context.addError(new DescrBuildError(context.getParentDescr(), (BaseDescr)patternDescr, null, "Unable to parser pattern expression:\n" + error.getMessage()));
            }
            return null;
        }
        return result;
    }

    private static boolean isVariable(String str) {
        return StringUtils.isDereferencingIdentifier((String)(str = str.trim())) && !str.endsWith(".class");
    }
}

