/*
 * Decompiled with CFR 0.152.
 */
package org.drools.codegen.common.di.impl;

import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.expr.AnnotationExpr;
import com.github.javaparser.ast.expr.BinaryExpr;
import com.github.javaparser.ast.expr.BooleanLiteralExpr;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.MemberValuePair;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.expr.Name;
import com.github.javaparser.ast.expr.NameExpr;
import com.github.javaparser.ast.expr.NormalAnnotationExpr;
import com.github.javaparser.ast.expr.SingleMemberAnnotationExpr;
import com.github.javaparser.ast.expr.StringLiteralExpr;
import com.github.javaparser.ast.nodeTypes.NodeWithAnnotations;
import org.drools.codegen.common.di.DependencyInjectionAnnotator;

public class CDIDependencyInjectionAnnotator
implements DependencyInjectionAnnotator {
    @Override
    public <T extends NodeWithAnnotations<?>> T withProduces(T node, boolean isDefault) {
        node.addAndGetAnnotation("jakarta.enterprise.inject.Produces");
        if (isDefault) {
            node.addAndGetAnnotation("io.quarkus.arc.DefaultBean");
        }
        return node;
    }

    @Override
    public <T extends NodeWithAnnotations<?>> T withNamed(T node, String name) {
        node.addAnnotation((AnnotationExpr)new SingleMemberAnnotationExpr(new Name("jakarta.inject.Named"), (Expression)new StringLiteralExpr(name)));
        return node;
    }

    @Override
    public <T extends NodeWithAnnotations<?>> T withApplicationComponent(T node) {
        node.addAnnotation("jakarta.enterprise.context.ApplicationScoped");
        return node;
    }

    @Override
    public <T extends NodeWithAnnotations<?>> T withNamedApplicationComponent(T node, String name) {
        return this.withNamed(this.withApplicationComponent(node), name);
    }

    @Override
    public <T extends NodeWithAnnotations<?>> T withSingletonComponent(T node) {
        node.addAnnotation("jakarta.inject.Singleton");
        return node;
    }

    @Override
    public <T extends NodeWithAnnotations<?>> T withNamedSingletonComponent(T node, String name) {
        return this.withNamed(this.withSingletonComponent(node), name);
    }

    @Override
    public <T extends NodeWithAnnotations<?>> T withInjection(T node, boolean lazy) {
        node.addAnnotation("jakarta.inject.Inject");
        return node;
    }

    @Override
    public <T extends NodeWithAnnotations<?>> T withNamedInjection(T node, String name) {
        return this.withNamed(this.withInjection(node), name);
    }

    @Override
    public <T extends NodeWithAnnotations<?>> T withOptionalInjection(T node) {
        return this.withInjection(node);
    }

    @Override
    public <T extends NodeWithAnnotations<?>> T withIncomingMessage(T node, String channel) {
        node.addAnnotation((AnnotationExpr)new SingleMemberAnnotationExpr(new Name("org.eclipse.microprofile.reactive.messaging.Incoming"), (Expression)new StringLiteralExpr(channel)));
        return node;
    }

    @Override
    public <T extends NodeWithAnnotations<?>> T withOutgoingMessage(T node, String channel) {
        node.addAnnotation((AnnotationExpr)new SingleMemberAnnotationExpr(new Name("org.eclipse.microprofile.reactive.messaging.Channel"), (Expression)new StringLiteralExpr(channel)));
        return node;
    }

    @Override
    public MethodCallExpr withMessageProducer(MethodCallExpr produceMethod, String channel, Expression event) {
        produceMethod.addArgument(event);
        return produceMethod;
    }

    @Override
    public String optionalInstanceInjectionType() {
        return "jakarta.enterprise.inject.Instance";
    }

    @Override
    public Expression optionalInstanceExists(String fieldName) {
        MethodCallExpr condition = new MethodCallExpr((Expression)new NameExpr(fieldName), "isUnsatisfied");
        return new BinaryExpr((Expression)condition, (Expression)new BooleanLiteralExpr(false), BinaryExpr.Operator.EQUALS);
    }

    @Override
    public String multiInstanceInjectionType() {
        return this.optionalInstanceInjectionType();
    }

    @Override
    public Expression getMultiInstance(String fieldName) {
        return new MethodCallExpr((Expression)new MethodCallExpr((Expression)new NameExpr("java.util.stream.StreamSupport"), "stream", NodeList.nodeList((Node[])new Expression[]{new MethodCallExpr((Expression)new NameExpr(fieldName), "spliterator"), new BooleanLiteralExpr(false)})), "collect", NodeList.nodeList((Node[])new Expression[]{new MethodCallExpr((Expression)new NameExpr("java.util.stream.Collectors"), "toList")}));
    }

    @Override
    public String applicationComponentType() {
        return "jakarta.enterprise.context.ApplicationScoped";
    }

    @Override
    public String emitterType(String dataType) {
        return "org.eclipse.microprofile.reactive.messaging.Emitter<" + dataType + ">";
    }

    @Override
    public <T extends NodeWithAnnotations<?>> T withConfigInjection(T node, String configKey) {
        node.addAnnotation((AnnotationExpr)new NormalAnnotationExpr(new Name("org.eclipse.microprofile.config.inject.ConfigProperty"), NodeList.nodeList((Node[])new MemberValuePair[]{new MemberValuePair("name", (Expression)new StringLiteralExpr(configKey))})));
        return node;
    }

    @Override
    public <T extends NodeWithAnnotations<?>> T withConfigInjection(T node, String configKey, String defaultValue) {
        node.addAnnotation((AnnotationExpr)new NormalAnnotationExpr(new Name("org.eclipse.microprofile.config.inject.ConfigProperty"), NodeList.nodeList((Node[])new MemberValuePair[]{new MemberValuePair("name", (Expression)new StringLiteralExpr(configKey)), new MemberValuePair("defaultValue", (Expression)new StringLiteralExpr(defaultValue))})));
        return node;
    }

    @Override
    public <T extends NodeWithAnnotations<?>> T withEagerStartup(T node) {
        node.addAnnotation("io.quarkus.runtime.Startup");
        return node;
    }

    @Override
    public <T extends NodeWithAnnotations<?>> T withFactoryClass(T node) {
        return node;
    }

    @Override
    public <T extends NodeWithAnnotations<?>> T withFactoryMethod(T node) {
        node.addAnnotation("jakarta.enterprise.inject.Produces");
        return node;
    }

    @Override
    public <T extends NodeWithAnnotations<?>> T withTagAnnotation(T node, NodeList<MemberValuePair> attributes) {
        node.addAnnotation((AnnotationExpr)new NormalAnnotationExpr(new Name("org.eclipse.microprofile.openapi.annotations.tags.Tag"), attributes));
        return node;
    }
}

