/*
 * Decompiled with CFR 0.152.
 */
package org.drools.model.impl;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.drools.model.AnnotationValue;
import org.drools.model.TypeMetaData;
import org.drools.model.impl.ModelComponent;

public class TypeMetaDataImpl
implements TypeMetaData,
ModelComponent {
    private final Class<?> type;
    private final String pkg;
    private final String name;
    private final Map<String, AnnotationValue[]> annotations = new HashMap<String, AnnotationValue[]>();
    private final Map<String, TypeMetaData.FieldMetaData> fields = new HashMap<String, TypeMetaData.FieldMetaData>();

    public TypeMetaDataImpl(Class<?> type) {
        this.type = type;
        this.pkg = type.getPackage().getName();
        this.name = type.getSimpleName();
    }

    @Override
    public String getPackage() {
        return this.pkg;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Class<?> getType() {
        return this.type;
    }

    @Override
    public Map<String, AnnotationValue[]> getAnnotations() {
        return this.annotations;
    }

    @Override
    public List<TypeMetaData.FieldMetaData> getFields() {
        return new ArrayList<TypeMetaData.FieldMetaData>(this.fields.values());
    }

    public TypeMetaDataImpl addAnnotation(String name, AnnotationValue ... values) {
        this.annotations.put(name, values);
        return this;
    }

    public TypeMetaDataImpl addField(String fieldName) {
        this.fields.computeIfAbsent(fieldName, FieldMetaDataImpl::new);
        return this;
    }

    public TypeMetaDataImpl addFieldAnnotation(String fieldName, String annotationName, AnnotationValue ... values) {
        FieldMetaDataImpl fieldMetaData = (FieldMetaDataImpl)this.fields.computeIfAbsent(fieldName, FieldMetaDataImpl::new);
        fieldMetaData.addAnnotation(annotationName, values);
        return this;
    }

    public TypeMetaDataImpl withField(String fieldName) {
        return this.addField(fieldName);
    }

    public TypeMetaDataImpl withFieldAnnotation(String fieldName, String annotationName, AnnotationValue ... values) {
        return this.addFieldAnnotation(fieldName, annotationName, values);
    }

    @Override
    public boolean isEqualTo(ModelComponent o) {
        Field[] otherFields;
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TypeMetaDataImpl other = (TypeMetaDataImpl)o;
        if (!this.pkg.equals(other.pkg)) {
            return false;
        }
        if (!this.name.equals(other.name)) {
            return false;
        }
        Field[] thisFields = this.type.getDeclaredFields();
        if (thisFields.length != (otherFields = other.type.getDeclaredFields()).length) {
            return false;
        }
        Arrays.sort(thisFields, Comparator.comparing(Field::getName));
        Arrays.sort(otherFields, Comparator.comparing(Field::getName));
        for (int i = 0; i < thisFields.length; ++i) {
            if (thisFields[i].getName().equals(otherFields[i].getName()) && thisFields[i].getType().equals(otherFields[i].getType())) continue;
            return false;
        }
        return true;
    }

    public static class FieldMetaDataImpl
    implements TypeMetaData.FieldMetaData {
        private final String fieldName;
        private final Map<String, AnnotationValue[]> annotations = new HashMap<String, AnnotationValue[]>();

        public FieldMetaDataImpl(String fieldName) {
            this.fieldName = fieldName;
        }

        @Override
        public String getFieldName() {
            return this.fieldName;
        }

        @Override
        public Map<String, AnnotationValue[]> getAnnotations() {
            return this.annotations;
        }

        public FieldMetaDataImpl addAnnotation(String name, AnnotationValue ... values) {
            this.annotations.put(name, values);
            return this;
        }
    }
}

